package com.quantgroup.asset.distribution.enums;

import com.quantgroup.asset.distribution.exception.QGException;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import com.quantgroup.asset.distribution.exception.QGPreconditions;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * @author : Hyuk
 * @description : RuleOperator
 * @date : 2020/3/5 5:08 下午
 */
@Slf4j
public enum RuleOperator {

    GreaterThan(">", "大于"),
    GreaterThanOrEqual(">=", "大于"),
    LessThan("<", "小于"),
    Equal("=", "等于"),
    In("in", "包含"),
    NotIn("exclude", "不包含"),
    NotEqual("!=", "不等于"),
    LessThanOrEqual("<=", "小于");


    private String code;
    private String description;

    RuleOperator(String code, String description) {
        this.code = code;
        this.description = description;
    }


    public static RuleOperator fromCode(String code) {
        QGPreconditions.checkArgument(StringUtils.isNoneBlank(code), QGExceptionType.COMMON_STRING_PARAM_IS_ALL_NULL, "操作");
        for (RuleOperator ruleOperator : RuleOperator.values()) {
            if (StringUtils.equalsAnyIgnoreCase(code, ruleOperator.code)) {
                return ruleOperator;
            }
        }
        log.error("枚举不存在,code={}", code);
        throw new QGException(QGExceptionType.COMMON_ILLEGAL_PARAM);
    }
}
