package com.quantgroup.asset.distribution.service.distribute.impl;


import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.quantgroup.asset.distribution.constant.StatusConstants;
import com.quantgroup.asset.distribution.model.entity.DistributeRecord;
import com.quantgroup.asset.distribution.service.distribute.IAssetDistributeRecordService;
import com.quantgroup.asset.distribution.service.jpa.entity.Asset;
import com.quantgroup.asset.distribution.service.jpa.entity.AssetDistributeRecord;
import com.quantgroup.asset.distribution.service.jpa.repository.IAssetDistributeRecordRepository;
import com.quantgroup.asset.distribution.service.redis.IRedisService;

import lombok.extern.slf4j.Slf4j;

/**
 * 资产分发日志记录表
 * @author liwenbin
 *
 */
@Slf4j
@Service
public class AssetDistributeRecordServiceImpl implements IAssetDistributeRecordService{
	
	@Autowired
	private IAssetDistributeRecordRepository assetDistributeRecordRepository;
	@Autowired
	private IRedisService<Integer> redisService;
		
	@Override
	public void saveDistributeRecord(Asset asset, DistributeRecord distributeRecord, Boolean distributeStatus, int ruleType) {
		try {
			AssetDistributeRecord assetDistributeRecord = new AssetDistributeRecord();
			assetDistributeRecord.setAssetNo(asset.getAssetNo());
			assetDistributeRecord.setUuid(asset.getUuid());
			assetDistributeRecord.setUserLoanType(asset.getUserLoanType());
			assetDistributeRecord.setBizChannel(asset.getBizChannel());
			assetDistributeRecord.setFinanceProductType(asset.getFinanceProductType());
			assetDistributeRecord.setBizNo(asset.getBizNo());
			assetDistributeRecord.setAssetDistributeTravel(JSON.toJSONString(distributeRecord));
			assetDistributeRecord.setAssetDistributeTarget(ruleType);
			assetDistributeRecord.setAssetDistributeStatus(distributeStatus == true ? StatusConstants.SUCCESS : StatusConstants.FAIL);
			assetDistributeRecord.setEnable(true);
			assetDistributeRecordRepository.save(assetDistributeRecord);
			// 完成一次分发，清除分发记录
			distributeRecord.clearRecords();
		} catch (Exception e) {
			log.error("用户记录分发日志异常, uuid : {}", asset.getUuid(), e);
		}
	}
	
	@Override
	public List<AssetDistributeRecord> getDistributeRecord(String assetNo) {
		return assetDistributeRecordRepository.findByAssetNo(assetNo);
	}
}
