package com.quantgroup.asset.distribution.service.newrule;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author shihuajun
 * @date 2021/8/27 10:58
 * @ describing
 */
@Component
public class RuleHandleFactory {
    @Resource
    private Map<String, IRuleVerifyService> ruleVerifyServiceMap;

    public IRuleVerifyService getRuleVerifyServiceMap(String className) {
        if (StringUtils.isBlank(className)){
            throw new RuntimeException("获取IRuleVerifyService入参有问题");
        }
        if (ruleVerifyServiceMap.containsKey(className)){
            return ruleVerifyServiceMap.get(className);
        }else {
            throw new RuntimeException("获取IRuleVerifyService入参有问题，没有对应的实现类");
        }
    }
}
