package com.quantgroup.asset.distribution.controller.route.fundproduct;

import com.quantgroup.asset.distribution.enums.route.BusinessType;
import com.quantgroup.asset.distribution.enums.route.FundType;
import com.quantgroup.asset.distribution.enums.route.OrganizationType;
import com.quantgroup.asset.distribution.enums.route.SystemType;
import com.quantgroup.asset.distribution.model.entity.route.fundproduct.FundProductQueryVo;
import com.quantgroup.asset.distribution.model.entity.route.fundproduct.FundProductSaveVo;
import com.quantgroup.asset.distribution.model.entity.route.fundproduct.FundProductVo;
import com.quantgroup.asset.distribution.model.entity.route.fundproduct.TypeVo;
import com.quantgroup.asset.distribution.model.response.GlobalResponse;
import com.quantgroup.asset.distribution.service.newrule.pojo.enums.AreaEnum;
import com.quantgroup.asset.distribution.service.newrule.pojo.enums.IdCardExpireEnum;
import com.quantgroup.asset.distribution.service.route.IFundProductService;
import com.quantgroup.asset.distribution.util.AllRecords;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

/**
 * 资金产品列表
 * @author wyx 2021-08-29
 */
@Slf4j
@RestController
@RequestMapping("/fundproduct")
public class FundProductController {

    @Autowired
    private IFundProductService fundProductService;
    /**
     * 分页查询
     * @param fundProductQueryVo
     * @return
     */
    @RequestMapping(value = "/queryPage",method = RequestMethod.POST)
    public GlobalResponse queryPage(@RequestBody FundProductQueryVo fundProductQueryVo){
        AllRecords allRecords = fundProductService.queryPage(fundProductQueryVo);
        return GlobalResponse.success(allRecords);
    }

    /**
     * 资金类型下拉框
     * @return
     */
    @RequestMapping("/getFundType")
    public GlobalResponse getFundType(){
        List<TypeVo> list = new ArrayList<>();
        for (FundType fundType:FundType.values()){
            TypeVo typeVo = new TypeVo();
            typeVo.setCode(fundType.getValue());
            typeVo.setName(fundType.getDesc());
            list.add(typeVo);
        }
        return GlobalResponse.success(list);
    }

    /**
     * 机构类型下拉框
     * @return
     */
    @RequestMapping("/getOrganizationType")
    public GlobalResponse getOrganizationType(){
        List<TypeVo> list = new ArrayList<>();
        for (OrganizationType organizationType:OrganizationType.values()){
            TypeVo typeVo = new TypeVo();
            typeVo.setCode(organizationType.getValue());
            typeVo.setName(organizationType.getDesc());
            list.add(typeVo);
        }
        return GlobalResponse.success(list);
    }

    /**
     * 业务类型下拉框
     * @return
     */
    @RequestMapping("/getBusinessType")
    public GlobalResponse getBusinessType(){
        List<TypeVo> list = new ArrayList<>();
        for (BusinessType businessType:BusinessType.values()){
            TypeVo typeVo = new TypeVo();
            typeVo.setCode(businessType.getValue());
            typeVo.setName(businessType.getDesc());
            list.add(typeVo);
        }
        return GlobalResponse.success(list);
    }

    /**
     * 业务系统下拉框
     * @return
     */
    @RequestMapping("/getSystemType")
    public GlobalResponse getSystemType(){
        List<TypeVo> list = new ArrayList<>();
        for (SystemType systemType:SystemType.values()){
            TypeVo typeVo = new TypeVo();
            typeVo.setCode(systemType.getValue());
            typeVo.setName(systemType.getDesc());
            list.add(typeVo);
        }
        return GlobalResponse.success(list);
    }


    /**
     * 编辑或查看资金产品信息
     * @param id
     * @return
     */
    @RequestMapping("/lookFundProduct")
    public GlobalResponse lookFundProduct(Long id){
        FundProductVo fundProductVo = fundProductService.lookFundProduct(id);
        return GlobalResponse.success(fundProductVo);
    }

    /**
     * 地区要求下拉框
     * @return
     */
    @RequestMapping("/getAreaRequire")
    public GlobalResponse getAreaRequire(){
        List<TypeVo> list = new ArrayList<>();
        for (AreaEnum areaEnum:AreaEnum.values()){
            TypeVo typeVo = new TypeVo();
            typeVo.setCode(String.valueOf(areaEnum.getCode()));
            typeVo.setName(areaEnum.getDesc());
            list.add(typeVo);
        }
        return GlobalResponse.success(list);
    }

    /**
     * 身份证有效期下拉框
     * @return
     */
    @RequestMapping("/getIdCardExpire")
    public GlobalResponse getIdCardExpire(){
        List<TypeVo> list = new ArrayList<>();
        for (IdCardExpireEnum idCardExpireEnum:IdCardExpireEnum.values()){
            TypeVo typeVo = new TypeVo();
            typeVo.setCode(String.valueOf(idCardExpireEnum.getCode()));
            typeVo.setName(idCardExpireEnum.getDesc());
            list.add(typeVo);
        }
        return GlobalResponse.success(list);
    }

    /**
     * 保存接口
     * @param fundProductSaveVo
     * @param bindingResult
     * @return
     */
    @RequestMapping(value = "/save",method = RequestMethod.POST)
    public GlobalResponse save(@RequestBody@Valid FundProductSaveVo fundProductSaveVo, BindingResult bindingResult){
        if (bindingResult.hasErrors()){
            return GlobalResponse.error(bindingResult.getFieldError().getDefaultMessage());
        }
        return fundProductService.save(fundProductSaveVo);
    }

    /**
     * 获取省市区分级数据
     * @return
     */
    @RequestMapping("/getArea")
    public GlobalResponse getArea(){
        try {
            return fundProductService.getArea();
        }catch (Exception e){
            log.error("获取省市区信息异常",e);
            return GlobalResponse.error("获取省市区信息异常");
        }
    }

}
