package com.quantgroup.asset.distribution.controller.route.channelroute;

import com.quantgroup.asset.distribution.enums.route.UserLevel;
import com.quantgroup.asset.distribution.enums.route.UserTag;
import com.quantgroup.asset.distribution.model.entity.route.channelroute.ChannelRouteAddVo;
import com.quantgroup.asset.distribution.model.entity.route.channelroute.ChannelRouteQueryVo;
import com.quantgroup.asset.distribution.model.entity.route.channelroute.FundProInfoVo;
import com.quantgroup.asset.distribution.model.entity.route.fundproduct.TypeVo;
import com.quantgroup.asset.distribution.model.response.GlobalResponse;
import com.quantgroup.asset.distribution.service.route.IChannelRouteService;
import com.quantgroup.asset.distribution.util.AllRecords;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

/**
 * 渠道路由配置接口
 * @author wyx  2021-08-28
 */
@Slf4j
@RestController
@RequestMapping("/channelroute")
@CrossOrigin
public class ChannelRouteController {

    @Autowired
    private IChannelRouteService channelRouteService;

    /**
     * 分页查询
     * @param channelRouteQueryVo
     * @return
     */
    @RequestMapping(value = "/queryPage",method = RequestMethod.POST)
    public GlobalResponse queryPage(@RequestBody ChannelRouteQueryVo channelRouteQueryVo){
        AllRecords allRecords = channelRouteService.queryPage(channelRouteQueryVo);
        return GlobalResponse.success(allRecords);
    }

    /**
     * 查询已经配置过的渠道,下拉框
     * @return
     */
    @RequestMapping("/queryConfigChannelIds")
    public GlobalResponse queryConfigChannelIds(){
        List<Long> channelIdList = channelRouteService.queryConfigChannelIds();
        return GlobalResponse.success(channelIdList);
    }

    /**
     * 根据渠道号查询渠道配置过的渠道路由信息
     * @param channelId
     * @return
     */
    @RequestMapping("/queryConfigChannelInfo")
    public GlobalResponse queryConfigChannelInfo(@NotNull Long channelId){
        return channelRouteService.queryConfigChannelInfo(channelId);
    }

    /**
     * 选择资金编号下拉框
     * @return
     */
    @RequestMapping("/getFundIds")
    public GlobalResponse getFundIds(){
        List<Long> fundIdList = channelRouteService.getFundIds();
        return GlobalResponse.success(fundIdList);
    }

    /**
     * 根据资金编号查询资金产品编号
     * @param fundId
     * @return
     */
    @RequestMapping("/getFundCorpIdByFundId")
    public GlobalResponse getFundCorpIdByFundId(@NotNull Long fundId){
        List<Long> fundCorpIdList = channelRouteService.getFundCorpIdByFundId(fundId);
        return GlobalResponse.success(fundCorpIdList);
    }

    /**
     * 根据资金编号+资金产品编号查询资金名称、资金类型、机构类型、业务类型、业务系统
     * @param fundId
     * @param fundCorpId
     * @return
     */
    @RequestMapping("/getFundProductInfo")
    public GlobalResponse getFundProductInfo(@NotNull Long fundId,@NotNull Long fundCorpId){
        FundProInfoVo fundProInfoVo = channelRouteService.getFundProductInfo(fundId,fundCorpId);
        return GlobalResponse.success(fundProInfoVo);
    }

    /**
     * 获取用户标签下拉框
     * @return
     */
    @RequestMapping("/getUserTag")
    public GlobalResponse getUserTag(){
        List<TypeVo> list = new ArrayList<>();
        for (UserTag userTag:UserTag.values()){
            TypeVo typeVo = new TypeVo();
            typeVo.setCode(userTag.getValue());
            typeVo.setName(userTag.getDesc());
            list.add(typeVo);
        }
        return GlobalResponse.success(list);
    }

    /**
     * 获取用户等级下拉框
     * @return
     */
    @RequestMapping("/getUserLevel")
    public GlobalResponse getUserLevel(){
        List<TypeVo> list = new ArrayList<>();
        for (UserLevel userLevel:UserLevel.values()){
            TypeVo typeVo = new TypeVo();
            typeVo.setCode(userLevel.getValue());
            typeVo.setName(userLevel.getDesc());
            list.add(typeVo);
        }
        return GlobalResponse.success(list);
    }

    /**
     * 新增渠道配置信息
     * @param channelRouteAddVo
     * @return
     */
    @RequestMapping("/addChannelConfig")
    public GlobalResponse addChannelConfig(@RequestBody@Valid ChannelRouteAddVo channelRouteAddVo, BindingResult bindingResult){
        if (bindingResult.hasErrors()){
            return GlobalResponse.error(bindingResult.getFieldError().getDefaultMessage());
        }
        return channelRouteService.addChannelConfig(channelRouteAddVo.getChannelRouteSaveVoList(),channelRouteAddVo.getType());
    }

    /**
     * 发布渠道配置信息
     * @return
     */
    @RequestMapping("/publishChannelConfig")
    public GlobalResponse publishChannelConfig(Long channelId){
        channelRouteService.publishChannelConfig(channelId);
        return GlobalResponse.success();
    }

    /**
     * 更新渠道配置信息，未更新前使用原有配置
     * @param channelId
     * @return
     */
    @RequestMapping("/updateChannelConfig")
    public GlobalResponse updateChannelConfig(Long channelId){
        channelRouteService.updateChannelConfig(channelId);
        return GlobalResponse.success();
    }
}
