package com.quantgroup.asset.distribution.service.funding;

import com.quantgroup.asset.distribution.model.response.GlobalResponse;

/**
 * 资方模块Service
 * @author liwenbin
 *
 */
public interface IFundModuleService {
	
	/**
	 * 获取所有资方信息
	 * @return
	 */
	public GlobalResponse getAllFundsInfo();
	
	/**
	 * 获取资方配置所有条件类型， 以及对应的code
	 * @return
	 */
	public GlobalResponse getAllLimitType();
	
	/**
	 * 保存或更改渠道资方配置
	 * @return
	 */
	public GlobalResponse saveChannelFundConfig(Integer type, Long id, String bizChannel, String funds, String remarks);
	
	/**
	 * 获取渠道资方配置信息
	 * @param bizChannel
	 * @param fundId
	 * @param pageNum
	 * @param pageSize
	 * @return
	 */
	public GlobalResponse getChannelFundConfigs(String bizChannel, Long fundId, Integer pageNum, Integer pageSize);
}
