package com.quantgroup.asset.distribution.service.jpa.entity;

import java.io.Serializable;
import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;

import lombok.Data;

/**
 * 资产分发规则配置表
 * @author liwenbin
 *
 */
@Table(name = "asset_distribute_rule_config")
@Entity
@Data
public class AssetDistributeRuleConfig implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;
	
	@Column(name = "asset_distribute_rule_no")
	private String assetDistributeRuleNo;
	
	@Column(name = "asset_distribute_rule_name")
	private String assetDistributeRuleName;
	
	@Column(name = "asset_distribute_rule_type")
	private Integer assetDistributeRuleType;
	
	@Column(name = "asset_distribute_rule_el")
	private String assetDistributeRuleEl;
	
	@Column(name = "asset_distribute_rule_priority")
	private Integer assetDistributeRulePriority;
	
	@Column(name = "asset_distribute_rule_switch")
	private Integer assetDistributeRuleSwitch;
	
	@Column(name = "enable")
	private Boolean enable;
	
	@Column(name = "created_by")
	private String createdBy;
	
	@Column(name = "updated_by")
	private String updatedBy;
	
	@Column(name = "created_at")
	private Timestamp createdAt;
	
	@Column(name = "updated_at")
	private Timestamp updatedAt;
	
	@PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
