package com.quantgroup.asset.distribution.controller.route.whitelist;

import com.quantgroup.asset.distribution.model.entity.route.whitelist.WhiteListQueryVo;
import com.quantgroup.asset.distribution.model.entity.route.whitelist.WhiteListSaveVo;
import com.quantgroup.asset.distribution.model.response.GlobalResponse;
import com.quantgroup.asset.distribution.service.route.IWhiteListService;
import com.quantgroup.asset.distribution.util.AllRecords;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * 白名单配置页面接口
 */
@Slf4j
@RestController
@RequestMapping("/whitelist")
public class WhiteListController {

    @Autowired
    private IWhiteListService whiteListService;
    /**
     * 分页查询
     * @param whiteListQueryVo
     * @return
     */
    @RequestMapping(value = "/queryPage",method = RequestMethod.POST)
    public GlobalResponse queryPage(@RequestBody WhiteListQueryVo whiteListQueryVo){
        AllRecords allRecords = whiteListService.queryPage(whiteListQueryVo);
        return GlobalResponse.success(allRecords);
    }

    /**
     * 启用停用
     * @param id
     * @param status
     * @return
     */
    @RequestMapping("/updateStatus")
    public GlobalResponse updateStatus(@NotNull Long id, @NotNull Byte status){
        return whiteListService.updateStatus(id,status);
    }

    /**
     * 新增白名单配置
     * @param whiteListSaveVo
     * @return
     */
    @RequestMapping("/save")
    public GlobalResponse save(@RequestBody@Valid WhiteListSaveVo whiteListSaveVo, BindingResult bindingResult){
        if (bindingResult.hasErrors()){
            return GlobalResponse.error(bindingResult.getFieldError().getDefaultMessage());
        }
        return whiteListService.save(whiteListSaveVo);
    }
}
