package com.quantgroup.asset.distribution.service.authority.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.quantgroup.asset.distribution.service.authority.IAuthorityService;
import com.quantgroup.asset.distribution.service.jpa.entity.AuthorityConfig;
import com.quantgroup.asset.distribution.service.jpa.repository.IAuthorityRepository;

import lombok.extern.slf4j.Slf4j;

/**
 * 权限配置Service
 * @author liwenbin
 *
 */
@Slf4j
@Service
public class AuthorityServiceImpl implements IAuthorityService{
	
	@Autowired
	private IAuthorityRepository authorityRepository;
	
	@Override
	@Cacheable(value="cacheManager",key="#authKey+'_'+#authPass+'_1021ASSET_AUTHORITY'")
	public AuthorityConfig findByAuthKeyAndAuthPass(String authKey, String authPass) {
		return authorityRepository.findByAuthKeyAndAuthPassAndEnableIsTrue(authKey, authPass);
	}

	@Override
	@CacheEvict(value = "cacheManager", key = "#authKey+'_'+#authPass+'_1021ASSET_AUTHORITY'")
	public void clearCacheByAuthKeyAndAuthPass(String authKey, String authPass) {
		log.info("权限配置清楚缓存成功, authKey = {}, authPass = {}", authKey, authPass);
	}
}
