package com.quantgroup.asset.distribution.config.rabbitmq;

import cn.quantgroup.tech.brave.service.ITechRabbitBuilder;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistrar;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;

import javax.annotation.Resource;
import java.io.IOException;

@Slf4j
@Configuration
@EnableRabbit
public class ConsumerConfig implements RabbitListenerConfigurer {

    @Resource
    private ITechRabbitBuilder techRabbitBuilder;

    @Bean
    public DefaultMessageHandlerMethodFactory myHandlerMethodFactory() {
        DefaultMessageHandlerMethodFactory factory = new DefaultMessageHandlerMethodFactory();
        factory.setMessageConverter(new MappingJackson2MessageConverter());
        return factory;
    }

    @Bean(name="rabbitListenerContainerFactory")
    public SimpleRabbitListenerContainerFactory rabbitListenerContainerFactory(@Qualifier("assetDistributionConnectionFactory")CachingConnectionFactory assetDistributionConnectionFactory) {
        SimpleRabbitListenerContainerFactory factory = techRabbitBuilder.createSimpleRabbitListenerContainerFactory(assetDistributionConnectionFactory);
        factory.setPrefetchCount(100);
        factory.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        return factory;
    }

    @Override
    public void configureRabbitListeners(RabbitListenerEndpointRegistrar registrar) {
        registrar.setMessageHandlerMethodFactory(myHandlerMethodFactory());
    }



    @RabbitListener(bindings = {@QueueBinding(value = @Queue(value = "funding.state"), exchange = @Exchange(value = "xyqb.change.fanout"))})
    public void process(Message message, Channel channel) throws IOException {

        try{
            log.info("======接收到消息====== : {}",new String(message.getBody(),"utf-8"));
            // 采用手动应答模式, 手动确认应答更为安全稳定
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
        }catch(IOException e){
            //重新放回队列
            channel.basicNack(message.getMessageProperties().getDeliveryTag(),false,true);
        }


    }





}

