/**
 * 
 */
package com.quantgroup.asset.distribution.service.redis;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;


/**
 *
 * @author renfeng
 * @date: 2017年3月30日 下午7:31:58
 * @version v1.0
 * @param <T>
 */
public interface IRedisService<T> {
	/**
	 * 保存字符串
	 * @param key
	 * @param value
	 */
	public void setString(String key, String value);
	/**
	 * 保存字符串 含过期时间
	 * @param key
	 * @param value
	 * @param time
	 * @param timeUnit
	 */
	public void setStringEx(String key, String value, long time, TimeUnit timeUnit);

	/**
	 * 获取字符串
	 * @param key
	 * @return
	 */
	public String getString(String key);
	/**
	 * 保存实体类
	 * @param key
	 * @param entity
	 */
	public void setEntity(String key, T entity);
	public void setEntityEx(String key, T entity, long time, TimeUnit timeUnit);
	/**
	 * 查询实体类
	 * @param key
	 * @return
	 */
	public T getEntity(String key);
	/**
	 * 保存list
	 * @param key
	 * @param list
	 */
	public void setList(String key, List<T> list);
	/**
	 *
	 * @param key
	 * @param list
	 * @param time
	 * @param timeUnit
	 */
	public void setListEx(String key, List<T> list, long time, TimeUnit timeUnit);
	/**
	 * 查询list
	 * @param key
	 * @return
	 */
	public List<T> getList(String key);
	/**
	 * 尾部追加
	 * @param key
	 * @param value
	 * @param time
	 * @param timeUnit
	 */
	public void rightPushEx(String key, T value, long time, TimeUnit timeUnit);
	/**
	 * 头部移除
	 * @param key
	 */
	public T leftPop(String key);
	/**
	 * 删除元素
	 * @param key
	 * @param value
	 * @param count
	 */
	public void listRemove(String key, T value, int count);
	/**
	 * 保存map含过期时间
	 * @param key
	 * @param map
	 * @param time
	 * @param timeUnit
	 */
	public void setMapEx(String key, Map<String, T> map, long time, TimeUnit timeUnit);
	/**
	 * 获取map
	 * @param key
	 * @return
	 */
	public Map<Object,Object> getMapEx(String key);
	/**
	 * hmset
	 * @param key
	 * @param hashKey
	 * @param value
	 */
	public void hmset(String key, String hashKey, T value, long time, TimeUnit timeUnit);
	/**
	 * hmget
	 * @param key
	 * @param hashKey
	 * @return
	 */
	public T hmget(String key, String hashKey);
	/**
	 * 获取map长度
	 * @param key
	 * @return
	 */
	public Long hmgetSize(String key);
	/**
	 * 原子性操作
	 * @param key
	 * @param time
	 * @param timeUnit
	 * @return
	 */
	public boolean setIfAbsent(String key, String value, long time, TimeUnit timeUnit);
	/**
	 * 原子性自增
	 * @param key
	 * @param value
	 * @return
	 */
	public long setIncr(String key, long value, long time, TimeUnit timeUnit);
	/**
	 * 删除
	 * @param key
	 */
	public void del(String key);
	/**
	 * list size
	 * @param key
	 * @return
	 */
	public long listSize(String key);
	
	/**
	 * 
	 * @param key
	 * @param expireTime
	 * @param retryTimes 重试获取锁次数
	 * @param sleepMillis	休眠时间
	 * @return
	 */
	public boolean lock(String key, Long expireTime, Integer retryTimes, Long sleepMillis);
	
	/**
	 * 默认尝试1次
	 * @param key
	 * @param expireTime
	 * @return
	 */
	public boolean lock(String key, Long expireTime);
	
	/**
	 * 释放锁
	 * @param key
	 * @return
	 */
	public boolean releaseLock(String key);
}
