package com.quantgroup.asset.distribution.service.httpclient;

import java.util.Map;


public interface IHttpService {

    /**
     * Http Get
     *
     * @param uri
     * @return
     */
    String get(String uri);
    String get(String uri, int timeOut);

    <T> T get(String uri, Class<T> classOfT);

    /**
     * Http Get
     *
     * @param uri
     * @param parameters
     * @return
     */
    String get(String uri, Map<String, String> parameters);

    /**
     * Http Get
     *
     * @param uri
     * @param headers
     * @param parameters
     * @return
     */
    String get(String uri, Map<String, String> headers, Map<String, String> parameters);

    /**
     * Http Post
     *
     * @param uri
     * @return
     */
    String post(String uri);

    /**
     * Http Post
     *
     * @param uri
     * @param parameters
     * @return
     */
    String post(String uri, Map<String, String> parameters);

    /**
     * Http Post
     *
     * @param uri
     * @param headers
     * @param parameters
     * @return
     */
    String post(String uri, Map<String, String> headers, Map<String, String> parameters);
    public String post(String uri, Map<String, String> headers,Map<String, String> parameters, boolean isLog);
    
    public String postJson(String uri, Map<String, String> headers, String jsonParams) ;
    
    public String postObj(String uri, Map<String, Object> parameters);
    public String postObj(String uri, Map<String, String> headers, Map<String, Object> parameters) ;
    /**
     * 不需要返回结果的请求
     * @param url
     * @param parameters
     * @return
     */
    public int postNoResponse(String url, Map<String, String> parameters);

    public Map<String,String> postHasResponse(String url, Map<String, String> parameters);

    public String post(String uri, Map<String, String> headers,Map<String, String> parameters,boolean isLog,int timeOut);
}
