package com.quantgroup.asset.distribution.service.newrule.specialrules;

import cn.quantgroup.motan.bean.UserAssociationBean;
import cn.quantgroup.motan.retbean.XContactInfo;
import com.alibaba.fastjson.JSON;
import com.quantgroup.asset.distribution.service.newrule.pojo.enums.SpecialRuleEnum;
import com.quantgroup.asset.distribution.service.newrule.pojo.funds.RuleParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author shihuajun
 * @date 2021/8/26 19:42
 * @ describing
 */
@Slf4j
@Component
public class ContactsTelSameVerifyImpl extends AbstractProductRuleVerifyImpl{
    @Override
    public boolean pass(RuleParam param) {
        if (param == null){
            throw new RuntimeException("联系人手机号校验入参param有问题");
        }
        UserAssociationBean userInfo = param.getUserInfo();
        if (userInfo == null){
            throw new RuntimeException("联系人手机号校验入参userInfo有问题");
        }
        List<XContactInfo> contractResults = userInfo.getContractResults();
        if (CollectionUtils.isEmpty(contractResults)){
            log.warn("联系人手机号校验发现联系人为空");
            return true;
        }
        for (XContactInfo info : contractResults) {
            if (StringUtils.isBlank(info.getPhoneNo())){
                log.warn("联系人手机号校验发现联系人手机号为空，联系人信息 {}", JSON.toJSONString(info));
                continue;
            }
            if (info.getPhoneNo().equals(param.getUserInfo().getPhoneNo())){
                log.warn("联系人手机号校验发现当前用户与联系人手机号相同，联系人信息 {}", JSON.toJSONString(info));
                return true;
            }
        }
        return false;
    }

    @Override
    public SpecialRuleEnum specialRuleName() {
        return SpecialRuleEnum.CONTACT_TEL_SAME_VERIFY;
    }
}
