package com.quantgroup.asset.distribution.model.form;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.quantgroup.asset.distribution.service.jpa.entity.Asset;

import lombok.Data;

@Data
public class AssetForm implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String code;
	
	private String msg;
	
	private String uuid;
	
	private String bizChannel;
	
	private String bizNo;
	
	private String bizType;
	
	private String auditResult;
	
	private String amount;
	
	private String term;
	
	private String deadLine;
	
	private String exData;
	
	private String otherInformation;
	
	private String financeProducts;
	
	private String assetNo;
	
	private String callbackUrl;
	
	private int repeatCount = 0;
	
	private String refuseReason;
	
	public Asset transToAsset() {
		Asset asset = new Asset();
		asset.setAssetNo(this.assetNo);
		asset.setBizNo(this.bizNo);
		asset.setUuid(this.uuid);
		asset.setBizChannel(this.bizChannel);
		asset.setFinanceProductType("0".equals(this.bizType) ? 0 : 1);
		asset.setAuditResult(Boolean.valueOf(this.auditResult.trim()));
		asset.setEnable(true);
		return asset;
	}
	
	/**
	 * 获取通知资金系统FormMap
	 * @return
	 */
	public Map<String, String> transToNotifyMap(Map<String, Object> data) {
		Map<String, String> notifyMap = new HashMap<>();
		notifyMap.put("code", this.code);
		notifyMap.put("msg", this.msg);
		notifyMap.put("uuid", this.uuid);
		notifyMap.put("bizChannel", this.bizChannel);
		notifyMap.put("bizNo", this.bizNo);
		notifyMap.put("bizType", this.bizType);
		notifyMap.put("auditResult", this.auditResult);
		notifyMap.put("amount", this.amount);
		notifyMap.put("deadLine", this.deadLine);
		notifyMap.put("exData", this.exData);
		notifyMap.put("otherInformation", this.otherInformation);
		notifyMap.put("financeProducts", this.financeProducts);
		
		Map<String, Object> dataMap = new HashMap<>();
		// 目前通知资金方可能有3个模型分
		if (data.get("model_exec_data_source#fst_v6_xy_br_dhb_raw_bucket") != null) {
			dataMap.put("model_exec_data_source#fst_v6_xy_br_dhb_raw_bucket", data.get("model_exec_data_source#fst_v6_xy_br_dhb_raw_bucket"));
		}
		if (data.get("td_rules#2022870_result") != null) {
			dataMap.put("td_rules#2022870_result", data.get("td_rules#2022870_result"));
		}
		if (data.get("lxf_score_scale_v2") != null) {
			dataMap.put("lxf_score_scale_v2", data.get("lxf_score_scale_v2"));
		}
		dataMap.put("user_loan_type", data.get("user_loan_type"));
		notifyMap.put("dataMap", JSON.toJSONString(dataMap));
		
		return notifyMap;
	}
	
}
