package com.quantgroup.asset.distribution.controller.route.routerecord;

import com.quantgroup.asset.distribution.model.entity.route.routerecord.RouteRecordQueryVo;
import com.quantgroup.asset.distribution.model.entity.route.whitelist.WhiteListQueryVo;
import com.quantgroup.asset.distribution.model.response.GlobalResponse;
import com.quantgroup.asset.distribution.service.route.IRouteRecordService;
import com.quantgroup.asset.distribution.util.AllRecords;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * 路由记录查询页面
 */
@Slf4j
@RestController
@RequestMapping("/routerecord")
public class RouteRecordController {

    @Autowired
    private IRouteRecordService routeRecordService;

    /**
     * 分页查询
     * @param routeRecordQueryVo
     * @return
     */
    @RequestMapping(value = "/queryPage",method = RequestMethod.POST)
    public GlobalResponse queryPage(@RequestBody RouteRecordQueryVo routeRecordQueryVo){
        AllRecords allRecords = routeRecordService.queryPage(routeRecordQueryVo);
        return GlobalResponse.success(allRecords);
    }
}
