package com.quantgroup.asset.distribution.service.newrule;

import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @author shihuajun
 * @date 2021/8/27 10:58
 * @ describing
 */
@Slf4j
@Component
public class RuleHandleFactory {
    @Resource
    private Map<String, IRuleVerifyService> ruleVerifyServiceMap;

    public final static List<IRuleVerifyService> COMMON_VERIFY = Lists.newArrayList();

    public IRuleVerifyService getRuleVerifyServiceMap(String className) {
        if (StringUtils.isBlank(className)){
            throw new RuntimeException("获取IRuleVerifyService入参有问题");
        }
        if (ruleVerifyServiceMap.containsKey(className)){
            return ruleVerifyServiceMap.get(className);
        }else {
            throw new RuntimeException("获取IRuleVerifyService入参有问题，没有对应的实现类");
        }
    }

    @PostConstruct
    public void init(){
        for (IRuleVerifyService ruleVerifyService : ruleVerifyServiceMap.values()) {
            if (ruleVerifyService.getClass().getName().contains("common")){

                COMMON_VERIFY.add(ruleVerifyService);
            }
        }
    }
}
