package com.quantgroup.asset.distribution.service.asset;

import java.util.List;
import java.util.Map;

import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.jpa.entity.Asset;
import com.quantgroup.asset.distribution.service.jpa.entity.AssetAttributeExtendConfig;

/**
 * 资产属性Service
 * @author liwenbin
 *
 */
public interface IAssetAttributeService {
	
	/**
	 * 获取所有资产属性值
	 * @param assetAttributeExtendConfigList
	 * @return
	 */
	public Map<String, Object> getAllAssetAttributeValue(List<AssetAttributeExtendConfig> assetAttributeExtendConfigList, AssetForm assetForm);
	
	
	/**
	 * 资产入库
	 * @param asset
	 * @param assetAttributeExtendConfigList
	 * @param data
	 */
	public void saveAssetAttrubite(Asset asset, List<AssetAttributeExtendConfig> assetAttributeExtendConfigList, Map<String, Object> data);
}
