package com.quantgroup.asset.distribution.service.jpa.entity;

import lombok.Data;

import javax.persistence.*;
import java.sql.Timestamp;

/**
 * @author : Hyuk
 * @description : AidLoanFundUserTag
 * @date : 2020/4/28 10:38 上午
 */
@Entity
@Table(name="aid_loan_fund_user_tag")
@Data
public class AidLoanFundUserTag {

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "asset_no")
    private String assetNo;

    @Column(name = "uuid")
    private String uuid;

    @Column(name = "biz_no")
    private String bizNo;

    @Column(name = "fund_id")
    private String fundId;

    @Column(name = "tag_text")
    private String tagText;

    @Column(name = "enable")
    private Boolean enable;

    @Column(name = "created_at")
    private Timestamp createdAt;

    @Column(name = "updated_at")
    private Timestamp updatedAt;

    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
