package com.quantgroup.asset.distribution.enums.response;

import lombok.Getter;

/**
 * 资产系统返回值
 * @author liwenbin
 *
 */
public enum AssetResponse implements GlobalResponseEnum{
	
	SUCCESS(0, "success"),
	ASSET_FORM_IS_ERROR(1001, "资产入库参数错误!"),
	AUDIT_RESULT_OR_DEAD_LINE_IS_EMPTY(1002, "auditResult或deadLine为空"),
	AMOUNT_OR_FINANCE_PRODUCTS_IS_EMPTY(1003, "auditResult为true时, 金融产品集或amount为空"),
	FINANCE_PRODUCTS_IS_ERROR1(1004, "金融产品集不符合(0 <= max - min <= 1)规则"),
	FINANCE_PRODUCTS_IS_ERROR2(1005, "金融产品及不符合(amount >= floor)规则");
	
	@Getter
	private int code;
	@Getter
	private String businessCode;
	@Getter
	private String msg;
	@Getter
	private Object body;
	
	AssetResponse(int code, String msg) {
		this.code = code;
		this.businessCode = null;
		this.msg = msg;
		this.body = null;
	}
	
	AssetResponse(int code, String businessCode, String msg) {
		this.code = code;
		this.businessCode = businessCode;
		this.msg = msg;
	}
}
