package com.quantgroup.asset.distribution.service.authority;

import com.quantgroup.asset.distribution.service.jpa.entity.AuthorityConfig;

/**
 * 权限认证Service
 * @author liwenbin
 *
 */
public interface IAuthorityService {
	
	/**
	 * 根据auth_key和auth_pass查找权限
	 * @param auth_key
	 * @param auth_pass
	 * @return
	 */
	public AuthorityConfig findByAuthKeyAndAuthPass(String authKey, String authPass);
	
	/**
	 * 根据authKey和authPass清楚缓存
	 * @param authKey
	 * @param authPass
	 */
	public void clearCacheByAuthKeyAndAuthPass(String authKey, String authPass);
}
