package com.quantgroup.asset.distribution.controller;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.quantgroup.asset.distribution.model.response.GlobalResponse;

import lombok.extern.slf4j.Slf4j;

@RestController
@RequestMapping("/")
@Slf4j
public class CheckController {
	
	private static Map<String,String> map = new ConcurrentHashMap<>();

    @RequestMapping(value="check")
	public ResponseEntity<String> check() {
		if(map!=null && map.size()>0){
			return ResponseEntity.status(HttpStatus.NOT_FOUND).build();
		}else{
			return ResponseEntity.status(HttpStatus.OK).build();
		}
	}
	@RequestMapping(value="online")
	public GlobalResponse online() {
		log.info("应用上线，流量开始切入....");
		map.clear();
		return GlobalResponse.success();
	}
	@RequestMapping(value="offline")
	public GlobalResponse offline() {
		log.info("应用下线，流量不再切入....");
		map.put("status", "offline");
		return GlobalResponse.success();
	}
	
	@RequestMapping(value="check_test")
	public GlobalResponse test() {
        return GlobalResponse.success(map);
	}
}
