package com.quantgroup.asset.distribution.model.response;

import com.quantgroup.asset.distribution.enums.response.MiddleOfficeCommonResponseEnum;
import lombok.Data;

/**
 * @author : Hyuk
 * @description : MiddleOfficeResponse
 * @date : 2020/6/4 6:28 下午
 */
@Data
public class MiddleOfficeResponse {

    private String code;

    private String msg;

    private Object data;

    public MiddleOfficeResponse() {}

    public MiddleOfficeResponse(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public MiddleOfficeResponse(String code, String msg, Object data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static MiddleOfficeResponse created(MiddleOfficeCommonResponseEnum middleOfficeCommonResponseEnum) {
        return new MiddleOfficeResponse(middleOfficeCommonResponseEnum.getCode(), middleOfficeCommonResponseEnum.getMsg());
    }

    public static MiddleOfficeResponse created(MiddleOfficeCommonResponseEnum middleOfficeCommonResponseEnum, Object data) {
        return new MiddleOfficeResponse(middleOfficeCommonResponseEnum.getCode(), middleOfficeCommonResponseEnum.getMsg(), data);
    }
}
