package com.quantgroup.asset.distribution.service.funding.impl;

import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.model.response.GlobalResponse;
import com.quantgroup.asset.distribution.service.funding.IAidFundRouteService;
import com.quantgroup.asset.distribution.service.funding.IAidLoanFundConfigService;
import com.quantgroup.asset.distribution.service.jpa.entity.AidLoanFundConfig;
import com.quantgroup.asset.distribution.service.redis.IRedisService;
import com.quantgroup.asset.distribution.util.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import static com.quantgroup.asset.distribution.constant.RedisKeyConstants.AID_LOAN_ALL_AMOUNT_LIMIT_KEY;
import static com.quantgroup.asset.distribution.constant.RedisKeyConstants.AID_LOAN_COUNT_LIMIT_KEY;

/**
 * Created by renfeng on 2019/7/19.
 */
@Service
@Slf4j
public class AidFundRouteServiceImpl implements IAidFundRouteService {


    @Autowired
    private IAidLoanFundConfigService iAidLoanFundConfigService;

    @Autowired
    private IRedisService<String> redisService;

    /**
     * 助贷资金路由
     *
     * @param assetForm
     * @return
     */
    @Override
    public GlobalResponse aidFundRoute(AssetForm assetForm) {

        //第一步 查询所有助贷资金
        List<AidLoanFundConfig> aidLoanFundConfigList = iAidLoanFundConfigService.findAll();

        //第二步 开关筛选
        if(CollectionUtils.isNotEmpty(aidLoanFundConfigList))
            aidLoanFundConfigList = aidLoanFundConfigList.parallelStream().filter(aidLoanFundConfig->aidLoanFundConfig.getFundSwitchState()==1).collect(Collectors.toList());
        //第三步 限制次数筛选
        if(CollectionUtils.isNotEmpty(aidLoanFundConfigList)){
            // AID_LOAN_COUNT_LIMIT_KEY + DateUtil.getDay() //TODO 放redis
            aidLoanFundConfigList = aidLoanFundConfigList.parallelStream()
                    .filter(aidLoanFundConfig->aidLoanFundConfig.getFundCountLimit() >=redisService.setIncr(AID_LOAN_COUNT_LIMIT_KEY + DateUtil.getDay(), 0, 3, TimeUnit.DAYS))
                    .collect(Collectors.toList());
        }
        //第四步 限制总额度筛选
        if(CollectionUtils.isNotEmpty(aidLoanFundConfigList)){
            // 获取已放款总金额  AID_LOAN_ALL_AMOUNT_LIMIT_KEY + DateUtil.getDay() //TODO 放redis
            String allAmount = redisService.getString(AID_LOAN_ALL_AMOUNT_LIMIT_KEY + DateUtil.getDay());
            aidLoanFundConfigList = aidLoanFundConfigList.parallelStream()
                    .filter(aidLoanFundConfig->new BigDecimal(aidLoanFundConfig.getFundAllAmountLimit()).compareTo(new BigDecimal(StringUtils.isEmpty(allAmount)?"0":allAmount))>0)
                    .collect(Collectors.toList());
        }
        //第五步 开始路由
        if(CollectionUtils.isNotEmpty(aidLoanFundConfigList)){
            //TODO 未接到助贷资金  暂时不能进行开发
        }
        return GlobalResponse.error("未匹配到助贷资金");
    }
}
