package com.quantgroup.asset.distribution.service.funding.impl;

import com.quantgroup.asset.distribution.enums.funding.FundingResult;
import com.quantgroup.asset.distribution.service.funding.IAidFundRouteRecordService;
import com.quantgroup.asset.distribution.service.jpa.entity.AidLoanFundRouteRecord;
import com.quantgroup.asset.distribution.service.jpa.repository.IAidLoanFundRouteRecordRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by renfeng on 2019/7/19.
 */
@Service
@Slf4j
public class AidFundRouteRecordServiceImpl implements IAidFundRouteRecordService {




    @Autowired
    private IAidLoanFundRouteRecordRepository iAidLoanFundRouteRecordRepository;


    /**
     * 资金分配结果通知
     *
     * @param bizNo
     * @param fundingResult
     */
    @Override
    public void fundingResultNotity(String bizNo, FundingResult fundingResult) {

        //查询未完成的助贷资金路由 且唯一
        AidLoanFundRouteRecord aidLoanFundRouteRecord = iAidLoanFundRouteRecordRepository.findByBizNoAndAidFundRouteStatus(bizNo, 1);
        //更新助贷资金路由状态 2-成功 3-失败 1-未完成
        if(aidLoanFundRouteRecord!=null){
            aidLoanFundRouteRecord.setAidFundRouteStatus(fundingResult==FundingResult.FUAD_ASSIGN_SUCC?2:3);
            iAidLoanFundRouteRecordRepository.save(aidLoanFundRouteRecord);
        }
        log.info("更新助贷资金路由状态结束，bizNo : {} , fundingResult : {} ,是否命中 : {} ",bizNo,fundingResult,aidLoanFundRouteRecord!=null);
    }
}
