package com.quantgroup.asset.distribution.service.jpa.repository;

import com.quantgroup.asset.distribution.service.jpa.entity.FundProductEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;

import java.util.List;


public interface IFundProductRepository extends JpaRepository<FundProductEntity, Long>, QueryDslPredicateExecutor<FundProductEntity> {
    FundProductEntity getByIdEquals(Long id);

    List<FundProductEntity> getAllByEnableEquals(Byte enable);

    List<FundProductEntity> getAllByFundIdEqualsAndEnableEquals(Long fundId,Byte enable);

    FundProductEntity getByFundIdEqualsAndFundProIdEqualsAndEnableEquals(Long fundId,Long fundProId,Byte enable);

    FundProductEntity getByFundIdEqualsAndFundProIdEquals(Long fundId,Long fundProId);

}
