package com.quantgroup.asset.distribution.service.rule.vo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

import java.util.Map;
import java.util.Set;

/**
 * @author : Hyuk
 * @description : IRuleVO
 * @date : 2020/3/5 4:50 下午
 */
//支持fastjson
@JSONType(seeAlso = {BaseRuleVO.class, UnionRuleVO.class})
//支持jackson
@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.PROPERTY,
        property = "@type")
@JsonSubTypes({
        @JsonSubTypes.Type(value = BaseRuleVO.class, name = "base"),
        @JsonSubTypes.Type(value = UnionRuleVO.class, name = "union")})
public interface IRuleVO {

    boolean valid(Map<String, Object> data);

    /**
     * 记录拒绝规则 二次校验
     *
     * @param data
     * @return
     */
    Map<String, Boolean> valid2(Map<String, Object> data);

    String getId();

    void checkParams();

    Set<String> getParamNames();

    String format();

    default String toJSONString() {
        return JSON.toJSONString(this, SerializerFeature.WriteClassName, SerializerFeature.WriteEnumUsingName);
    }
}
