package com.quantgroup.asset.distribution.service.route.impl;

import com.quantgroup.asset.distribution.model.entity.route.whitelist.WhiteListQueryVo;
import com.quantgroup.asset.distribution.model.entity.route.whitelist.WhiteListResultVo;
import com.quantgroup.asset.distribution.model.entity.route.whitelist.WhiteListSaveVo;
import com.quantgroup.asset.distribution.model.response.GlobalResponse;
import com.quantgroup.asset.distribution.service.jpa.entity.FundProductEntity;
import com.quantgroup.asset.distribution.service.jpa.entity.QWhiteListEntity;
import com.quantgroup.asset.distribution.service.jpa.entity.WhiteListEntity;
import com.quantgroup.asset.distribution.service.jpa.repository.IFundProductRepository;
import com.quantgroup.asset.distribution.service.jpa.repository.IWhiteListRepository;
import com.quantgroup.asset.distribution.service.route.IWhiteListService;
import com.quantgroup.asset.distribution.util.AllRecords;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Service
public class WhiteListServiceImpl implements IWhiteListService {

    @Autowired
    private IWhiteListRepository whiteListRepository;

    @Autowired
    IFundProductRepository fundProductRepository;

    @Override
    public AllRecords queryPage(WhiteListQueryVo whiteListQueryVo) {
        //索引 和 每页大小   排序   条件
        BooleanExpression booleanExpression = Expressions.asBoolean(true).isTrue();

        if (!StringUtils.isEmpty(whiteListQueryVo.getPhone())){
            booleanExpression =  booleanExpression.and(QWhiteListEntity.whiteListEntity.phone.eq(String.valueOf(whiteListQueryVo.getPhone())));
        }
        if (!StringUtils.isEmpty(whiteListQueryVo.getFundName())){
            booleanExpression =  booleanExpression.and(QWhiteListEntity.whiteListEntity.fundName.like(String.valueOf(whiteListQueryVo.getFundName())));
        }

        //1.查询条件，2.索引和每页的大小，3.排序根据某个字段进行排序
        //查询总条数
        long count = whiteListRepository.count(booleanExpression);
        //查询数据
        Page<WhiteListEntity> plantPage = whiteListRepository.findAll(booleanExpression, new PageRequest(whiteListQueryVo.getOffset(), whiteListQueryVo.getPageSize(), new Sort(Sort.Direction.DESC, "createdAt")));
        List<WhiteListEntity> whiteListEntityList = new ArrayList<>();
        whiteListEntityList = plantPage.getContent();
        List<WhiteListResultVo> whiteListResultVoArrayList = new ArrayList<>();
        whiteListEntityList.stream().forEach(whiteListEntity -> {
            WhiteListResultVo whiteListResultVo = new WhiteListResultVo();
            BeanUtils.copyProperties(whiteListEntity, whiteListResultVo);
            whiteListResultVoArrayList.add(whiteListResultVo);
        });

        AllRecords allRecords = new AllRecords();
        allRecords.setPageIndex(whiteListQueryVo.getPageIndex());
        allRecords.setPageSize(whiteListQueryVo.getPageSize());
        allRecords.setDataList(whiteListResultVoArrayList);
        allRecords.setTotalNumber(count);
        allRecords.resetTotalNumber(count);
        return allRecords;
    }

    @Override
    public GlobalResponse updateStatus(Long id, Byte status) {
        WhiteListEntity one = whiteListRepository.findOne(id);
        if (Objects.nonNull(one)){
            one.setStatus(status);
            whiteListRepository.save(one);
            return GlobalResponse.success();
        }else {
            return GlobalResponse.error("该条记录不存在");
        }
    }

    @Override
    public GlobalResponse save(WhiteListSaveVo whiteListSaveVo) {
        WhiteListEntity whiteListEntity = new WhiteListEntity();
        BeanUtils.copyProperties(whiteListSaveVo,whiteListEntity);
        FundProductEntity fundProductEntity = fundProductRepository.getByFundIdEqualsAndFundProIdEqualsAndEnableEquals(whiteListSaveVo.getFundId(), whiteListSaveVo.getFundProId(), Byte.valueOf("1"));
        if (Objects.nonNull(fundProductEntity)){
            whiteListEntity.setFundProductId(fundProductEntity.getId());
            whiteListEntity.setFundName(fundProductEntity.getFundName());
            whiteListEntity.setStatus(Byte.valueOf("0"));
            whiteListRepository.save(whiteListEntity);
            return GlobalResponse.success();
        }else {
            return GlobalResponse.error("要保存的白名单对应的资金产品不存在");
        }
    }
}
