package com.quantgroup.asset.distribution.enums.funding;

import com.quantgroup.asset.distribution.enums.response.GlobalResponseEnum;
import com.quantgroup.asset.distribution.exception.QGException;
import com.quantgroup.asset.distribution.exception.QGExceptionType;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

/**
 * 资金分配结果
 * Created by renfeng on 2019/7/19.
 */
@Slf4j
public enum FundingResult{

    FUAD_ASSIGN_SUCC("FUAD_ASSIFN_SUCC", "分配资金方成功"),

    FUAD_ASSIGN_FAIL("FUAD_ASSIFN_FAIL", "分配资金方失败"),

    CANCEL_LOAN("CANCEL_LOAN","关单"),//属于资方分配失败

    REJECT("REJECT","分配资方失败"),

    HANG_UP("HANG_UP","资方审核拒绝后挂起"),

    FUND_FAIL("FUND_FAIL", "放款失败"),

    REPAYMENT("REPAYMENT", "还款成功");


	@Getter
	private String code;
	@Getter
	private String text;


	FundingResult(String code, String text) {
		this.code = code;
		this.text = text;
	}

    private static final Map<String, FundingResult> textMap = new HashMap<>();

    private static final Map<String, FundingResult> codeMap = new HashMap<>();

    static {
        for (FundingResult fundingResult : FundingResult.values()) {
            textMap.put(fundingResult.getText(), fundingResult);
            codeMap.put(fundingResult.getCode(), fundingResult);
        }
    }


    public static FundingResult getAuditResultByDesc(String text) {
        return textMap.get(text);
    }

    public static FundingResult fromCode(String code) {
        for (FundingResult unionType : FundingResult.values()) {
            if (code == unionType.code) {
                return unionType;
            }
        }
        log.error("枚举不存在,code={}", code);
        throw new QGException(QGExceptionType.COMMON_ENUM_NOT_EXIST);
    }
}
