package com.quantgroup.asset.distribution.service.distribute.impl;

import com.quantgroup.asset.distribution.service.newrule.third.AuditResponce;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.quantgroup.asset.distribution.model.form.AssetForm;
import com.quantgroup.asset.distribution.service.distribute.IDistributeFailLogService;
import com.quantgroup.asset.distribution.service.jpa.entity.Asset;
import com.quantgroup.asset.distribution.service.jpa.entity.DistributeFailLog;
import com.quantgroup.asset.distribution.service.jpa.repository.IDistributeFailLogRepository;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class DistributeFailLogServiceImpl implements IDistributeFailLogService{
	
	@Autowired
	private IDistributeFailLogRepository distributeFailLogRepository;
	
	@Async
	@Override
	public void saveDistributeFailLog(AssetForm assetForm, String failReason) {
		try {
			DistributeFailLog distributeFailLog = new DistributeFailLog();
			distributeFailLog.setBizChannel(assetForm.getBizChannel());
			distributeFailLog.setAssetNo(assetForm.getAssetNo());
			distributeFailLog.setBizNo(assetForm.getBizNo());
			distributeFailLog.setBizType(Integer.parseInt(assetForm.getBizType()));
			distributeFailLog.setUuid(assetForm.getUuid());
			distributeFailLog.setContext(JSON.toJSONString(assetForm));
			distributeFailLog.setFailReason(failReason);
			distributeFailLog.setEnable(true);
			distributeFailLog.setCallType(0);
			distributeFailLogRepository.save(distributeFailLog);
		} catch (Exception e) {
			log.error("资产分发失败订单保存异常, asset : {}", JSON.toJSONString(assetForm), e);
		}
	}
    @Async
    @Override
    public void saveDistributeFailLogNew(AuditResponce assetForm, String failReason) {
        try {
            DistributeFailLog distributeFailLog = new DistributeFailLog();
            distributeFailLog.setBizChannel(assetForm.getBizChannel());
            distributeFailLog.setAssetNo(assetForm.getAssetNo());
            distributeFailLog.setBizNo(assetForm.getBizNo());
            distributeFailLog.setBizType(Integer.parseInt(assetForm.getBizType()));
            distributeFailLog.setUuid(assetForm.getUuid());
            distributeFailLog.setContext(JSON.toJSONString(assetForm));
            distributeFailLog.setFailReason(failReason);
            distributeFailLog.setEnable(true);
            distributeFailLog.setCallType(1);
            distributeFailLogRepository.save(distributeFailLog);
        } catch (Exception e) {
            log.error("资产分发失败订单保存异常, asset : {}", JSON.toJSONString(assetForm), e);
        }
    }
}
