package com.quantgroup.asset.distribution.service.newrule.common;

import cn.quantgroup.motan.bean.UserAssociationBean;
import com.quantgroup.asset.distribution.model.entity.user.SDKUserInfo;
import com.quantgroup.asset.distribution.model.entity.user.UserAddressInfo;
import com.quantgroup.asset.distribution.service.alarm.IAlarmService;
import com.quantgroup.asset.distribution.service.alarm.impl.MarkdownMessage;
import com.quantgroup.asset.distribution.service.newrule.pojo.enums.AreaEnum;
import com.quantgroup.asset.distribution.service.newrule.pojo.enums.SpecialRuleEnum;
import com.quantgroup.asset.distribution.service.newrule.pojo.funds.RuleParam;
import com.quantgroup.asset.distribution.service.user.IUserCenterService;
import com.quantgroup.asset.distribution.util.IdCardUtil;
import com.quantgroup.asset.distribution.util.JacksonUtil;
import com.quantgroup.asset.distribution.util.PhoneNumberGeo;
import com.quantgroup.asset.distribution.util.PhoneNumberInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author shihuajun
 * @date 2021/9/2 16:28
 * @ describing
 */
@Slf4j
@Component("commonAreaVerifyImpl")
public class AreaVerifyImpl extends AbstractProductRuleVerifyImpl {
    private static final String PROVINCE = "省";
    private static final String SHI = "市";

    private static final String TEL_ALERM_TEXT = "用户的手机号是 %s";

    @Resource
    private IAlarmService alarmService;

    @Resource
    private IUserCenterService userCenterService;

    @Override
    public boolean pass(RuleParam param) {
        if (StringUtils.isBlank(param.getArea()) && !AreaEnum.NO_DEMAND.equals(param.getAreaNum())){
            throw new RuntimeException("区域配置有问题");
        }else if (AreaEnum.NO_DEMAND.equals(param.getAreaNum())){
            return Boolean.TRUE;
        }
        RuleParam.AreaRuleConcrete ruleConcrete = JacksonUtil.deserialize(param.getArea(), RuleParam.AreaRuleConcrete.class);
        if (ruleConcrete == null){
            throw new RuntimeException("反序列化对象AreaRuleConcrete出问题了");
        }
        UserAssociationBean userInfo = param.getUserInfo();
        AtomicInteger hit = new AtomicInteger(0);
        if (StringUtils.isNotBlank(ruleConcrete.getNativeList())){
            List<Integer> nativeList = JacksonUtil.deserializeList(ruleConcrete.getNativeList(), Integer.class);
            String nativeCode = IdCardUtil.getCityCodeByIdCard(userInfo.getIdNo());
            if (StringUtils.isNotBlank(nativeCode) && nativeList.contains(Integer.parseInt(nativeCode))){
                hit.incrementAndGet();
            }
            if (AreaEnum.CHOOSE_ONE_MORE.equals(param.getAreaNum())){
                return true;
            }
        }
        if (StringUtils.isNotBlank(ruleConcrete.getResidenceList())){
            List<Integer> residenceList = JacksonUtil.deserializeList(ruleConcrete.getResidenceList(), Integer.class);
            SDKUserInfo userExtInfo = userCenterService.getSDKUserExtInfo(userInfo.getPhoneNo(), null);
            List<UserAddressInfo> addressList = userExtInfo.getAddressList();
            if (!CollectionUtils.isEmpty(addressList)){
                UserAddressInfo userAddressInfo = addressList.get(0);
                boolean residenceResult = (userAddressInfo.getDistrictCode() != null && residenceList.contains(userAddressInfo.getDistrictCode()))
                        || (userAddressInfo.getCityCode() != null && residenceList.contains(userAddressInfo.getCityCode()))
                        || (userAddressInfo.getProvinceCode() != null && residenceList.contains(userAddressInfo.getProvinceCode()));
                if (residenceResult){
                    hit.incrementAndGet();
                }
            }
            if (AreaEnum.TWO_OUT_OF_MANY.equals(param.getAreaNum())
                    || AreaEnum.CHOOSE_ONE_MORE.equals(param.getAreaNum())){
                return true;
            }
        }
        if (StringUtils.isNotBlank(ruleConcrete.getTelAreaNameList())){
            List<String> telAreaNameList = JacksonUtil.deserializeList(ruleConcrete.getTelAreaNameList(), String.class);
            PhoneNumberGeo phoneNumberGeo = new PhoneNumberGeo();
            PhoneNumberInfo numberInfo = phoneNumberGeo.lookup(userInfo.getPhoneNo());
            if (numberInfo == null){
                log.error("解析手机号出现问题,用户的手机号是 {}",userInfo.getPhoneNo());
                MarkdownMessage markdownMessage = new MarkdownMessage();
                markdownMessage.setTitle("解析手机号出现问题");
                markdownMessage.add(String.format(TEL_ALERM_TEXT,userInfo.getPhoneNo()));
                alarmService.sendMsgWithAlert(markdownMessage);
                return Boolean.TRUE;
            }
            String province = numberInfo.getProvince() + PROVINCE;
            String shi = numberInfo.getProvince() + SHI;
            if (telAreaNameList.contains(province) || telAreaNameList.contains(shi) || telAreaNameList.contains(numberInfo.getProvince()) ){
                hit.incrementAndGet();
            }
            if (AreaEnum.ALL_DEMAND.equals(param.getAreaNum())
                    || AreaEnum.TWO_OUT_OF_MANY.equals(param.getAreaNum())
                    || AreaEnum.CHOOSE_ONE_MORE.equals(param.getAreaNum())){
                return true;
            }
        }
        return Boolean.FALSE;
    }


    @Override
    public SpecialRuleEnum specialRuleName() {
        return SpecialRuleEnum.AREA_VERIFY;
    }
}
