package com.quantgroup.asset.distribution.model.entity.aid;

import com.quantgroup.asset.distribution.constant.aid.AidAuditResultConstants;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author : Hyuk
 * @description : AidAuditResultEntity
 * @date : 2020/7/6 12:47 上午
 */
@Data
public class AidAuditResultEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private String orderNo;

    /**
     * 1-通过，0-审核拒绝，2-审核中
     */
    private Integer auditResult;

    /**
     * 审批金额
     */
    private BigDecimal amount;

    /**
     * 审批期限
     */
    private Integer term;

    /**
     * 月利率
     */
    private String monthRate;

    /**
     * 日利率
     */
    private String dayRate;

    /**
     * 额度有效期截止时间
     */
    private Long deadLine;
}
