package com.quantgroup.asset.distribution.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * Created by renfeng on 2019/7/22.
 */
public class DateUtil {


    /**
     * 获取当前日期（天）
     * @return
     */
    public static String getDay(){
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(new Date());
    }
    
    /**
     * 获取当前时间 yyyy-MM-dd HH:mm:ss
     * @return
     */
    public static String getCurDateTime() {
    	return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now());
    }

    /**
     * 将时间类型字符串转换为Long类型
     * @param dateTime
     * @param pattern
     * @return
     */
    public static Long transStringToLong(String dateTime, String pattern) {
        return Timestamp.valueOf(LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern(pattern))).getTime();
    }
}
