package com.quantgroup.asset.distribution.service.jpa.entity;

import javax.persistence.*;
import java.sql.Timestamp;
import java.util.Objects;

/**
 * @author shihuajun
 * @date 2021/8/31 11:29
 * @ describing
 */
@Entity
@Table(name = "product_rule", schema = "asset-distribution")
public class ProductRuleEntity {
    private long id;
    private String ruleName;
    private String ruleVal;
    private String ruleChinese;
    private String textType;
    private String ruleType;
    private Byte enable;
    private Timestamp createdAt;
    private Timestamp updatedAt;

    @Id
    @Column(name = "id", nullable = false)
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Basic
    @Column(name = "rule_name", nullable = false, length = 50)
    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    @Basic
    @Column(name = "rule_val", nullable = false, length = 50)
    public String getRuleVal() {
        return ruleVal;
    }

    public void setRuleVal(String ruleVal) {
        this.ruleVal = ruleVal;
    }

    @Basic
    @Column(name = "rule_chinese", nullable = false, length = 50)
    public String getRuleChinese() {
        return ruleChinese;
    }

    public void setRuleChinese(String ruleChinese) {
        this.ruleChinese = ruleChinese;
    }

    @Basic
    @Column(name = "text_type", nullable = true, length = 50)
    public String getTextType() {
        return textType;
    }

    public void setTextType(String textType) {
        this.textType = textType;
    }

    @Basic
    @Column(name = "rule_type", nullable = true, length = 50)
    public String getRuleType() {
        return ruleType;
    }

    public void setRuleType(String ruleType) {
        this.ruleType = ruleType;
    }

    @Basic
    @Column(name = "enable", nullable = true)
    public Byte getEnable() {
        return enable;
    }

    public void setEnable(Byte enable) {
        this.enable = enable;
    }

    @Basic
    @Column(name = "created_at", nullable = false)
    public Timestamp getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    @Basic
    @Column(name = "updated_at", nullable = false)
    public Timestamp getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Timestamp updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProductRuleEntity that = (ProductRuleEntity) o;
        return id == that.id && Objects.equals(ruleName, that.ruleName) && Objects.equals(ruleVal, that.ruleVal) && Objects.equals(ruleChinese, that.ruleChinese) && Objects.equals(textType, that.textType) && Objects.equals(ruleType, that.ruleType) && Objects.equals(enable, that.enable) && Objects.equals(createdAt, that.createdAt) && Objects.equals(updatedAt, that.updatedAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, ruleName, ruleVal, ruleChinese, textType, ruleType, enable, createdAt, updatedAt);
    }
}
