package com.quantgroup.asset.distribution.config.code;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

// @Component
@Data
public  class InitAreaCode {

    private Logger logger= LoggerFactory.getLogger(this.getClass());

    public  ConcurrentHashMap<String,AreaCode> concurrentHashMap=new ConcurrentHashMap<String,AreaCode>();
    public  ConcurrentHashMap<String,AreaCode> concurrentNameHashMap=new ConcurrentHashMap<String,AreaCode>();
    // @PostConstruct
    public void init() throws Exception{
        logger.info("初始化区域码");
        InputStream in = this.getClass().getResourceAsStream("phone/gbt.txt");
        String var4 = getString(in);
        List<AreaCode> list = new ArrayList<AreaCode>();
        list = JSONObject.parseArray(var4, AreaCode.class);
        for(AreaCode code:list){
            concurrentHashMap.put(code.getAdcode(),code);
            concurrentNameHashMap.put(code.getName(),code);
        }
        logger.info("初始化区域码end:code{},name{}",concurrentHashMap.size(),concurrentNameHashMap.size());
    }

    public static String getString(InputStream in) throws IOException {
        Throwable var3 = null;
        String var4;
        try {
            var4 = IOUtils.toString(in, Charsets.toCharset(StandardCharsets.UTF_8));
        } catch (Throwable var13) {
            var3 = var13;
            throw var13;
        } finally {
            if (in != null) {
                if (var3 != null) {
                    try {
                        in.close();
                    } catch (Throwable var12) {
                        var3.addSuppressed(var12);
                    }
                } else {
                    in.close();
                }
            }
        }
        return var4;
    }

    public static void main(String[] args) throws  Exception {
//        URL url = InitAreaCode.class.getClassLoader().getResource("gbt.txt");
//        String content = FileUtils.readFileToString(new File(url.getPath()), StandardCharsets.UTF_8);
//        System.out.println(content);
        InputStream in = InitAreaCode.class.getClass().getResourceAsStream("/gbt.txt");
        String var4 = getString(in);
        System.out.println(var4);
        List<AreaCode> list = new ArrayList<AreaCode>();
        list = JSONObject.parseArray(var4, AreaCode.class);
    }
}
