package com.quantgroup.asset.distribution.model.response;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSON;
import com.quantgroup.asset.distribution.enums.response.GlobalResponseEnum;
import com.quantgroup.asset.distribution.exception.QGException;
import com.quantgroup.asset.distribution.exception.QGExceptionType;

import lombok.Data;

@Data
public class GlobalResponse {
	
	private static final String JSON_CONTENT_TYPE = "application/json;charset=UTF-8";
	
	private int code;
    private String businessCode;
    private String msg;
    private Object body;

    public GlobalResponse() {

    }

    private GlobalResponse(Object object) {
        body = object;
        code = 0;
        msg = "";
    }
    
    private GlobalResponse(int code, String msg, Object object) {
        this.body = object;
        this.code = code;
        this.msg = msg;
    }
    
    private GlobalResponse(int code, String businessCode, String msg, Object object) {
    	this.code = code;
    	this.businessCode = businessCode;
    	this.msg = msg;
    	this.body = object;
    }
    
    public static GlobalResponse success() {
        return new GlobalResponse(0, "success", null);
    }

    public static GlobalResponse success(Object data) {
        return new GlobalResponse(0, "success", data);
    }
    
    public static GlobalResponse create(String businessCode, String msg, Object object) {
    	return new GlobalResponse(0, businessCode, msg, object);
    }
    
    public static GlobalResponse create(GlobalResponseEnum responseEnum) {
    	return new GlobalResponse(responseEnum.getCode(), responseEnum.getBusinessCode(), responseEnum.getMsg(), responseEnum.getBody());
    }
    
    public static GlobalResponse create(GlobalResponseEnum responseEnum, Object object) {
    	return new GlobalResponse(responseEnum.getCode(), responseEnum.getBusinessCode(), responseEnum.getMsg(), object);
    }
    
    public static GlobalResponse create(QGException ex) {
    	return new GlobalResponse(ex.qgExceptionType.code, StringUtils.isNotBlank(ex.detail) ? ex.detail : ex.qgExceptionType.text, null);
    }
    
    public static GlobalResponse error(String msg) {
        return new GlobalResponse(1, msg, null);
    }

    public static GlobalResponse error(int code, Object data) {
        return new GlobalResponse(code, null, data);
    }
    
    public static GlobalResponse error(QGExceptionType qgExceptionType) {
        return new GlobalResponse(qgExceptionType.code, qgExceptionType.text, null);
    }
    
    public GlobalResponse(Object code, String msg) {
        if (code instanceof String && StringUtils.isNumeric(((String) code))) {
            this.code = Integer.parseInt(((String) code));
        } else {
            this.code = QGExceptionType.COMMON_SERVER_ERROR.code;
        }
        this.msg = msg;
    }

    public GlobalResponse(QGException ex) {
        code = ex.qgExceptionType.code;
        msg = StringUtils.isNotBlank(ex.detail) ? ex.detail : ex.qgExceptionType.text;

    }

    public static GlobalResponse generate(Object o) {
        return new GlobalResponse(o);
    }
    
    public void writeJson(HttpServletResponse response) throws Exception {
        response.setContentType(JSON_CONTENT_TYPE);
        response.setCharacterEncoding("UTF-8");
        PrintWriter out= response.getWriter();
        String responeJosn = JSON.toJSONString(this);
        out.print(responeJosn);
        out.flush();
        out.close();
    }
}
