package com.quantgroup.asset.distribution.niwodai;

import cn.quantgroup.user.IUserSdkService;
import cn.quantgroup.user.UserSdkServiceFactory;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import com.quantgroup.asset.distribution.AssetDistributionBootstrap;
import com.quantgroup.asset.distribution.service.funding.IAidFundRouteRecordService;
import com.quantgroup.asset.distribution.service.jpa.entity.AidLoanFundRouteRecord;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiAssetService;
import com.quantgroup.asset.distribution.service.niwodai.INiwodaiService;
import com.quantgroup.asset.distribution.service.niwodai.vo.*;
import com.quantgroup.asset.distribution.service.redis.IRedisService;
import com.quantgroup.asset.distribution.util.GZIPUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.PostConstruct;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = AssetDistributionBootstrap.class)
public class NiwodaiTest {
	
	@Autowired
	private INiwodaiService niwodaiService;
	@Autowired
	private INiwodaiAssetService niwodaiAssetService;
	@Autowired
	private IAidFundRouteRecordService aidFundRouteRecordService;
	@Autowired
	private IRedisService<AidLoanFundRouteRecord> redisService;
	@Autowired
	@Qualifier("httpClient")
	private CloseableHttpClient httpClient;
	@Value("${user.sdk.url}")
	private String userSysUrl;
	private IUserSdkService userSdkService;

	@PostConstruct
	public void init() {
		userSdkService = UserSdkServiceFactory.generateSDKService(userSysUrl, httpClient);
	}
	
	@Test
	public void testCheck() throws Exception {
		NiwodaiDataImportCheckRequestVO vo  = new NiwodaiDataImportCheckRequestVO();
		vo.setAmount(new BigDecimal(1000000));
		vo.setExternalUserId("aaaabbb");
		vo.setIdcardNumber("130723199304300031");
		vo.setRealName("郑健");
		vo.setPhone("18631397042");
		NiwodaiDataImportCheckResponseVO responseVO = niwodaiService.dataImportCheck(vo, "");
		//todo 传入错误身份证号返回400 确认是否正确
		System.out.println(JSON.toJSONString(responseVO));
	}

	@Test
	public void testUser(){
		niwodaiAssetService.queryUserBasic2Info("","18631397041",true);
	}

	@Test
	public void testIncoming() {
		NiwodaiIncomingRequestVO vo = new NiwodaiIncomingRequestVO();
		vo.setOrderId("123");
		NiwodaiCostant.UserInfo userInfo = new NiwodaiCostant.UserInfo();
		userInfo.setRealName("郑健");
		userInfo.setIdcardNumber("130723199304300030");
		userInfo.setPhone("18631397042");
		userInfo.setMaritalStatus(NiwodaiCostant.MaritalStatus.UNMARRIED.name());
		userInfo.setGender(NiwodaiCostant.Gender.MALE.name());
		userInfo.setEducation(NiwodaiCostant.EducationalBackground.JUNIOR_SCHOOL_AND_BELOW.name());
		userInfo.setOccupation(NiwodaiCostant.Occupation.WORKER.name());
		userInfo.setIdcardValidity("20100202-20300202");
		userInfo.setIdcardFront("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");
		userInfo.setIdcardBack("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");
		userInfo.setBioPhoto("/9j/4AAQSkZJRgABAQEASABIAAD/2wBDAA0JCgsKCA0LCgsODg0PEyAVExISEyccHhcgLikxMC4pLSwzOko+MzZGNywtQFdBRkxOUlNSMj5aYVpQYEpRUk//2wBDAQ4ODhMREyYVFSZPNS01T09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT0//wAARCAGEArIDASIAAhEBAxEB/8QAGwABAAIDAQEAAAAAAAAAAAAAAAEEAgMFBgf/xAA5EAACAgEDAgQEBQQBAwQDAAAAAQIRAwQhMUFRBRJhcYGRofAGE7HB0RQi4fEyI0JSFRYzciQ0Yv/EABgBAQEBAQEAAAAAAAAAAAAAAAABAgME/8QAHxEBAQEAAwEBAQEBAQAAAAAAAAERAiExQQMSE1Fh/9oADAMBAAIRAxEAPwDnsglkFrKQAEoAAAAAAACAAAAAAAAAAAAAAAAAAAAAE2KFCwIAAChYsUAIJIAAAAAAAAAcjghujG72+iVlGYNayRp1JX3IWfGmk5ptcq1ZMo2thGp6jDz+ZFLq26JWfC2kssXbp006+TLg2UKMXKPmaUk1XN/sZKnw7GAABgAACAAAAAAAACGiQUlQQSQFQADNAMAAAAIABQAAAAFAAAQBQIJABOxAAKBDJAEAAggAAWiSAAAAAAASACiAAQAABAAAAkAAAAAAAAAAABAAAmhYsUAIJIAAAAQAUAQ3SHmS5AkxtLl/dWasuoUappU+Gnv27fqcnxDxBu4Y5VT3aqvTf5FkHTy6zT4782VLty7KmbxbCptYZtpJdFTfdt8HCueWTuVurtval93/ALNmOH5k1BbRfzrlu/n9OwwdaHiObJJLCmo8Xzu3xv6P+epsnq5JLH57yXbTbpXvvW309ipHLHT4XSSk03Fc0uP9+6MMeRYcLzTdSbqF7031fd8vfv05GItxx5ciam/KluldutrbXTnhfQxySx40owTlJt7JX82ihPVNQcbtPd77v77/AGtS1E/+xtdXTpe9/wCQq3JTk7dp9k9q++3BmsTaXmkrfCSTrvvXeyrDLNKkk31tWr++5L1GPG3Tc5NU23S+QF3F+dFukoq6STr+PqXMeXJaVpLqk7v5W/1OTDVTm04q3eySSdP1LEHlk21BJvludv7+AxHa1GOSismkyeZKk4ySTbq20rul0/kr4NYpZHHOmqV9Nu3zKkVmTXnxtrsm3a/nYsLHinjSyQcMnKa3vjdtNvr1dc9xgvUmk1JNPhp2Dm5FqtF/1EvPjfLjsne6tOqa7/4q3ps8c+JThfZprdP2+vx72FbmgQiQgACAAABD4JAGL5BIGKgAARQsWKIBBJFFEgAgAACAAUAAAoAAAAAAAEAACAAQKAsAWQAEgAAqQAUAAAAAEAAgAAAAAAAAAAAAAAAAgEgAAAIAAAAgoMhhkNlBspazUeRKEXUm3v0S5t9eOnsYavxCOLzKMladJXdv4LqcLPqZ5cjlKTe7+vIwWdTqpW/73J1Sab56v4FCUnJO227TMXuRdAkbIuov33fp2/Q36Z+WLk9vO0k+q9CunsqN6paeDSpKW/vaoo2525OONczabrsnSXx5+Bj4jJKUYJUlHZLhX9oiSlHVY5bJ2qterMNenLUNttu0rftf7gaW6xptbt7LuZQdRae7bST7Pv8AKzCbtpLhJJffvRljg5RrZLq307e/wIDnJvyxTbfRG3Dp1KdNOTXKTpL3fQiCStRVt7X1d9/Tn9zfBtXig6VXJ81XL+C4+HqC9LUckMaUYxg0uaVRT7dW39syeoajbaSfDlsn7JfS2VJZI+VuqUEkl0S6/Fs0KalJyk93vdbL2+/T1RF/8zJJJrIo9d6Tr16/T4iM5xdvI2nxeyb6V8a3K+nXmkmoptNNJ8X3b/Re+xbg8Sbc0skm7bb46726X+ANsNbLHBuLc2+Yvj/Jsw5McpLLhaxypKUWm06d7rp778lWerwxdKEH3pWv0oxWowybbxuLbtSS/jr6gd2MrinSp9U7XzJTOTg1HlahCacbpJ7Lfs/f2OpCSkr2TTaaTuugsGYAIAAKJIJIIIABVGQSAIABkQKAAAAAAAAAAgAFAAAAAEoACCAAaUABBAAILQAKAAAAAAAAAAAgAEAAAAAAAAAAASQSQKAAAAAAAAIbDYaIaAMhksxeybKJbSTbZzPEvEY4IOEEnNrZ9vUx8V8Q/p2oRSeRq9+ifD/ejz+TJPJJynJyk+W3bLISJnKUm222/X79xyYp2ZAYN0RYe7CC6yjKmrVrhrui1BXgcbuKdp+/+iokbcWSk4t0nsExY/M8zxTb9G/VNfyY6qF5PMlu3bXd8fqYQleOcGt7tfDkzU1OKTdWrvqn1X7b+hRWUd0utb+iT/wbWm6TVRStpWxGCfmrbZL5v+DKSpNe9/Ctvr9EC0w8OXu0vRcfVhNxxSae7aT9eH+5CVQavok/3X0M5RvE1dUwmNKbaTe/f04/wTG2kltbtv76GLTSbaJg2m2tnTS+OxDFhZKSjjSVuk+r77962NefMqUMdqK393d3+hri6SREo077hSNNW3X7m5RlFNp2+3H+iu226TqjZjkoyVp79twmLeJPLHZpSStpt7+tdfgbcOuy4sittrim+lVXtVb/AOCtJyxzU4N900TlkpO2t3x/F/fowr0eDPDPhjkg9mrafKfVM2pnB8H1Dx6l4W9pq1zyvp3O8jNEgAoAAoAACAAAsxoyoxsAACAAAAAAAACAAUAAAAAAAMyiAGQyxUkEkCpAEAKtgAAAAAAAgkgkkAAFAAAEGEGAAAAAAAAAAAAAAAABBBJBAZDJZDAMpeJataTTOaScm6Sb5fevQtzkoxcm0klbb6I8r4lq3rNU5J/2R2h2rq/j/CKSKmXJLLklkm7lJtt9wlbMUzbCNp7J13LFtS1XT5Lb5mDd0bJulyt+i3f6GEVbSFRiouXBsUUuifoyxhxOqa5LEcC6k1ZHOcG+i+Cohxd7Lg6n9OpdLNsfD4tNqNvqTYZfjjxTTTaNyhfB2cXhcW7cU2uhaxeFpStRtPjbZi85FnG1wsOJttONWt/Wt/n6mctO7Te+zWy2+Py3+B6fD4XFq6e3RmnL4VKT8yi6Tumq6Mn+kX+a84sTSbS4/X7s2SwtSdKrVf7/AHO/HwqckmoWm6kl0fV+5Yx+CycU3Bprh+ovOQ/mvKvTV2ZrenudNUur/wAcnrJ+ETi0ljfKvqq+/wBTU/CpNpqDrlbU9+5P9IfzXnFpZJ7Kn7btenQielk001vTppXset03g2XK4qcFGPNcu/Tul/HO5YyeAxjjk/I0kmku69+B/pD+a+fTxyg2miItp0q37qz0Xifg0sX98MbSa47nCnhlFtJcHSWWazZZ6QlJtqS2fW9vmGnFqL63T6P7/kwjJxdO/kbW3kxtRjbW6a5Q1GehnWqwtpUpq+mzdbvtb+vuenTPJYF5snle3mVcfJ7/AHseo0mR5NPCb5aTtdU1z9SUbwQiSiQABAAAECgAIexIaJRiCQBABIAgkgAACgAGQQACgAAAAAgAAAABFAkAWQAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACCSCUQyGSyGUc3xzUfk6FwTqWV+VP0rf6bfE8wdf8RZFLNhxp3UW/a2v4OQTFjKEU27LKSaVUk+72f2rMMUVVvjl+pE2nb6vbZdDUZtRKnNpO/0+Hob8EE3vu0a8UE031LeFJJJLklajdBJJbbm6CVo1pGcHbT7Ga1ItYsbbpJW2dDBiW2xSwPe2dHTvZPuYtrUizjxK7ot4sStUka8StIswVNbGLa3I3wxpSW1+3BZhgi0/7bT5Rrwpt334LuLbbnr7ma0whp4Qj5VFVd/Fm2OKNcL5Gb3qjOMbSd/QmlaZYotVSMVp4S5jdd18f2LXkrhBJ9UCdsdPhjF0ktltt16GzLii4eVRVvkhKjPzN8llZscnW6DHlxuLgnvaTXv/ACeE/EPhctLmeSEXTb44rufUJxUotdeTjeLeHrVaeUGlvutrpmuPKypZLO3ymWNSg6aUl0vldX8zCMZQfmi27VWub9i/rdPLS6ucGmqbpPh90aIxt1VxdtHpl2a4WZcVcTePPFptNNcrd/e/zPS+HS82kjFO1BtJ+ibrf2r6HHlpl+U5KSdcb21/C67PobfCdS8WpeHI/wC2apdk969Oowd4kgkAAAAAAgAEEAkhlEAPkEAAACDIgogAGQABQAAEAAoAAAAGBADAAAAWQAQAAUAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAIJIJQZi3Sb7KzIiSTi73tVtyUeP8TyvLr8sn0l5Uu1bFaKbdJG3WJx1eZNU1N/qzXidNlgsJJQST3e/+CPKrprfn0Ii3tS3e19EZtJNRXz7sUbMSpe5ug6kjWtlXb7/ShGT8yp1vZm3Vi3s1wZQ5MYu6X1NqjVGa1FnB0OngaUUc7BFujoYYtJJGLcbjp4eFXPRFrGqe3CS2+n7FXAqSfYvYlsvmznXSLEE6SfTb/HzLWJUmvSv1/hlXFz8i1F7PsRW/EradluCu7fBXwqlfJZW3307/AH6FkZrJQTRhLG+EjZHf4GSSXLdjE1UknF00Y7lmcU2m97+hoaKsYrZP76GvKri00blFtmM4uid/B4H8W+HtZnqIxpPdpdDzmCSSScb8r4XNt77/ADaZ9D8d0/n00/MrVPf/AB/g+d58b02pW6cW6ae1rjf5nf8AO2zK485l1v1WB4sayQacZcNdfT9P5OdNXJShald1VO/RcfXp8upLI3h/KbuLScX2Xt3Xp36HJzKWOTttK6aW1nRh6XR5fz9NGd29033adFg5PgWXzYskFwmn33e37HVTFgkAAAABAAAEUSQAAAAAACCSCVIgABQAAAABAAKAAAAACAABNgUALAAIAAKJAAAAEEAkAQAAAAAAAAAAAAAAAAAAAAAAACGQZENAeP8AFU14lnT/APJv3veyrHlLudHx+Hl8RbS2lFO/Xj9jmplg3wdStbpcG2O9t7Xx+pXg9ruvfsb000kvv1FG1P8AsXqQtmL2SBnFi3heyLcI2ruilhfBfxLgzWotYFSSOjhh5ldXTr79SlghbVHX0mJW/tnO10kbcUW0lW7LsFSq3t2ZrWJ0k+KT4LUUkqavszFuuicT3ZZxSbdq1XdcmnFFN7lmGPypNEG7HLZLqb4yuk9mV4Otmlv8zfBp099u6LGa3xaT32a7J7mTdmNpoOW1V8SoS3VGtri+dzJshslGMVvuJUmkHsYOVNMS5BzfGYpaabWzppdvifM/Esbeok0mqe6dq16enHT26n0/xffSTXGx828T21Lfrw+i7V8a+LOv53GOfivhl5sXkbtrh9e6f0oqamKaakt1au+V0+/b0LjTjCXkXFbrlrpv8yrrW3OMn1W79Ts5N/4et5cqq04pP57fE7qOV4Fj8uHJKt3JJv0Su0/ijqoUZAIAAABAAAAAAAAIAAAPgB8AYsBggAAAAAAAAgAFAAAKAFAAKAFkAAAAAAAEAAgkAMogAAASCCAAAAAAAAAAAAAEkEkAAAAIJIJRw/xLj/sw5EuG4v47r9GcCj0/4hin4em+VJNfp+55dMqxsi6SNsXavqaV09jdDlXwW3oxui+LM0a0/kZJq1fBmCzgW9l/AnKqXBzsc0tlv3fYuafJKNepLNWV2tJFtJpHZ06SSaXKv0RxNDqIL+1um/0O1gyxapNU/X0OXKOssx0ccba3q+dr/k3PHHbb27ejNOlk5NNdCzktU0uq2MY3KmGOkm6Rvit1apPmyGk8afDXciMrap9N/cprKS8r7p8M3Ym6abv/AEVsrdpPo9jfidRV9VdhG5JtU2/gZJWYQkm6W7N6VbJppq0l0CMWjFrY20upjOq59ESwaWapK2bZJpWjB7ksHP8AFVKWmnTapXsfOPEVeaStJrq+u32/gfTc8VOMovhrc+b+L43i1c01TTTrv1/Szr+d7xjnOlOMoywNp1KqarhrZr5NFDV7+VcWki06hkbuk2tnxvtfx2K0IvLqYRb28yT9Ff39Tu5PQeH4VDRxcaV7tN0/8p+5voxglGKSVJJJfIzJ6CJIRJQAAAAACCSAAAAgAACDIglggAACKJAEAAAAAAAAgAFAAAAABYAAEgAAAAAAAAAAACAACgAAIAAAAEEgAAAAAAZQIJRAAMGjW5Hj0mWcXuotr0fR/v8AADneN6jDLRzxRmpStWluk778dGeaSplnLJuFXtaK4WVkt6NsNkaoco3JUhRmpEqVswSM4RTe43DG/Em2mi3FNJWa9NjUmldfA7Ok8PhnSU26frt8DNsiyWuYsriqb2N+n1+THJJSbS6NnZ/9uxyRbU9qu92U9T+Hs2JtwbaXuZ2Vcro6DxlxpySS6q+fqdzF4jDOopS/utOux4R4s+nm7i9u50dFr5Y2lLZ+/BiyXxuWydvcTzJadu6bpNeljBK6tnFWuWTSpNu21t3OpoGpQTr5nOzG5dmt2SVS4T9+xktUkubo1ar+1utjkanVrE2lbbdO9v03/wB+pVr0GPV41Um9nVvqr7G967DFNuTpcvotqPGPX5F/3JeiSr62a5aqeRNNt+tNv7+6LIza9hl8Ww+XacfmnuVM3ibiqSSfS9tu/wB+nVnk/P5ZeVTaXRLZr4HTxP8AMxqntSSfCX8clxNdjH4n5ciWRPyvlpNr59vf5F5ZYZYKWOSafNO2vc805ThkSdNXTd7V77fwWdNlyYszaTSW1JNpq75XT79pZFldpv8Atfq7Pn34px/l6+fRumvZo99CayQtJq+j5R4z8aYHGccq3uI4XKnPuPKTk3CN9Hf1/wBfIz0EfN4hFdnfw4/QrptxSb4kmvezoeFY5vM8z4qk9t6Vdz0uDsEkIkCQAAABAABUqAAFAAAAAEAACAAQAABFCxYoAACUAABAANAAAIBIAsgAAAAAACQABFAAAABQAAAAAAAAAAAAAQAAJAAEAAAasuNZccscltJNPvTRtbMW75QHkdXp5abPLFOrT2a6p8MptU2js+PuL1kUklJQSb+Lo48lvYWMoJt2b0rT34NUNkixhVsDFK2ZQ/512NrxKtnuapwcU0+oFiOr/KbUI211ey+Bax+I6zHjc4SSS4aVu/Toc3BGOTI4ybS4bT4O1DRKWkcMUt07V1drv6PgzZPrXfxt8O8c8V1WrjpsLTm02m0kqS/jY6+PxfVfmSxZopZE6lCapvvT4dr/AGef03h+tWpjkw48kMkXaa2r4/s+57nReH6d+DvH4jlhm1GW5uTq4uklT6V326mbmYTXKjm0+sxu4JSTpppWn2f3x7nE16jhypw2SfBdeL+n8TWmzTXnavHkjJO1eybW1rtff0Ob4zGccrTdNOmv3+pmRq11fD8ssmOKv7/U9j4ZBygrVtc9/ukeD/DuRyzKL3dqkfSPDFeN+xi9XG541a3CmnJX7M4Gr0rUm9kul1uer1apX7nmPEcslkcbque5Gpdjn/0qck2011RuwYtLjaU1Fpvlu2c7W5sikopuLeySe7ff4nB8Qy6jBllBQSkuW7b3NSWs2yXt9E0uk0GV2owfpSb+XBfnotPGDcIJN9Uq291+9nzbTLJ/Q49Vi1sfzJNReJKmm3W1P9jsPX+K+GZ1i1U5q6UVJ2mn1TatdnyW8bJ0zsr1E9JFP+xvfo2rrrTfwEMEFNNxVdKopeG+LLVpwyLyZUk2m079U+3O50oO2m2c7a1I2xiou1VPbbg85+NcCl4d5lzF89z01UvhZxfxVFS8Fz30Sa97LwvZynT5nCDSVvnb430/Y+leGfhTSw8PrNmmszScXFqk62tNcb7/AMnhPDcDyeJ6WDTaeVNJK3s+EvhXHc+ieKeIavS5McNPjSTSuTVuuy3/AHO3LlZcjnx4y68vqcE9NqMmHJXmg2nXHwNZa8TzPUa7JklFKTrzU+qST+q+hWSNS7Nc7MoAC6mAACgAKlAAFQAAAAAEEkAQSCCAAAIAAAAAAABAAKAAAAACwAGSiQAAABKkAAVQAAAAUAAAAAAAAAAQAAUAAAAAEAAA0YyaSbbSSVtsmTKviU/J4fmadPy0vi0v3CR5vU5ZanUzyt2pNtei6L5UVsiSaSXAcmuDFtt2w1GceCxge5XitjbibTSsH10sMU1TRnm06adojSNNJvqdaGBSWy4OduVqTXnlgnjyeaN/BHZ0GWKSU1Tfft9/fBdjolKqit/Q3Q0UYu/KkzNsrcli9pcuHHTg3a3pL75LT1zaaTatXTSfva7O380VMWCCjTVvubVjUVSSXwMtNGeODLJZM2nh5k7Ukqqm/wB9jz/i2X82bVKlw+rO1rsqgnFOnVs89q2ndPg1P+s1e/DuNrVK21XY+keHNxgk9vXujwH4ei3kUlvW9dfvc99pHUU12SfuZ5d1Z4s5m5Wmc3V6PDmalNU0nslSfudCdtWjCWN5I7K2jNV5HV6ObyLI2ot7uK3d+9X3rtwU9V4Vj1mZzyTnGTVNpKn6tff6HqtTo3JOlx+pU/IyxbSi2u6W/wAyy2eFkvrk+Ffh3T4dXDUOayPG1JRapNrdNpXe/r07HV8Y0stdjS1EU0nsktlvzfWrN+F54qMaSpVvs3+31NyhnyJqfC6LsLztJJPHB0nhmTBki4NTiraTbTXs13269D0Okg6XmVOlXf5m+GKKik4o3QhFcJJmbdVg0cf8RLz+FZo1dpKu+62O1NJKzi/iHI4+GZZpK0k6fCp/7HH1L48v+C9J/VfiTC3FuOKMpNpbJ00vqz1/jrWmWTNkabUfLFNdd6rr/o81+BMixa7U5ruXlSt78t3+h3vxYo5dJhzRbSWSnvs7T3+lL3Ot7sYmyWx5Z7tt8vl9WADo426kAFUAAAgkgAACiAAAAAEWCSACDCDAgAEEACgBDZIoAAAIABQAAAAAWSCSCASQSUCSCTKVAAKoAAAAKFixQoBYsUKAAAAAAAAAAACAAADQDYEMq+I45ZtDlhBNurSSu2ne3rt9S0zFoJHiZJp0yKOv4zpIafLHJj2jkbuPKTtNr42tt+vCo5bSrgNJitkZJ00RFbBumCOno5puK7M9BpJW1a5o8xpJpNNM72iyf3RTfBz5T66ca72GCaT7Fh400nf+Cnhy1VPcuRmpJJcq/v6HJ0lR5WnuYzflg2lb6M2qXO339/fBWzyXlab3X3+wRwvEM95n/dsm6OXmldlnxGaU5N9+DmuXmdnWeMW949P+HGozTZ73Qx80Uro8D4FJWmj33hS4Xwf7o531ueLGWKTSXejGOzsyzP8AuargxjuYo2SgpLdWaXiSbbSafN9CwnsqW/fovUUINCww/wDFfL7ZkopJJJV7Gc1SIi1sXAUV1SX8GLpcI2NpJvsaW92gTthkex538UNy8NyRinctnXRPlnoMrdbHP1GnWeD89+VSSdKnV29vRJidXSzenmPBdLm0TayKnkppdU7dp/F99zv+NRlLwJyfEJpv4uv3M4YP6rXVCCpOrX6GH4nyQ0+gx6NSTnOXmdPhLZX8Tctt1OWSY8sECTq4CAAAAFEAAB0IJIKAAAAACKFixQAChYAAAKIfsTZDXqBA4D2HJAsUKFgAABAAKAAJgsgCgAQBNEoAARQsULKAAAAAAAAJIBIEAAAAAAAAAAoAABZDRNkAYshkshmcFDxjFHL4fNtW4VJelPf6NnnKPYTjHJjlCatSTTXdNUzzev0MtJkdXLG/+Mqtezf3/FxZVRcP0IZkuDFclRswy8skuh19HnprujjVSTRa0+Rp0tmjNjcuPTabPuneydHTw5XJq3z16HmtLnbap7rk62mytpdaOdkjpLsdhySVrl8lTUytPbkyhNtJNe25S8R1H5WJtOm7+n3/AIMybcW3HB8Rk5ahQXLttFaOJpptq21sZ6aayah5JPdvZ+l0WZ+RZF7nSdTHK912vCMbxqLSbvfY954Jbi7fG3x2R47wuUGo06SXB7DweaSbe7ez9Uc766ydLOdNZGmqo1eemtuTfqWpTbTK8opxTZirO4sRkmk0T5rTVHL02oljzSxzdpN1b6HQjkTSaQlLGbt7NENJO0ZJrldjVkk1bNbiEpdDU3vaIct7b5/QwcrdJ7Gb2uIyNtNtjHgeXDFKTScm6XXpfyIlw0XcMX+TBPalfu3z+okRR82Lw2GecYqbhFu74rdWzxmt1ebW6mWbM7k9klwl0S9Ff6npPxZqFh0uPT47X5rbk73aVXfxa+R5NHbhOnLnbbhRIBvHMAAUDAKBBJAAAFAAAQAAAAAgUAAAAB8EAAQACAACgQSAIAAAAAWhQBkAABAAAkAFAAFEAAgAABYoULAAAACQBAAAAAAACiAABDIaMmYsghmLppppNPo+DJmLRRzfFsMVpPNCCTUk20ktuO3qcF8np9bj/M0mSNbuLa+G/wCx5h8sDZFJpVuZRbi76GGJrg2uNrbklVb0uRqVN88HY0mR+ZU+UcDC6aa5R1tFkaaT7GOUdON+O7ik5JNfE5Hj0pKDq6rc62lcZQ4u/oUfEo/mzakrSRiXK1fHA8NjGap7tXa7FfU5dTizyUknFPZpdOm/Q6E9F5Z+fG3Frs3XyNU8OXI2pxTa6pUb1jK6XgWuTyRTfNdT2+k1kYwTjNe1ngtF4TqZZFKCaSrjqe08J8Ji8aeaTcuKbr5HPlJutzc7ZeL/AIhh4fjTcJ5ZviMVe3dvhL4m3wbxxeJYFNxcG/8Atb3T9SxqdDllj/LUITVUrSdL5GXhHguHRp5JxTk3aXRLtXUxmt+K+pk8eq8zVJtU/c6elyqUFb56lfxfTKeF5IJeZJtJLcreH5ZSjHemlT+BT123kVKk26+nv/n4GnLJN0nsuWYxbST77vuu7Dk2mnuS3TGLTZFNXt0/c2R3rYibrgg1yV16tK+hanqIYsbbklGKttvZHH8X1EtPoZzg6yWlF9ne/wBDzGfW6jUO82aTXZul8kdOPG2bHO85Liz4zr//AFDWucWnjhagu65bfx49Dn0EiUdpMmONttASgaRIACsQAQCCSAAAESgAKoAAAAAgAEogAFAgkPglGIDBNAAFAAAQAChQFgmCyACAAB0AAKJAAAAAAAAAAAAAAAAAAAAARQsWKAAAAACiCHwSAMXyYsyZDAwlFSTT4ao8nmi8eacHym0/meto854ti/L102uJ1JP35+u/xAqQdSRYW6RVRZg7SM1WUH5XwXdPkamlxRSvbgzwS/6idGbNal7ep0svLiTujXqXF73u+Svhz1jSa4W25jPOslW97aZnO27WSgpJtPhNs26bB55pNc/Tj+TVil5ZLsy7o2llSYtJdr0fhWkjDG7iltatXt0LmnyKOocHs1RlpF5dPfdLjZ8bL6GmGOX9c+HaSdPijNutR01JvnglStpIhxarYjytNvjYgmaUotNbMoYtO8WVpRVc2+xdc0tnzTdei5IUlK2t168masrFOmSlbDST2Jiq3GrRtJGDk29zNo1y2VkR5/8AE2Z3iwJ1bcnv8F+5wki941lWXxKaT2glFfq/1ZRWx6OEyPPyu3U0TRFk2aRKAQKAYDKMWtxZJjRBJBJAAAFAAAAAAAAGLDDDIAAKFCxYaAgAGRAAKDDDDAgAFAAAWiCSCAAAJAAAAAAAAAAAAASAAIABQABAAAAAAQAAAYBRDBJAENGLRm0YtAQ1sc3xjTPLplkjzjttej/0jpNFXxFVocz/AP4aA8utjdCVJWalTV/MyToK33adGenjeRfA0Rdl/RxV21xRirPV7EmoK3ZT1Of8qbSt7vj3OpiimuNuj+Bpz6eMm9q3ft8zM9bsUMfiKTdO79fb+C1i8RlHImkk+nuVJaGH5jfD7pFnF4ZDK0kk23s739i2T6TXpPDvxFkisePI090lfNL/AGdjJ4jDFvjaXmdtvdt9NzymL8PZItSw5p7W6e9VfX4fU7Gm8IllzJZs03BK1W12lf6mbJ8bn/rqQ8f8iSyJP2at/CufQtw8Z02WCal5X2b3Zy//AEHR5JXCE2qVtyd3VXe/Xv2LEPw5pJJrL50mqpTaX6mLkVd/qseVOnaXWzZikm3XD6/frRyY+ES0UnHT5puCeyk7pdrOjpk2qbd3u+jJbPiLSbu3z1M001aMFSJbSSoyqWytq88MGGWWckoxVv8Ag2zmkudjgfiHVT8sNOuG/M2uqXC9v8GuM24luRxMs3kySm22223fqyFuQSj0Zkx573SiaCAAAASADQGLZkYslSIQYQYUAAAAFAAACCSAAAIIABQAAEAAghBhBgAABFCxQsokAEFgAEEgAAACiQAQAAUQAAAAAmxQoWBAJAEAAAAAAAAgAAAAAABRAomiAMWip4l/+hm/+r/VFxoqeJL/APAzf/V/qgPKRlTp8Ga2foYEp7UwrbGVF7BPin/JzYyp+hc07VozZsWXHWxZ9lHh/fBbilkg0+ae5ylKmmuUdLS5FJLfk52Y3LrN6fzKkt+nZvujPBppqUdt1un2dlzDjUlu+WmvgdHT47SSXCu/ivuyWtSKDzavHBpJq+r5Zc8O8VzzbhkTVK3ynfoWZ4H5LaTT6URh0zWRSpX/AIsza1I7Gmz/AJkE1Gu5ag0oq3z+pR07UXT2LKbfJm3VZ5XFx3NEYpSVGcney4NbREbG0uHZhKSpW69TCUq3ZXy5W35Yq2+Elbft/PxA3NvJkWOD3d2+i9Th/iSKx6zFBcLGt+rdu2z0GkwvHBue82re2y60vbn3v4ee/E8k/EMa741zzyzp+c7Y5uQiUQiUdrXFIAAAAGpAIZoGQyWQzOgADQihYsUAAAAAACGSAIABBAAKAAAcDkcjgzoxoWLFDQAoFAgkgRKAAqrRBJFGUlAAFSSQSAAAAAAQACgSQSAAAAAACCSAAAAAAAACgACCAAAABRDOb4vqYY8EsK3lOLtdl6/x9u9qc8NPglmyOoxW/q+i/Q8xlzSzPJOT3nbfVeiv0QkTdUgFwGGolMsaabUqsqt2zKEnFponwdflJot6OVNJ9eDlYs7cUky3p8lu09+3QxZ01Lj1WllGSVv+Dq6Zq4xXW7b++1HmtFqKiotpO29kdvTZrSd2+i3qvqc77jrLK68PJJtVdOud0yxDBCStq+3f/RzJZZxaadp001vVcq+foXNLq40k5VXXpdOzOLatx06vdNduf3DVKkw9RFqrtNXZg8idVuS9LKzSNeSaimRPMop3aS5bKGXPPUT8mFXbpu9l62RGU8rnJQxpyk+EuPey5pNIsSc5tOb69vReg0WkjiSk1u923yy6lTAiq2R478UyT8YSvdYU36O3R7J82eE/Emojl8cztO1CMYX61b/U6/nNrHO9KsWnw7ozXBSxSam5L/BcTTSa4Z2sxxZUAiSFEGEGIAANCAAQQACiAAS0AAUAAAAAEAAgAAogAABYFEEAAggAFAAAAABaFAERAJAVBIAAAACCSBoAAokAFAAWQRZFk2RYEgAAAAAAAAAAAAIAAAACDifiPUNLFp4tU/7pe3CX6/Q5TXl0ym9m7SXvyT4zl/O8TzNO0moprjZU/rZXy5G0oJ7Jtv1v/FF8MYoUESkBFAyaoigJi2nsyzh1Dg1afuislbN0I20roliurg1STTTd9juaPW2oty2aSp9meXhgUqqTT9y7gxZ4pOE7fqq+pjlGpbPHqoapJ7u12N2HUxtpO23ST9Poecxf1jf/ABg97u3/AAXMeLXyTcVjT2q5vff2+7OeRuWvRf1SpbttJtkvXQxxcpOPxZyMHh+typueohBd4pt/XqdjSeFYcTU5Xkkqdydu/bhEsjUtrWnqdd/dTxYXvb3bXoui90dLS6WGHGoQVL5u+d336/E34sUVFUkqNqVKvkZvQyglv6GTRgm1unXp8L39SM2aGDE8mRpRSttvYhareJ6zH4fo8mozJuMFsk6bb4S92z5zqc082onmyNOWSTk64TbvY6Pj3jc/EtT5YNLTY2nFf+TVpt/ov5OS35naXJ6fz45Nrlz5b1G2Dr4lvDK15X03RUxLbfob4ummjpZrmtIERaaTTMjNlUAAAhkgogXRIJggB7AogAACCSAAAAAAAAAIAAEULFigJIJIAEEkGaIbJAKIYDAAAE0WgQAiQAFAAABINJqAAZUAAChYsUULIJoxsA9gSRQEgAAAAAAAAAAAAmgMM2bHgxueaahFctv7v4I4Wt8dnJvHpNorZya3fsunuWRXZ1Oqw6XG55ppKnSvd12X7/VHE1njebJjcdOvy006b3b9fTa+DkZc08knLJJzk+W2238zXdjCRlfMnvRrTdvuZLlp8MxaptCrjZE2JbJmuPBshvSCMqsxcTakJRe1IDWlRvxLdGtRt8G2CrjZkqx0tNGMqo7Gm00bVJv4nG0jaaTXU9HoZRlFNr5pOjnyrcixi08Uk2vhuX8OBJJKKXwSROOLcdkmu6pG6EZb3/k52t4344qKTT49Of3LEEk0q2NMEkqe7XC6319Of1LOJOTTaoixtVJbInzNcJr3MJThBNp3XPr8Tna3xSGDG5znCKXVtqiSWluLufVYtPjc2+OG67fE8T+IfHJ65/0+Kf8A0l/yadNvtZU8V8dyayUoY21Fctum/ZHHTs78OGd1y58/kbU7pcJbG6LW1IrRdG/HJN03R0clmHBnaXXYwi0kraRjKSfD6lVGqzzw445ISaakk1ezT6fRfUt4NQsmNTdU+Wuj7HL8TklpYp7XJL2N/hrvSJdra7tdAOqmmrTTXoGylDJTtOn9H9/IsQyqWz2ffoTBtTBCaq07RIUAIsmmgJBRjQbDYarqwBBJAAAAAAAAAAAAQAAIIRIAUGxYaIIIJIAWKFCwIoCwBaABESAAoAAJAIZoSLIBnQAAygACgQSQAABRKDCDIIAAAAhtRTbaSSttvgCQUNT4tpcKag3kl2jx8zkavxbUahuKk8UH0i3b93s2WQd7Ua3T6dP83IlJf9q3fy/k5Gs8dnbjpoeVf+Ut38On6nHlOUrttt7tvlv3MGhINmbPlzTcs05TfKbbdffoaW7HuQ2UkQ2GGQyaJTMmk1a2aMEZwkk9+ApE2w5RHlTdp7GcVuKjbBWzd5bXc1QW7b46otQi/LsrJbiyKrTT3LGKKkkmYTik/wBuhu08Xtv8+hL50si3gwSjSTSXZ9Pb0O1oXONNK105/Y5+CK2vf9fkdTTRaaabVem3z3Od7jcdjC5uKbju1zar5lvFCTTb29mUsUlBJPdpfFm6WrjjTTfH1MWa06CcMdN7Xwas2thjTTd/Gv1/k894j47hwWpzbkuIp7v3XRHmtb4pqtbLabhj6pPd+7NceFrN5SPR+K/iOGJyhjksmRdE9l6N/qeV1Or1Grk5ajI5PlJWkn7GrjZkHWcJO3O8raWSmQSjdZZJmXma4ZiggNvnbSVmWKTc6b977GpLY22sUHkaTSXD67bFFfX5FmzRxLdp0/cvaSoY1S4RysavIptN27bXNvl183sdPFJeWlvQGWVpbpfAYdRbak7rhmVLJFxap1a9ym04ZGm6d18gOpDJStO/W9/mb4ZU0m+focvHm8svKyxHKnw6JZo6CkmthyVYZGqpm2ORPnkllVtXLBCaa2JJ4Ioh7koWUQAAIDJIAMgkgAACCQAVKgABQgkgzogCgBAAKAAAAAC0ACIAAKAACQAaEmJkYkAE0QOwBIKmhBNkEqoABOwTJaISJbAUKNWfPj08PPmmor1dt+y6v2OFrfF8ue4YU4Qezbe792ak0dLWeK4NPag/zMiTVJ7J+r3+hwtXr82rf/UlSW6itkvv1K0m27ZCdlkwQ5NcbGLRk0YsohsN7EtEMgxfLIZNeoa2AwYJYJVQSiCUEb8TdO/l1Nqa81eZX2tfp/gredxTS579tt0a02uNharpwVy2LWJVt62cfHqJwaumuz3OlpNRDK1F7NdO5LOhvy4k1bVP0IwtqVc+pZpSjua3BJ7E1qLmHJTTpez3Xv8Ae5cjqoxprZe9I4ayOLdWa8mrnsk926XqyWaW47uo8ax4UlSnJ7JKudq36dNzj63xjU5V5U1BPnyun8Xt9CpGMpXJ22+W+r7/AKfJGrKnbTaV92WcZGbbVV5ZrN+Y23Lq2+Tp4pxljUo8Nfa+HBy5xcXSZZ0GRJvG+u6/c14l7XJbu0Qk73TRmk2rXYJWUR5bCi3wZqPczS7BGtRfU2Rx9W3RmotmaXlVMowSa3TTT9d2adTLzLypJJc937m2a8qtdOPQp5p3e/IGOB1O+xeUaqUXT782uzXb7XQo4FTvudHC7tARB03F7N8NO16exqyx82VvhK7++xtzRe98PldzSrW6trim+n2uoGWR0k+wxTdWzVOSlJ0+Pv5GdqKSYFiGdxmlsvXn5FmGS3s/c5ibk10s3LI4ptAdSGSnTNqknwc/DnUt3y/l93ZajKulks0b0yKMYu1f06+xkzF6UABRAAKAAAgAAAAEoAAqAAAYYYYEEEkEAAAAABaABEAAAAAUAAAAASADQAACCSCQIoAqa7X4dJBtyUpriKe79X29yZoszlGEXKclFJW23S+ZyNX4yk3DSq+jk/2X8nN1WuzauV5JNRWyinSXw7+rKzaWxZIluNmbNkz5HPLNzb6t3XoamiJPcxcn3L4EmqpkJvoQ3ZsiqW5VYvgxZmzBsCGQ9yWCBRFE0KBKwaMWtzJmLJVCY7uvR/oQZwV23wk/mDGthcmflbVoxoYLco6X+hhKOTJ/VfmNSg4pRUUtmn3bsrwnLHJSg2mjFoUJB3tBqPz8O9Jp06++9G3K0rs4el1EtPk8ybSezR29Q08cZxdppNfEzZl1dc/PkptJlfHJyyu3aW9evH6WY55NSas3abFGWNNqm+vp+nc1Ercnzs/kYTtq649TJxa5afsiZRXYsjOqWVf3GrDP8vLGXRPf2Lc8SdtFTIkntsSwldqDTSa3TVoyStP79f2KOgzKUHCT3XC7r/BdT+/UQrJJdTKPlXPJrbMkiq3JxXBDk3aRikkuxjKTim1zwVGGWTSpspzdyN2SW1GmKcsirhcgb8UKq+haxOpGlbGeJ/3ft0AsZVasqztFp7o0zVoDS0mm3/n5kNPm1XRvkyaMJtNUBMGkt00/Xrv8uvcicm0ktqdiTuv06Gpp06db8dALGCTu75L2DKmmm+L6voc2HnjFWrXps/qbMMl500/dcFHWjKr259TaptJN7p9+UUVl8qp7r33N0MikrTu+VsjNmi2natBmmM2t1uuxuTTVolmEqGAwFAAAAAEAAAAAIAAAAA0ZjRk2Q9wIIomiLAUBYAtgAygAAAACpQYBRAAIJABoGSgAMQuQDI5vjmqzabHix4JeXz2nJcr2Z5qUnJeZu22AangN0thF2AaiIl/yIlygARONW0ZsAhWL4ZrYBVGSAT6AYAGEuDEAlBmyH/xy9gAtImLX9zQA+ILgxXIAWskdnTTlPwvG5O6bX1AJSOXqf+bLmn/+CP8A9UAWJW3t7EJJgGkROKp7FLPFU9gBSNGKTjmTi6aZ20AZKMyjwgCib5NeRtSSQBRXyvcywLf4AAbnwIcoAItrg1zACtM+TQ3cviAESzBgAbl/wRshFPDbW64YADFJyTUndUb4tpqgCquY94J+/wCpmgCUZwdoyAMX1RhAAAAEoAAVAAKqGGACjDAAMxYABgAgAAD/2Q==");
		userInfo.setImageType("BASE64");
		userInfo.setProvince("浙江省");
		userInfo.setCity("宁波市");
		userInfo.setAddress("浙江省宁波市太湖县杨高南路428号由由世纪广场5号楼");
		userInfo.setIdcardAuthority("浦东公安局");
		userInfo.setIndustry(NiwodaiCostant.Industry.ENTERTAINMENT.name());
		userInfo.setIncome(NiwodaiCostant.Income.FOUR.name());
		userInfo.setIncomeType(NiwodaiCostant.IncomeType.SALARY.name());
		userInfo.setDebt(NiwodaiCostant.Debt.TWO.name());
		vo.setUserInfo(userInfo);
		NiwodaiCostant.LoanInfo loanInfo = new NiwodaiCostant.LoanInfo();
		loanInfo.setAmount(new BigDecimal("10000.00"));
		loanInfo.setTerm(12);
		loanInfo.setPurpose(NiwodaiCostant.Purpose.CONSUMPTION.name());
		vo.setLoanInfo(loanInfo);
		NiwodaiCostant.Contacts contacts = new NiwodaiCostant.Contacts();
		contacts.setNameA("秦牧");
		contacts.setPhoneA("18377335100");
		contacts.setRelationshipA(NiwodaiCostant.Relationship.CLASSMATE.name());
		contacts.setNameB("刘思");
		contacts.setPhoneB("18777193627");
		contacts.setRelationshipB(NiwodaiCostant.Relationship.CLASSMATE.name());
		vo.setContacts(contacts);
		NiwodaiCostant.CompnayInfo compnayInfo = new NiwodaiCostant.CompnayInfo();
		compnayInfo.setAddress("上海市浦东区");
		compnayInfo.setName("玩的溜有限公司");
		compnayInfo.setCity("上海市");
		compnayInfo.setProvince("上海市");
		vo.setCompanyInfo(compnayInfo);
		NiwodaiCostant.MnoData mnoData = new NiwodaiCostant.MnoData();
		vo.setMnoData(mnoData);
		NiwodaiIncomingResponseVO responseVO = niwodaiService.incoming(vo, "");
		System.out.println(JSON.toJSONString(responseVO));
	}

	@Test
	public void testRedis() {
		String bizNo = "427114368038989811";
		String fundId = "240";
		AidLoanFundRouteRecord record = aidFundRouteRecordService.findByBizNoAndFundId(bizNo, fundId);
		redisService.setEntityEx("testestst", record, 5, TimeUnit.MINUTES);

		AidLoanFundRouteRecord record1 = redisService.getEntity("testestst");
		aidFundRouteRecordService.updateAidLoanFundRouteRecordStatus(record1, 3);
		System.out.println("完成");
	}

	@Test
	public void testResult() {
//		String bizNo = "AN00000013443572551716033";
//		System.out.println(niwodaiAssetService.incomingResult(bizNo));
		System.out.println(JSON.toJSONString(userSdkService.findUserInfoByUuid("c5e485e2-8cfc-4d65-b090-47d96e4fca41").getData()));
	}

	public static void main(String[] args) throws InterruptedException {
		Stopwatch stopwatch = Stopwatch.createStarted();
		System.out.println(stopwatch.elapsed(TimeUnit.MILLISECONDS));
		TimeUnit.SECONDS.sleep(10);
		System.out.println(stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
	}
}
