package com.quantgroup.asset.distribution.service.jpa.entity;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * @author : Hyuk
 * @description : AidLoanFundAuditOrder
 * @date : 2020/3/30 1:28 上午
 */
@Entity
@Table(name="aid_loan_fund_audit_order")
@Data
public class AidLoanFundAuditOrder implements Serializable {

    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "asset_no")
    private String assetNo;

    @Column(name =  "fund_no")
    private String fundNo;

    @Column(name = "uuid")
    private String uuid;

    @Column(name = "biz_no")
    private String bizNo;

    @Column(name = "fund_id")
    private String fundId;

    @Column(name = "asset_form_text")
    private String assetFormText;

    @Column(name = "asset_text")
    private String assetText;

    @Column(name = "data_text")
    private String dataText;

    // 1-通过,2-拒绝,3-审核中
    @Column(name = "audit_result")
    private Integer auditResult;

    @Column(name = "audit_context")
    private String auditContext;

    @Column(name = "enable")
    private Boolean enable;

    @Column(name = "created_at")
    private Timestamp createdAt;

    @Column(name = "updated_at")
    private Timestamp updatedAt;

    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
