package cn.quant.andy.jpa.entity;

import cn.quant.spring.data.jpa.entity.DescriptionEntity;
import cn.quant.spring.util.StringUtils;

import javax.persistence.Column;
import javax.persistence.Id;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

public class BalanceSummaryEntity extends DescriptionEntity {

    @Id
    @Column(name = "TERM_NO", nullable = false, updatable = false)
    private Integer termNo;

    @Id
    @Column(name = "BASE_CODE", nullable = false, updatable = false)
    private String baseCode;

    @Id
    @Column(name = "BASE_ORDER_NO", nullable = false, updatable = false)
    private String baseOrderNo;

    @Column(name = "SUMMARY_NO", nullable = false, updatable = false)
    private Integer summaryNo;

    @Column(name = "RT_TERM_NO", nullable = false, updatable = false)
    private Integer rtTermNo;

    @Column(name = "RT_BASE_CODE", nullable = false, updatable = false)
    private String rtBaseCode;

    @Column(name = "OPEN_BALANCE", nullable = false, updatable = false)
    private BigDecimal openBalance;

    @Column(name = "CLOSE_BALANCE", nullable = false, updatable = true)
    private BigDecimal closeBalance;

    @Column(name = "CREDIT_AMT", nullable = false, updatable = true)
    private BigDecimal creditAmt;

    @Column(name = "CREDIT_COUNT", nullable = false, updatable = true)
    private Integer creditCount;

    @Column(name = "DEBIT_AMT", nullable = false, updatable = true)
    private BigDecimal debitAmt;

    @Column(name = "DEBIT_COUNT", nullable = false, updatable = true)
    private Integer debitCount;

    @Column(name = "BILL_CODE", nullable = false, updatable = true)
    private String billCode;

    @Column(name = "BILL_DATE", nullable = false, updatable = true)
    private LocalDate billDate;

    public Integer getTermNo() {
        return termNo;
    }

    public void setTermNo(Integer termNo) {
        this.termNo = termNo;
    }

    public String getBaseCode() {
        return baseCode;
    }

    public void setBaseCode(String baseCode) {
        this.baseCode = baseCode;
    }

    public String getBaseOrderNo() {
        return baseOrderNo;
    }

    public void setBaseOrderNo(String baseOrderNo) {
        this.baseOrderNo = baseOrderNo;
    }

    public Integer getSummaryNo() {
        return summaryNo;
    }

    public void setSummaryNo(Integer summaryNo) {
        this.summaryNo = summaryNo;
    }

    public Integer getRtTermNo() {
        return rtTermNo;
    }

    public void setRtTermNo(Integer rtTermNo) {
        this.rtTermNo = rtTermNo;
    }

    public String getRtBaseCode() {
        return rtBaseCode;
    }

    public void setRtBaseCode(String rtBaseCode) {
        this.rtBaseCode = rtBaseCode;
    }

    public BigDecimal getOpenBalance() {
        return openBalance;
    }

    public void setOpenBalance(BigDecimal openBalance) {
        this.openBalance = openBalance;
    }

    public BigDecimal getCloseBalance() {
        return closeBalance;
    }

    public void setCloseBalance(BigDecimal closeBalance) {
        this.closeBalance = closeBalance;
    }

    public BigDecimal getCreditAmt() {
        return creditAmt;
    }

    public void setCreditAmt(BigDecimal creditAmt) {
        this.creditAmt = creditAmt;
    }

    public Integer getCreditCount() {
        return creditCount;
    }

    public void setCreditCount(Integer creditCount) {
        this.creditCount = creditCount;
    }

    public BigDecimal getDebitAmt() {
        return debitAmt;
    }

    public void setDebitAmt(BigDecimal debitAmt) {
        this.debitAmt = debitAmt;
    }

    public Integer getDebitCount() {
        return debitCount;
    }

    public void setDebitCount(Integer debitCount) {
        this.debitCount = debitCount;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public LocalDate getBillDate() {
        return billDate;
    }

    public void setBillDate(LocalDate billDate) {
        this.billDate = billDate;
    }

    @Override
    public String persistenceKey() {
        return StringUtils.toDelimitedString(BalanceSummaryEntity.class, termNo, baseCode, baseOrderNo);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof BalanceSummaryEntity)) return false;
        BalanceSummaryEntity that = (BalanceSummaryEntity) o;
        return Objects.equals(termNo, that.termNo) &&
                Objects.equals(baseCode, that.baseCode) &&
                Objects.equals(baseOrderNo, that.baseOrderNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(BalanceSummaryEntity.class, termNo, baseCode, baseOrderNo);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("BalanceSummaryEntity{");
        sb.append("termNo=").append(termNo);
        sb.append(", baseCode='").append(baseCode).append('\'');
        sb.append(", baseOrderNo='").append(baseOrderNo).append('\'');
        sb.append(", summaryNo=").append(summaryNo);
        sb.append(", rtTermNo=").append(rtTermNo);
        sb.append(", rtBaseCode='").append(rtBaseCode).append('\'');
        sb.append(", openBalance=").append(openBalance);
        sb.append(", closeBalance=").append(closeBalance);
        sb.append(", creditAmt=").append(creditAmt);
        sb.append(", creditCount=").append(creditCount);
        sb.append(", debitAmt=").append(debitAmt);
        sb.append(", debitCount=").append(debitCount);
        sb.append(", billCode='").append(billCode).append('\'');
        sb.append(", billDate=").append(billDate);
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}