/*
Navicat MySQL Data Transfer

Source Server         : local
Source Server Version : 50717
Source Host           : 127.0.0.1:3306
Source Database       : reconciliation-1.0.0

Target Server Type    : MYSQL
Target Server Version : 50717
File Encoding         : 65001

Date: 2021-11-16 14:47:00
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for application_profile
-- ----------------------------
DROP TABLE IF EXISTS `application_profile`;
CREATE TABLE `application_profile` (
  `TYPE_CODE` char(4) NOT NULL COMMENT '配置码',
  `TABLE_FIELDS` varchar(1000) NOT NULL COMMENT '表字段',
  `POST_DATE_INDEX` tinyint(2) NOT NULL COMMENT '入账时间索引',
  `DESC_TEXT` varchar(400) DEFAULT NULL COMMENT '描述',
  `CREATED_BY` varchar(32) NOT NULL COMMENT '创建用户',
  `CREATED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `MODIFIED_BY` varchar(32) NOT NULL COMMENT '更新用户',
  `MODIFIED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `MODIFIED_NO` int(8) NOT NULL DEFAULT '0' COMMENT '更新次数',
  `EXTENDED_FIELD1` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD2` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD3` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`TYPE_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of application_profile
-- ----------------------------
INSERT INTO `application_profile` VALUES ('INST', 'SERIAL_NO,TXN_TYPE,TXN_CODE,TXN_NO,TXN_FLAG,BASE_ORDER_NO,STATUS_CODE,PRODUCT_ORDER_NO,COMMODITY_NAME,BANK_CODE,BANK_ACCT_NO,TXN_TIME,POST_AMT,LEVEL_NO', '11', null, 'SYS', '2021-07-17 20:33:55', 'SYS', '2021-07-29 21:05:49', '0', null, null, null);
INSERT INTO `application_profile` VALUES ('PROD', 'BASE_ORDER_NO,ORDER_NO,GEN_ORDER_NO,LEVEL_NO,VOLUME,SERIAL_NO,TXN_CODE,TXN_TYPE,TXN_FLAG,ORIGINAL_AMT,POST_AMT,TXN_TIME,REFERENCE_NO', '11', null, 'SYS', '2021-07-17 20:33:55', 'SYS', '2021-07-28 14:27:11', '0', null, null, null);

-- ----------------------------
-- Table structure for balance_billing
-- ----------------------------
DROP TABLE IF EXISTS `balance_billing`;
CREATE TABLE `balance_billing` (
  `TERM_NO` mediumint(9) NOT NULL COMMENT '期次号',
  `TYPE_CODE` char(4) NOT NULL COMMENT '类型码',
  `NEXT_SUMMARY_NO` int(11) NOT NULL COMMENT '序列号',
  `BALANCE` decimal(9,2) NOT NULL COMMENT '余额',
  `CREDIT_AMT` decimal(9,2) NOT NULL COMMENT '贷记金额',
  `CREDIT_COUNT` mediumint(255) NOT NULL COMMENT '贷记次数',
  `DEBIT_AMT` decimal(9,2) NOT NULL COMMENT '借记金额',
  `DEBIT_COUNT` mediumint(255) NOT NULL COMMENT '借记次数',
  `STATUS_CODE` char(4) NOT NULL COMMENT '记账码',
  `TARGET_BILLS` int(255) NOT NULL COMMENT '目标记账数',
  `TOTAL_BILLS` int(255) NOT NULL COMMENT '总记账数',
  `LF_FAILED_BILLS` int(255) NOT NULL COMMENT '左侧失败记账数',
  `RT_FAILED_BILLS` int(255) NOT NULL COMMENT '右侧失败记账数',
  `LAST_STATUS_CODE` char(4) DEFAULT NULL,
  `BILL_DATE` int(8) DEFAULT NULL COMMENT '记账日期',
  `DESC_TEXT` varchar(400) DEFAULT NULL COMMENT '描述',
  `CREATED_BY` varchar(32) NOT NULL COMMENT '创建用户',
  `CREATED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `MODIFIED_BY` varchar(32) NOT NULL COMMENT '更新用户',
  `MODIFIED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `MODIFIED_NO` int(8) NOT NULL DEFAULT '0' COMMENT '更新次数',
  `EXTENDED_FIELD1` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD2` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD3` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`TERM_NO`,`TYPE_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of balance_billing
-- ----------------------------
INSERT INTO `balance_billing` VALUES ('202106', 'INST', '1', '0.00', '0.00', '0', '0.00', '0', 'SUCC', '11956', '0', '0', '0', 'SUCC', '20210902', '', 'SYS', '2021-07-25 11:31:05', 'SYS', '2021-09-02 18:29:31', '0', '', '', '');
INSERT INTO `balance_billing` VALUES ('202107', 'INST', '12600', '2368270.34', '3301094.83', '12527', '932824.49', '1516', 'SUCC', '11956', '14043', '0', '0', 'INIT', '20210901', null, 'SYS', '2021-07-25 11:31:05', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);

-- ----------------------------
-- Table structure for balance_summary
-- ----------------------------
DROP TABLE IF EXISTS `balance_summary`;
CREATE TABLE `balance_summary` (
  `TERM_NO` mediumint(9) NOT NULL COMMENT '期次号',
  `BASE_CODE` char(4) NOT NULL COMMENT '基准码',
  `BASE_ORDER_NO` char(64) NOT NULL COMMENT '左侧基准单号',
  `SUMMARY_NO` int(11) NOT NULL COMMENT '序列号',
  `OPEN_BALANCE` decimal(9,2) NOT NULL COMMENT '期初余额',
  `CLOSE_BALANCE` decimal(9,2) NOT NULL COMMENT '期末余额',
  `CREDIT_AMT` decimal(9,2) NOT NULL COMMENT '贷记金额',
  `CREDIT_COUNT` mediumint(255) NOT NULL COMMENT '贷记次数',
  `DEBIT_AMT` decimal(9,2) NOT NULL COMMENT '借记金额',
  `DEBIT_COUNT` mediumint(255) NOT NULL COMMENT '借记次数',
  `BILL_CODE` char(4) NOT NULL COMMENT '记账码',
  `BILL_DATE` int(8) NOT NULL COMMENT '记账日期',
  `RT_TERM_NO` int(11) NOT NULL COMMENT '右侧期次号',
  `RT_BASE_CODE` char(4) NOT NULL COMMENT '右侧基准码',
  `DESC_TEXT` varchar(400) DEFAULT NULL COMMENT '描述',
  `CREATED_BY` varchar(32) NOT NULL COMMENT '创建用户',
  `CREATED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `MODIFIED_BY` varchar(32) NOT NULL COMMENT '更新用户',
  `MODIFIED_DATE` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `MODIFIED_NO` int(8) NOT NULL DEFAULT '0' COMMENT '更新次数',
  `EXTENDED_FIELD1` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD2` varchar(4) DEFAULT NULL,
  `EXTENDED_FIELD3` varchar(4) DEFAULT NULL,
  PRIMARY KEY (`TERM_NO`,`BASE_CODE`,`BASE_ORDER_NO`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of balance_summary
-- ----------------------------
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1384034932933980160', '12597', '0.00', '-0.01', '0.00', '0', '0.01', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1400008732338999296', '12590', '0.00', '-92.00', '0.00', '0', '92.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1403260326413234176', '12593', '0.00', '-0.01', '0.00', '0', '0.01', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1403275804351303680', '12594', '0.00', '-0.01', '0.00', '0', '0.01', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1404040075549040640', '12567', '0.00', '-299.00', '0.00', '0', '299.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1404048202134642688', '12543', '0.00', '-99.00', '0.00', '0', '99.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1405134010333757440', '12582', '0.00', '-161.22', '0.00', '0', '161.22', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1405404839638413312', '12599', '0.00', '-319.20', '0.00', '0', '319.20', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1405465460505559040', '12541', '0.00', '-149.00', '0.00', '0', '149.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1405489816061276160', '12568', '0.00', '-107.38', '0.00', '0', '107.38', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1405644104787976192', '12584', '0.00', '-342.82', '0.00', '0', '342.82', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1405720552781574144', '12561', '0.00', '-12.43', '0.00', '0', '12.43', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1406032729916747776', '12531', '0.00', '-11.00', '0.00', '0', '11.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1406088705965502464', '12551', '0.00', '-0.09', '0.00', '0', '0.09', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1406152095278772224', '12552', '0.00', '-25.50', '0.00', '0', '25.50', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1406201336579637248', '12592', '0.00', '-3.20', '0.00', '0', '3.20', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1406565837317537792', '12557', '0.00', '-99.00', '0.00', '0', '99.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1406624087996018688', '12596', '0.00', '-4.59', '0.00', '0', '4.59', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1406784847665586176', '12544', '0.00', '-99.00', '0.00', '0', '99.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1406792279750017024', '12585', '0.00', '-67.33', '0.00', '0', '67.33', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1406838774780051456', '12542', '0.00', '-299.00', '0.00', '0', '299.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1406941107144802304', '12554', '0.00', '-149.00', '0.00', '0', '149.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1406983598866907136', '12563', '0.00', '-419.00', '0.00', '0', '419.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1407110906302910464', '12534', '0.00', '-599.00', '0.00', '0', '599.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1407185968364228608', '12575', '0.00', '-76.00', '0.00', '0', '76.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1407214784683843584', '12577', '0.00', '-299.00', '0.00', '0', '299.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1407281362289020928', '12535', '0.00', '-484.08', '0.00', '0', '484.08', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1407331101583851520', '12556', '0.00', '-299.00', '0.00', '0', '299.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1407558149719859200', '12533', '0.00', '-63.51', '0.00', '0', '63.51', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1407560268006948864', '12536', '0.00', '-19.00', '0.00', '0', '19.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1407589210986373120', '12580', '0.00', '-1729.00', '0.00', '0', '1729.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1407633574911504384', '12537', '0.00', '-529.09', '0.00', '0', '529.09', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1407752767258386432', '12545', '0.00', '-26.20', '0.00', '0', '26.20', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1407944376595914752', '12576', '0.00', '-1199.00', '0.00', '0', '1199.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1408113982874767360', '12600', '0.00', '-0.12', '0.00', '0', '0.12', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1408438156029829120', '12555', '0.00', '-449.60', '0.00', '0', '449.60', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1408458772569100288', '12558', '0.00', '-1.08', '0.00', '0', '1.08', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1408606269325094912', '12588', '0.00', '-6.83', '0.00', '0', '6.83', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1408641863925338112', '12546', '0.00', '-70.00', '0.00', '0', '70.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1408651918317887488', '12586', '0.00', '-67.10', '0.00', '0', '67.10', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409002269177008128', '12564', '0.00', '-187.00', '0.00', '0', '187.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409071205880934400', '12539', '0.00', '-113.43', '0.00', '0', '113.43', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409092776704040960', '12529', '0.00', '-19.60', '0.00', '0', '19.60', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409239909931343872', '12583', '0.00', '-10.90', '0.00', '0', '10.90', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409350494790590464', '12572', '0.00', '-386.64', '0.00', '0', '386.64', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409380893595971584', '12530', '0.00', '-21.40', '0.00', '0', '21.40', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409424931606896640', '12559', '0.00', '-16.20', '0.00', '0', '16.20', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409454244859371520', '12565', '0.00', '-211.00', '0.00', '0', '211.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409528849858994176', '12591', '0.00', '-104.67', '0.00', '0', '104.67', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409629290093596672', '12587', '0.00', '-6.22', '0.00', '0', '6.22', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409679774431031296', '12574', '0.00', '-299.00', '0.00', '0', '299.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409724372415102976', '12569', '0.00', '-30.20', '0.00', '0', '30.20', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409816229455306752', '12578', '0.00', '-0.01', '0.00', '0', '0.01', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409821585422086144', '12579', '0.00', '-0.01', '0.00', '0', '0.01', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1409920494555291648', '12547', '0.00', '-35.20', '0.00', '0', '35.20', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410069629937823744', '12573', '0.00', '-7.40', '0.00', '0', '7.40', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410115647496671232', '12540', '0.00', '-199.00', '0.00', '0', '199.00', '1', 'RAIT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:56:02', 'SYS', '2021-09-01 17:56:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410267117512695808', '2', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410267750236065792', '6', '499.00', '0.00', '499.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410268406917332992', '5', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410271376279056384', '8', '211.00', '0.00', '211.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410271859634827264', '7', '7.60', '0.00', '7.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410273329356709888', '9', '29.80', '0.00', '29.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410274516994859008', '10', '58.00', '0.00', '58.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410275675847401472', '11', '426.50', '0.00', '426.50', '1', '426.50', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410276560849747968', '12', '1999.00', '0.00', '1999.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410279015788457984', '15', '9.94', '0.00', '9.94', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410279902007234560', '16', '78.68', '0.00', '78.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410280507522027520', '17', '398.00', '0.00', '398.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410281417073651712', '18', '3039.99', '0.00', '3039.99', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410286147896238080', '19', '8.00', '0.00', '8.00', '1', '8.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410287566296596480', '20', '298.00', '0.00', '298.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410287888578531328', '21', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410291347008749568', '22', '22.40', '17.52', '22.40', '1', '4.88', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410294408997478400', '23', '36.81', '0.00', '36.81', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410298223016439808', '24', '199.00', '100.00', '199.00', '1', '99.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410304436957487104', '25', '15.30', '0.00', '15.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410305486456340480', '26', '198.00', '0.00', '198.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410319110960734208', '27', '41.27', '0.00', '41.27', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410336040165715968', '28', '82.70', '0.00', '82.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410346175726587904', '29', '29.60', '0.00', '29.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410353088585404416', '30', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410354736561098752', '31', '634.52', '0.00', '634.52', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410359488757858304', '32', '61.20', '0.00', '61.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410360172362321920', '33', '119.44', '0.00', '119.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410361746979536896', '34', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410363317276528640', '35', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410367845732339712', '36', '160.44', '0.00', '160.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410374999679832064', '39', '27.24', '0.00', '27.24', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410375900062789632', '41', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410376062273290240', '40', '549.00', '0.00', '549.00', '1', '549.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410377460146663424', '42', '4.40', '0.00', '4.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410377839840210944', '44', '8.00', '0.00', '8.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410378444260499456', '43', '9.70', '0.00', '9.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410380118999855104', '46', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410381357976289280', '47', '437.01', '0.00', '437.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410382714439450624', '48', '16.06', '0.00', '16.06', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410386135787634688', '49', '492.00', '0.00', '492.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410387890462232576', '51', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410388081227472896', '50', '8.27', '0.00', '8.27', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410389101760385024', '52', '698.33', '0.00', '698.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410390559088087040', '53', '1999.00', '0.00', '1999.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410391080729538560', '54', '23.17', '0.00', '23.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410394709632999424', '55', '31.50', '0.00', '31.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410396105358950400', '56', '48.17', '0.00', '48.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410396322527313920', '57', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410398017726582784', '59', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410398259645665280', '58', '24.10', '0.00', '24.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410400126488424448', '61', '78.73', '0.00', '78.73', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410400403388010496', '60', '32.00', '0.00', '32.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410401291527766016', '62', '1.50', '1.26', '1.50', '1', '0.24', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410404503366373376', '66', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410405601103822848', '64', '234.00', '0.00', '234.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410406024703279104', '63', '360.58', '0.00', '360.58', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410406373774311424', '65', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:42', 'SYS', '2021-09-01 17:54:42', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410407191852343296', '68', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410408103899443200', '67', '15.01', '0.00', '15.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410408805463891968', '74', '122.07', '0.00', '122.07', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410408871914348544', '69', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410409041150238720', '70', '64.83', '0.00', '64.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410410780247089152', '73', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410412007567622144', '75', '359.17', '0.00', '359.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410412173091557376', '76', '405.62', '0.00', '405.62', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410412649497460736', '77', '177.33', '0.00', '177.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410412724466368512', '78', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410413288487108608', '79', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410413521736531968', '81', '1.90', '0.00', '1.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410413753262129152', '95', '804.85', '0.00', '804.85', '1', '804.85', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410413792738914304', '84', '0.70', '0.00', '0.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410413892542373888', '82', '111.96', '0.00', '111.96', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410414077704114176', '86', '64.34', '0.00', '64.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410415216956772352', '85', '611.13', '0.00', '611.13', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410415878746574848', '88', '98.34', '0.00', '98.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410415950532055040', '87', '440.67', '0.00', '440.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410416313632972800', '91', '0.50', '0.00', '0.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410416651609985024', '93', '199.00', '0.00', '199.00', '1', '199.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410416912940306432', '94', '74.33', '0.00', '74.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410418367843663872', '97', '98.10', '0.00', '98.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410419148231708672', '98', '8.83', '0.00', '8.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410420744051191808', '99', '85.71', '0.00', '85.71', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410422457944391680', '101', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410422834232164352', '100', '535.84', '0.00', '535.84', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410423335854252032', '103', '804.85', '0.00', '804.85', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410423374273990656', '102', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410423732845137920', '105', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410424188774346752', '104', '22.91', '0.00', '22.91', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410425015115149312', '106', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410425216760426496', '107', '3.78', '0.00', '3.78', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410426571474571264', '108', '32.00', '0.00', '32.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410427275861688320', '110', '110.58', '0.00', '110.58', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410427285839974400', '109', '134.17', '0.00', '134.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410427559484755968', '112', '3.20', '0.00', '3.20', '1', '3.20', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410427932979113984', '111', '148.00', '0.00', '148.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410428303222910976', '114', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410429316172546048', '113', '248.61', '0.00', '248.61', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410429823318429696', '115', '17.31', '0.00', '17.31', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410430238386786304', '116', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410430299002855424', '117', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410430580780347392', '118', '564.67', '0.00', '564.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410430777530986496', '122', '25.00', '0.00', '25.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410431703465549824', '121', '142.01', '0.00', '142.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410433058586402816', '124', '3.20', '0.00', '3.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410433357015355392', '123', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410434313694175232', '131', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410434322669940736', '125', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410435090126913536', '126', '167.00', '0.00', '167.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410435927062532096', '128', '55.34', '0.00', '55.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410436990599626752', '130', '1298.50', '0.00', '1298.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410437214327984128', '129', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410437547074691072', '132', '396.00', '0.00', '396.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410438655365038080', '133', '81.20', '0.00', '81.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410439378484015104', '134', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410439871998414848', '135', '66.75', '0.00', '66.75', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410439876234645504', '136', '8.00', '0.00', '8.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410440238807080960', '137', '173.00', '0.00', '173.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410440736956194816', '140', '9.00', '0.00', '9.00', '1', '9.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410440970436280320', '138', '14.51', '0.00', '14.51', '1', '14.51', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410442472592678912', '142', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410442496378609664', '143', '1066.32', '0.00', '1066.32', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410442563827191808', '141', '83.34', '0.00', '83.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410442756178001920', '144', '1399.00', '0.00', '1399.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410444882543357952', '145', '9.90', '0.00', '9.90', '1', '9.90', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410445542127013888', '146', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410446000048529408', '149', '79.61', '0.00', '79.61', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410446206047539200', '147', '374.13', '0.00', '374.13', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410447112264699904', '150', '2156.38', '0.00', '2156.38', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410447324118990848', '151', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410447749526278144', '153', '6.00', '0.00', '6.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410448451241721856', '156', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410448999755993088', '155', '398.00', '0.00', '398.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410449822741368832', '159', '15.00', '0.00', '15.00', '1', '15.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410449999606800384', '157', '25.00', '0.00', '25.00', '1', '25.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410450355271213056', '158', '239.00', '0.00', '239.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410450633152221184', '160', '598.00', '0.00', '598.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410450965810880512', '161', '0.29', '0.00', '0.29', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410452009395625984', '162', '25.00', '0.00', '25.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410453058793684992', '163', '48.20', '0.00', '48.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410453988574449664', '164', '1031.66', '0.00', '1031.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410455299273490432', '165', '2.24', '0.00', '2.24', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410455438356570112', '168', '63.50', '0.00', '63.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410455719748218880', '167', '14.51', '0.00', '14.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410455962090958848', '169', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410457466638094336', '171', '296.68', '0.00', '296.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410459277881204736', '172', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410459653799874560', '173', '7.60', '0.00', '7.60', '1', '7.60', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410461406725353472', '175', '1121.51', '0.00', '1121.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410462059782643712', '176', '399.00', '0.00', '399.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:43', 'SYS', '2021-09-01 17:54:43', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410463476111085568', '177', '2.60', '0.00', '2.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410464322681020416', '178', '22.30', '0.00', '22.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410465631450664960', '180', '111.10', '0.00', '111.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410467201466716160', '183', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410467521307566080', '184', '232.92', '0.00', '232.92', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410468487310307328', '185', '0.40', '0.08', '0.40', '1', '0.32', '2', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410469020565704704', '188', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410469735929454592', '186', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410469829152026624', '187', '116.45', '0.00', '116.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410474040946237440', '190', '499.00', '0.00', '499.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410474085384912896', '192', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410475957025959936', '193', '7.10', '0.00', '7.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410477412185223168', '194', '26.80', '0.00', '26.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410477609011343360', '195', '64.83', '0.00', '64.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410478731058966528', '198', '999.00', '0.00', '999.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410478741364346880', '196', '18.80', '0.00', '18.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410479666007060480', '200', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410479799964745728', '197', '47.33', '0.00', '47.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410479899357175808', '199', '29.68', '0.00', '29.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410480356842508288', '201', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410481866393477120', '202', '205.66', '0.00', '205.66', '1', '205.66', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410482201291829248', '203', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410482649948205056', '204', '277.67', '0.00', '277.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410483599018508288', '205', '7.55', '0.00', '7.55', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410485103691501568', '206', '241.03', '0.00', '241.03', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410485376103170048', '207', '244.61', '0.00', '244.61', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410486574285778944', '208', '13.60', '0.00', '13.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410486967283691520', '209', '2.89', '0.00', '2.89', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410487834539958272', '210', '7.00', '0.00', '7.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410487987887861760', '211', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410488092284104704', '212', '1.30', '0.00', '1.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410488356714004480', '213', '2.80', '0.00', '2.80', '1', '2.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410489178558504960', '216', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410489522176851968', '217', '278.90', '0.00', '278.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410489819506880512', '214', '92.54', '0.00', '92.54', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410489967226097664', '215', '1.30', '0.00', '1.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410490545436008448', '219', '509.09', '0.00', '509.09', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410490589077811200', '220', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410490858607964160', '221', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410490893819142144', '222', '214.83', '0.00', '214.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410491539687432192', '224', '90.44', '0.00', '90.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410491683635912704', '223', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410492116739727360', '225', '6099.00', '0.00', '6099.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410492415411949568', '226', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410492494952759296', '227', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410492847777566720', '228', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410493255128387584', '229', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410493483659243520', '230', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410493767949180928', '233', '6.70', '0.00', '6.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410493768788000768', '231', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410493819060973568', '232', '245.27', '0.00', '245.27', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410494025437478912', '234', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410494100632956928', '235', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410494357601173504', '238', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410494469316472832', '237', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410494869826408448', '239', '22.30', '0.00', '22.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410495035732054016', '240', '19.37', '0.00', '19.37', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410495075380846592', '241', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410495154527375360', '243', '171.50', '0.00', '171.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410495184655065088', '245', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410495201528750080', '244', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410495318189056000', '246', '6.37', '0.00', '6.37', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410495825330810880', '247', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410495964149628928', '249', '31.67', '0.00', '31.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410495985729331200', '248', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410496364193972224', '250', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410496381755551744', '251', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410496794277945344', '252', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410496959634145280', '253', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410497344985837568', '255', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410497346197983232', '254', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410497591170478080', '257', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410497787908546560', '256', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410497987314151424', '263', '97.10', '0.00', '97.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410498283327168512', '258', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410498333822386176', '259', '908.27', '0.00', '908.27', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410498713264304128', '260', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410498962066153472', '261', '197.00', '0.00', '197.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410499021512060928', '262', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410499168207810560', '264', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410499699764592640', '265', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410499918350729216', '266', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410499967612829696', '267', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410500229610016768', '268', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410500609605574656', '269', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410500645504602112', '270', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410500780162768896', '271', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410501076893011968', '272', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410501569677549568', '273', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410501694588100608', '274', '148.00', '0.00', '148.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410502070510985216', '275', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410502614122205184', '277', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410503114594897920', '276', '215.67', '0.00', '215.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410503286775296000', '278', '1.90', '0.00', '1.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410503441805152256', '281', '10.35', '0.00', '10.35', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410503762329694208', '279', '99.00', '0.00', '99.00', '1', '99.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410503840041725952', '283', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410503948833587200', '280', '214.00', '0.00', '214.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410504719364968448', '282', '71.31', '0.00', '71.31', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410505348225392640', '286', '67.32', '0.00', '67.32', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410505495827099648', '284', '333.47', '0.00', '333.47', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410505612076425216', '285', '180.50', '0.00', '180.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410513581598015488', '289', '134.50', '0.00', '134.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410513728419586048', '291', '55.48', '0.00', '55.48', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410514048075878400', '290', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410514262572634112', '292', '38.00', '0.00', '38.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410514581213872128', '293', '5.83', '0.00', '5.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410515454858022912', '294', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410515492044738560', '295', '86.66', '0.00', '86.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410516567770460160', '302', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410517306949427200', '297', '3.60', '0.00', '3.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410517581441490944', '298', '1.10', '0.00', '1.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410518558731059200', '299', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410518774267994112', '300', '3.90', '0.00', '3.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410519613699186688', '301', '215.67', '0.00', '215.67', '1', '215.67', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:44', 'SYS', '2021-09-01 17:54:44', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410520833499287552', '303', '149.00', '0.00', '149.00', '1', '149.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410521310622351360', '304', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410521362245853184', '305', '10.34', '0.00', '10.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410521866082361344', '306', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410521997099851776', '308', '83.28', '0.00', '83.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410522048266211328', '307', '6.90', '0.00', '6.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410523412992032768', '309', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410523685672140800', '310', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410524132382261248', '311', '33.00', '0.00', '33.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410524272723693568', '313', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410524327799099392', '312', '4.80', '0.00', '4.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410524739570696192', '314', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410525073303105536', '315', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410525550874914816', '316', '27.90', '0.00', '27.90', '1', '27.90', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410525844270657536', '319', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410526175314493440', '320', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410526258164629504', '317', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410526539128455168', '318', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410527097180598272', '321', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410527249509347328', '322', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410527643186679808', '323', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410527933747134464', '324', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410528213192581120', '325', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410528270784638976', '327', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410528508802981888', '326', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410529355062493184', '329', '5.00', '0.00', '5.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410529739042672640', '328', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410530299842072576', '331', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410530776105291776', '332', '22.34', '0.00', '22.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410530931680387072', '333', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410531110236147712', '334', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410531157107490816', '336', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410531293531422720', '335', '22.30', '0.00', '22.30', '1', '22.30', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410531790568992768', '337', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410531817056034816', '338', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410532047562444800', '339', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410532651194048512', '340', '6.60', '0.00', '6.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410533913838944256', '341', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410534284837724160', '344', '499.00', '0.00', '499.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410534739458310144', '345', '23.98', '0.00', '23.98', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410535482378649600', '346', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410535536162193408', '347', '59.00', '0.00', '59.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410535776613261312', '348', '51.50', '0.00', '51.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410535997246226432', '349', '265.15', '0.00', '265.15', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410536916100816896', '352', '38.86', '0.00', '38.86', '1', '38.86', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410536923050733568', '351', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410537280162189312', '353', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410537335774453760', '354', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410537386307420160', '356', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410537559418966016', '355', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410538122982375424', '357', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410538152845869056', '358', '34.20', '0.00', '34.20', '1', '34.20', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410538232541839360', '360', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410538264699564032', '359', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410538376045707264', '361', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410538669902831616', '362', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410539022719348736', '363', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410540855688908800', '364', '0.03', '0.00', '0.03', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410540987004133376', '365', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410541520741920768', '373', '143.80', '0.00', '143.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410541631580643328', '369', '98.33', '0.00', '98.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410542271656546304', '367', '2.49', '0.00', '2.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410542348395560960', '368', '198.00', '0.00', '198.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410543501539741696', '380', '15.00', '0.00', '15.00', '1', '15.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410543554736128000', '371', '7.20', '0.00', '7.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410543596482035712', '370', '365.66', '0.00', '365.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410545198014087168', '374', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410545625585598464', '375', '753.98', '0.00', '753.98', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410547224248819712', '376', '17.00', '0.00', '17.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410547762424152064', '378', '20.00', '12.18', '20.00', '1', '7.82', '2', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410548276813574144', '379', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410548763554156544', '381', '0.01', '0.00', '0.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410549002012962816', '382', '0.93', '0.00', '0.93', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410549602758914048', '383', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410550378105372672', '384', '11.30', '0.00', '11.30', '1', '11.30', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410551219549827072', '385', '77.83', '0.00', '77.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410551345991331840', '387', '242.60', '0.00', '242.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410551826042003456', '386', '543.21', '0.00', '543.21', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410553161898475520', '393', '15.00', '0.00', '15.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410553228487241728', '389', '2.40', '0.00', '2.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410555045602267136', '391', '30.00', '0.00', '30.00', '1', '30.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410557111775182848', '392', '34.10', '0.00', '34.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410557607931981824', '394', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410558152725897216', '396', '31.12', '0.00', '31.12', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410558421698236416', '395', '4.01', '0.00', '4.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410558917561483264', '397', '15.00', '0.00', '15.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410559077284761600', '398', '1499.00', '0.00', '1499.00', '1', '1499.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410561579732353024', '399', '493.08', '0.00', '493.08', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410562194176925696', '400', '31.00', '0.00', '31.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410562376532664320', '401', '183.13', '0.00', '183.13', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410562446569144320', '403', '6.75', '0.00', '6.75', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410562633974820864', '402', '61.30', '0.00', '61.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410563754659344384', '404', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410567344308260864', '405', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410567945431687168', '406', '96.66', '0.00', '96.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410568051795050496', '407', '33.00', '0.00', '33.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410569468706467840', '409', '30.00', '0.00', '30.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410570930912104448', '410', '0.15', '0.00', '0.15', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410573776055324672', '412', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410574564135665664', '414', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410575837929033728', '413', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410576787653718016', '416', '15.00', '0.00', '15.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410577251791151104', '415', '297.00', '0.00', '297.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410579239815790592', '417', '82.97', '0.00', '82.97', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410581820529111040', '418', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410582019049709568', '419', '172.30', '0.00', '172.30', '1', '172.30', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410584325413539840', '420', '2.90', '0.00', '2.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410584899924197376', '421', '80.10', '0.00', '80.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410585870192492544', '423', '929.00', '0.00', '929.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410585966795726848', '422', '449.00', '0.00', '449.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410586768692109312', '424', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410587352954437632', '425', '199.98', '0.00', '199.98', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410587616860045312', '426', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410588246542536704', '427', '107.19', '0.00', '107.19', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410592158414684160', '428', '211.25', '0.00', '211.25', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410592833571799040', '433', '299.00', '100.00', '299.00', '1', '199.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410593731014475776', '429', '465.13', '0.00', '465.13', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410594057230647296', '430', '11.30', '0.00', '11.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410594080534233088', '431', '7.00', '0.00', '7.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410595198165213184', '432', '6.40', '0.00', '6.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410597131223465984', '434', '86.31', '0.00', '86.31', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410598285655306240', '435', '30.00', '0.00', '30.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410598781891817472', '438', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410599004135415808', '436', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410599857902755840', '437', '10.10', '0.00', '10.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410603706679963648', '439', '0.50', '0.00', '0.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410604946914725888', '440', '0.50', '0.00', '0.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410605775264546816', '441', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410605954596265984', '444', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410606108556582912', '442', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410606418754674688', '443', '3.90', '0.00', '3.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410608844106784768', '446', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410609173762281472', '447', '19.90', '0.00', '19.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410612575544172544', '448', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410613625588170752', '449', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410616392536977408', '451', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410618941436518400', '452', '89.67', '0.00', '89.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410621179810734080', '454', '28.50', '0.00', '28.50', '1', '28.50', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410626244378271744', '455', '197.00', '0.00', '197.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410630972516466688', '456', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410633480823521280', '457', '1637.04', '0.00', '1637.04', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410634509027807232', '458', '1.80', '0.00', '1.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410640641930747904', '459', '0.70', '0.00', '0.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:45', 'SYS', '2021-09-01 17:54:45', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410647405459820544', '460', '16.80', '0.00', '16.80', '1', '16.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410659751225901056', '461', '16.70', '0.00', '16.70', '1', '16.70', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410660672970342400', '462', '32.00', '0.00', '32.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410665549540765696', '465', '33.70', '0.00', '33.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410666795693645824', '466', '91.00', '0.00', '91.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410671838371147776', '468', '2.68', '0.00', '2.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410675377449369600', '469', '44.80', '0.00', '44.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410683145518465024', '470', '25.30', '0.00', '25.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410699893307236352', '472', '499.00', '0.00', '499.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410710954957762560', '473', '529.62', '0.00', '529.62', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410714007245070336', '474', '5.50', '0.00', '5.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410715731741528064', '475', '3.80', '0.00', '3.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410724848556228608', '476', '1199.01', '0.00', '1199.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410731487942328320', '477', '0.23', '0.00', '0.23', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410733816779259904', '478', '399.00', '0.00', '399.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410746166416691200', '479', '0.34', '0.00', '0.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410746752356741120', '480', '299.00', '0.00', '299.00', '1', '299.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410750604275539968', '481', '4.00', '0.00', '4.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410752895619616768', '482', '1.00', '0.00', '1.00', '1', '1.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410766919925166080', '484', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410767965930033152', '485', '3.00', '0.00', '3.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410769079022817280', '487', '11.60', '0.00', '11.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410769159456952320', '486', '110.67', '0.00', '110.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410770783403384832', '488', '10.83', '0.00', '10.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410771215295107072', '489', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410772654943764480', '490', '287.80', '0.00', '287.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410772971571810304', '491', '524.40', '0.00', '524.40', '1', '524.40', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410773671282466816', '493', '2.30', '0.00', '2.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410776031035551744', '496', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410776238309666816', '495', '53.00', '0.00', '53.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410776810223976448', '497', '200.93', '0.00', '200.93', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410779403994189824', '498', '517.66', '0.00', '517.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410779936368779264', '501', '40.50', '0.00', '40.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410780373746638848', '499', '248.00', '0.00', '248.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410781146752622592', '500', '2.80', '0.00', '2.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410784163824586752', '502', '198.00', '0.00', '198.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410784279872577536', '503', '2299.00', '0.00', '2299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410784400177770496', '504', '198.00', '0.00', '198.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410784718718402560', '505', '50.29', '0.00', '50.29', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410785220927578112', '510', '168.00', '0.00', '168.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410785956293967872', '507', '25.00', '0.00', '25.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410786474588241920', '508', '7.10', '0.00', '7.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410787015838031872', '509', '3865.00', '0.00', '3865.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410787466503409664', '511', '61.95', '0.00', '61.95', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410787683172761600', '512', '396.34', '0.00', '396.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410790578588876800', '514', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410791628825882624', '515', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410793028309884928', '516', '3.80', '0.00', '3.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410793477725372416', '518', '35.54', '0.00', '35.54', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410793923668008960', '519', '398.00', '0.00', '398.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410795512084484096', '521', '25.17', '0.00', '25.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410796082388189184', '522', '30.67', '0.00', '30.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410797265244807168', '523', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410797461680861184', '525', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410797640442068992', '524', '46.33', '0.00', '46.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410798124481556480', '527', '77.33', '0.00', '77.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410799538398167040', '528', '5.00', '0.00', '5.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410800414735126528', '533', '244.63', '0.00', '244.63', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410801342871674880', '529', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410803144950173696', '531', '14.10', '0.00', '14.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410803279801286656', '530', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410803321240989696', '537', '30.00', '0.00', '30.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410803844576878592', '540', '30.00', '0.00', '30.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410804962828668928', '535', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410805109725745152', '536', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410805585993166848', '538', '276.50', '0.00', '276.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410805676447526912', '539', '5.00', '0.00', '5.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410806877490696192', '542', '35.98', '0.00', '35.98', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410806930062082048', '541', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410807555558658048', '543', '965.65', '0.00', '965.65', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410807766913818624', '544', '34.10', '0.00', '34.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410808257324412928', '550', '198.00', '0.00', '198.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410808626083414016', '545', '299.00', '0.00', '299.00', '1', '299.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410809042040938496', '547', '548.06', '0.00', '548.06', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410809236719591424', '546', '13.10', '0.00', '13.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410809951814811648', '549', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410810172162572288', '548', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410810542838415360', '551', '13.10', '0.00', '13.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410811532660629504', '552', '1.50', '0.00', '1.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410811778132246528', '553', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410813205529423872', '560', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410813582106562560', '554', '2.30', '0.00', '2.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410813954762137600', '557', '86.83', '0.00', '86.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410814083653099520', '555', '30.00', '0.00', '30.00', '1', '30.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410814408153780224', '556', '78.41', '0.00', '78.41', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410815964341272576', '563', '1199.00', '0.00', '1199.00', '1', '1199.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410817265141727232', '558', '196.17', '0.00', '196.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410818529384624128', '559', '4.00', '0.00', '4.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410819417054560256', '561', '299.00', '0.00', '299.00', '1', '299.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410820171601444864', '562', '296.00', '0.00', '296.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410821237554425856', '564', '19.40', '0.00', '19.40', '1', '19.40', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410821750282932224', '566', '89.00', '0.00', '89.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410821815114305536', '565', '22.30', '0.00', '22.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410822975766319104', '568', '929.00', '0.00', '929.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410823430764404736', '569', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410823932268957696', '570', '498.34', '0.00', '498.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410824360805150720', '571', '1199.00', '0.00', '1199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410826195326603264', '572', '1.90', '0.00', '1.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410827211862355968', '574', '499.00', '0.00', '499.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410827386760646656', '573', '10.65', '0.00', '10.65', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410827539257143296', '575', '15.60', '0.00', '15.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410828545806233600', '576', '131.66', '0.00', '131.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410828664404328448', '577', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410829951107735552', '578', '540.00', '0.00', '540.00', '1', '540.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410830095484116992', '579', '90.00', '0.00', '90.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410830187536457728', '580', '332.33', '0.00', '332.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410830495440314368', '581', '5.00', '0.00', '5.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410830713032466432', '582', '6.20', '0.00', '6.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410830928791609344', '583', '14.66', '0.00', '14.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410831195683553280', '585', '58.00', '0.00', '58.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410831722647552000', '584', '17.30', '0.00', '17.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410833081019056128', '587', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410833679818846208', '592', '50.67', '0.00', '50.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410833785880231936', '589', '3.60', '0.00', '3.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410833797657849856', '588', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410835546862944256', '590', '1.30', '0.00', '1.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410839108879810560', '593', '540.00', '0.00', '540.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410839455081889792', '594', '65.00', '0.00', '65.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:46', 'SYS', '2021-09-01 17:54:46', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410839599269478400', '596', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410839734779080704', '595', '688.00', '0.00', '688.00', '1', '688.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410840429972406272', '601', '15.00', '0.00', '15.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410840449643626496', '597', '6.80', '0.00', '6.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410840766389088256', '600', '49.69', '0.00', '49.69', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410840917790904320', '599', '3.50', '0.00', '3.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410840925260992512', '598', '35.00', '0.00', '35.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410842867496345600', '604', '499.00', '0.00', '499.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410843022018695168', '603', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410843162838224896', '602', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410845674496458752', '605', '40.00', '0.00', '40.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410845811511906304', '606', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410846384533504000', '607', '46.00', '0.00', '46.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410846685034315776', '608', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410847059342516224', '610', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410847192985509888', '609', '12.00', '0.00', '12.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410848035684212736', '611', '662.40', '0.00', '662.40', '1', '662.40', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410848232065691648', '621', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410848401540767744', '613', '598.00', '0.00', '598.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410848716952428544', '612', '449.60', '0.00', '449.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410848938927562752', '614', '1.60', '0.00', '1.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410849819328647168', '615', '1.65', '0.00', '1.65', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410850288503492608', '617', '429.33', '0.00', '429.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410850782433230848', '618', '542.60', '0.00', '542.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410851067356409856', '622', '17.00', '0.00', '17.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410851564503150592', '619', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410853194074038272', '620', '662.40', '0.00', '662.40', '1', '662.40', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410855777165611008', '623', '28.50', '0.00', '28.50', '1', '28.50', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410855906048086016', '624', '398.00', '0.00', '398.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410857268781670400', '626', '65.00', '0.00', '65.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410858019436343296', '625', '966.28', '0.00', '966.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410858252329185280', '627', '30.00', '0.00', '30.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410858877750308864', '629', '97.00', '0.00', '97.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410859018016247808', '628', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410860369135673344', '630', '4.10', '0.00', '4.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410861620137177088', '633', '80.66', '0.00', '80.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410862142550319104', '635', '255.14', '0.00', '255.14', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410862243482132480', '634', '198.80', '0.00', '198.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410862349979635712', '636', '30.00', '0.00', '30.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410862506519441408', '637', '45.04', '0.00', '45.04', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410863322429100032', '638', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410864487090753536', '640', '9.00', '0.00', '9.00', '1', '9.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410865534999977984', '646', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410867332473135104', '641', '6.60', '0.00', '6.60', '1', '6.60', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410867354656796672', '642', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410868521163968512', '644', '12.20', '0.00', '12.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410868818372329472', '643', '2.70', '0.00', '2.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410869461178785792', '645', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410870225808789504', '647', '1.70', '0.00', '1.70', '1', '1.70', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410870835471937536', '648', '1.83', '0.00', '1.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410872657091645440', '649', '108.82', '0.00', '108.82', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410873643772399616', '651', '75.00', '0.00', '75.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410873856964575232', '650', '3.60', '0.00', '3.60', '1', '3.60', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410874362923474944', '652', '270.31', '0.00', '270.31', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410877582915887104', '653', '5.50', '0.00', '5.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410877620148756480', '654', '7.20', '0.00', '7.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410878791894687744', '655', '97.55', '0.00', '97.55', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410880013334622208', '657', '46.70', '0.00', '46.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410880693449510912', '658', '0.52', '0.00', '0.52', '1', '0.52', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410881403259858944', '659', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410883294689632256', '660', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410885354545885184', '662', '632.35', '0.00', '632.35', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410887152333623296', '663', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410887242351882240', '670', '99.00', '0.00', '99.00', '1', '99.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410887403689885696', '664', '10.40', '0.00', '10.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410887539585417216', '666', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410887610842357760', '665', '51.50', '0.00', '51.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410887979270037504', '668', '10.01', '0.00', '10.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410888019908624384', '667', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410888112514781184', '671', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410890231095377920', '672', '30.00', '0.00', '30.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410890720633577472', '673', '280.00', '0.00', '280.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410891694450368512', '674', '12.21', '0.00', '12.21', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410892570392924160', '675', '131.67', '0.00', '131.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410893616238448640', '677', '130.67', '0.00', '130.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410893643077885952', '685', '148.00', '0.00', '148.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410893701299019776', '681', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410894678974513152', '680', '7.80', '0.00', '7.80', '1', '7.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410894777486028800', '678', '198.33', '0.00', '198.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410895057682411520', '679', '100.00', '0.00', '100.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410896106577186816', '682', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410896309363277824', '683', '688.00', '0.00', '688.00', '1', '688.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410896528540831744', '684', '0.52', '0.00', '0.52', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410899237457260544', '686', '43.79', '0.00', '43.79', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410901660733247488', '687', '2.82', '0.00', '2.82', '1', '2.82', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410903592839282688', '688', '254.60', '0.00', '254.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410905056496304128', '689', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410905710786670592', '691', '3.20', '0.00', '3.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410906585856868352', '690', '81.70', '33.03', '81.70', '1', '48.67', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410907763344887808', '692', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410908084649582592', '695', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410908906359848960', '693', '3.66', '0.00', '3.66', '1', '3.66', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410909577645641728', '694', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410910318263242752', '703', '14.00', '0.00', '14.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410910432620838912', '696', '22.91', '0.00', '22.91', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410911007978713088', '697', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410911183162191872', '698', '28.50', '0.00', '28.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410911981585809408', '699', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410912489989885952', '700', '2.80', '0.00', '2.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410912908912869376', '704', '569.06', '0.00', '569.06', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410912992685682688', '701', '2.82', '0.00', '2.82', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410913381069844480', '702', '1.50', '0.00', '1.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410915746783043584', '706', '15.00', '0.00', '15.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410916690463686656', '708', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410917018345033728', '710', '17.80', '0.00', '17.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410917057993773056', '709', '22.00', '0.00', '22.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410918687657037824', '711', '99.00', '0.00', '99.00', '1', '99.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410920374841085952', '712', '431.60', '0.00', '431.60', '1', '431.60', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410922152030507008', '714', '11.60', '0.00', '11.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410922854538686464', '716', '196.00', '0.00', '196.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410923838899986432', '715', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410925382055723008', '717', '12.70', '0.00', '12.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410928589452505088', '720', '298.00', '0.00', '298.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410928720793026560', '719', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410929185932951552', '721', '22.73', '0.00', '22.73', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410933940499496960', '722', '23.10', '0.00', '23.10', '1', '23.10', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410938392497315840', '723', '24.00', '0.00', '24.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410939369438793728', '724', '227.00', '0.00', '227.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410942262678089728', '725', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410942705529397248', '726', '3.40', '0.00', '3.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410947272052813824', '727', '479.00', '0.00', '479.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410948033419636736', '728', '378.00', '0.00', '378.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410950230567956480', '729', '29.00', '0.00', '29.00', '1', '29.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410951870230540288', '730', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410952440534224896', '731', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410952585489408000', '732', '128.90', '0.00', '128.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410952896593420288', '733', '297.00', '0.00', '297.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410954601838022656', '734', '255.01', '0.00', '255.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410955417701564416', '736', '172.30', '0.00', '172.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410955475855491072', '735', '31.06', '0.00', '31.06', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410955632978386944', '737', '1.10', '0.00', '1.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410959746982449152', '739', '6.00', '0.00', '6.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410965542063439872', '740', '70.00', '0.00', '70.00', '1', '70.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410967194732552192', '741', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410972478955728896', '742', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410973256680353792', '743', '19.82', '0.00', '19.82', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410974340949958656', '745', '1.70', '0.00', '1.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410975576470282240', '747', '0.44', '0.00', '0.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410976891720048640', '748', '4.40', '0.00', '4.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410977528272887808', '750', '5.86', '0.00', '5.86', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:47', 'SYS', '2021-09-01 17:54:47', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410987950229147648', '752', '12.50', '0.00', '12.50', '1', '12.50', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410988355394711552', '753', '45.88', '0.00', '45.88', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410988998343745536', '754', '56.52', '0.00', '56.52', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410989134146945024', '755', '1.40', '0.00', '1.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410990633841311744', '756', '498.50', '0.00', '498.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410992507537485824', '758', '0.02', '0.00', '0.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410993069146472448', '759', '0.90', '0.00', '0.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410993834502119424', '761', '2.60', '0.00', '2.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410995330807451648', '762', '5.50', '0.00', '5.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410997546435981312', '763', '2.40', '0.00', '2.40', '1', '2.40', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410997933381386240', '764', '3.00', '0.00', '3.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1410998487574892544', '765', '17.40', '0.00', '17.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411000258007293952', '767', '131.67', '0.00', '131.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411001809270718464', '768', '38.72', '0.00', '38.72', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411008068678025216', '770', '14.30', '0.00', '14.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411017210931077120', '772', '1.60', '0.00', '1.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411018472342925312', '773', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411022440670302208', '775', '16.40', '0.00', '16.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411023021132701696', '776', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411033588526473216', '778', '1.20', '0.00', '1.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411041223938039808', '779', '22.70', '0.00', '22.70', '1', '22.70', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411042575049252864', '780', '77.70', '0.00', '77.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411045440534859776', '781', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411047302310797312', '782', '10.90', '9.44', '10.90', '1', '1.46', '3', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411052492271276032', '783', '12.80', '0.00', '12.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411065652449521664', '784', '4.80', '2.46', '4.80', '1', '2.34', '3', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411083552149364736', '785', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411083811114143744', '786', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411086085064482816', '787', '18.30', '0.00', '18.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411093652989788160', '788', '11.20', '0.00', '11.20', '1', '11.20', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411098665459884032', '790', '123.17', '0.00', '123.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411102869289062400', '791', '22.90', '0.00', '22.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411104968915791872', '792', '3299.00', '0.00', '3299.00', '1', '3299.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411105417861427200', '793', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411117026445074432', '794', '22.00', '0.00', '22.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411119841036959744', '795', '2.20', '0.00', '2.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411126764360671232', '797', '2.90', '0.00', '2.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411127156553175040', '798', '0.90', '0.00', '0.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411127392252157952', '799', '110.99', '0.00', '110.99', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411128259558760448', '800', '331.67', '0.00', '331.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411130499048660992', '801', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411130681622401024', '802', '80.50', '0.00', '80.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411132321058410496', '803', '479.00', '0.00', '479.00', '1', '479.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411132660172156928', '812', '1143.18', '0.00', '1143.18', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411134445490147328', '805', '225.50', '0.00', '225.50', '1', '225.50', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411134468756049920', '804', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411136158834081792', '806', '479.00', '0.00', '479.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411136194615676928', '807', '9.60', '0.00', '9.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411136197627109376', '808', '21.60', '0.00', '21.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411138092005457920', '810', '356.50', '0.00', '356.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411139103092789248', '811', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411139665419018240', '813', '55.20', '0.00', '55.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411140075072503808', '814', '2.20', '0.00', '2.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411143579296038912', '822', '178.00', '0.00', '178.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411143908699811840', '818', '758.00', '0.00', '758.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411144914410106880', '819', '431.60', '0.00', '431.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411144973319135232', '820', '99.00', '0.00', '99.00', '1', '99.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411145143611949056', '821', '28.50', '0.00', '28.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411145152537436160', '823', '49.17', '0.00', '49.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411146940581810176', '825', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411148206628290560', '826', '184.99', '0.00', '184.99', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411148930179334144', '827', '5.30', '0.00', '5.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411149010521206784', '828', '499.00', '0.00', '499.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411150354137165824', '829', '61.25', '0.00', '61.25', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411151740472066048', '830', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411152142529671168', '833', '27.50', '0.00', '27.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411152225258106880', '837', '298.00', '0.00', '298.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411152949970935808', '834', '18.00', '0.00', '18.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411153313281564672', '835', '28.99', '0.00', '28.99', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411154035121283072', '836', '5.67', '0.00', '5.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411156129924472832', '840', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411156935516073984', '841', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411157279839010816', '843', '32.64', '0.00', '32.64', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411158644694900736', '842', '51.20', '0.00', '51.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411160492529065984', '845', '68.90', '0.00', '68.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411161258450976768', '847', '247.50', '0.00', '247.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411161292114472960', '848', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411161364306771968', '846', '10.02', '0.00', '10.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411162956191944704', '849', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411164119343767552', '850', '75.59', '0.00', '75.59', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411164172347154432', '851', '2.70', '0.00', '2.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411164417118388224', '852', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411164610878443520', '853', '448.66', '0.00', '448.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411166330425655296', '854', '36.75', '0.00', '36.75', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411166920467763200', '855', '429.89', '0.00', '429.89', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411167857760448512', '856', '19.10', '0.00', '19.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411167877217845248', '857', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411169028009017344', '858', '64.86', '0.00', '64.86', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411169796703363072', '859', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411170821866737664', '860', '30.34', '0.00', '30.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411171444213374976', '861', '12.67', '0.00', '12.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411171450039222272', '862', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411173046072606720', '863', '15.20', '0.00', '15.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411173073494921216', '867', '100.00', '0.00', '100.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411174319320674304', '865', '5.40', '0.00', '5.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411174411381420032', '866', '26.30', '0.00', '26.30', '1', '26.30', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411174955646930944', '868', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411176761064079360', '870', '479.00', '0.00', '479.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411176842924306432', '869', '0.70', '0.00', '0.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411176972717060096', '871', '79.00', '0.00', '79.00', '1', '79.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411180621425975296', '874', '28.00', '0.00', '28.00', '1', '28.00', '2', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411181034900463616', '876', '2279.00', '0.00', '2279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411182418836303872', '880', '79.81', '0.00', '79.81', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411183238206152704', '878', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411183740767662080', '879', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411185454212157440', '881', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:48', 'SYS', '2021-09-01 17:54:48', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411187556888002560', '884', '32.56', '0.00', '32.56', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411189042334339072', '885', '75.34', '0.00', '75.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411189378470027264', '886', '115.63', '0.00', '115.63', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411189881618771968', '887', '265.00', '0.00', '265.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411190270866972672', '888', '3.80', '0.00', '3.80', '1', '3.80', '2', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411190823244234752', '889', '1099.00', '0.00', '1099.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411191341492436992', '891', '2.33', '0.00', '2.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411191352473137152', '890', '294.40', '0.00', '294.40', '1', '294.40', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411191743461912576', '892', '35.20', '0.00', '35.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411192341162848256', '894', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411192605953433600', '896', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411193666676150272', '895', '3.80', '0.00', '3.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411194188703399936', '901', '198.00', '0.00', '198.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411194822966091776', '897', '2.88', '0.00', '2.88', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411195085588176896', '900', '79.00', '0.00', '79.00', '1', '79.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411196687392923648', '899', '18.50', '0.00', '18.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411198561605099520', '902', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411201800736002048', '908', '4.00', '0.00', '4.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411203647429390336', '905', '88.34', '0.00', '88.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411205192678068224', '909', '33.60', '0.00', '33.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411205697525489664', '906', '165.67', '0.00', '165.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411206175122468864', '907', '28.50', '0.00', '28.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411207528355934208', '911', '64.24', '0.00', '64.24', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411210244184543232', '913', '4.79', '0.00', '4.79', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411212054970437632', '915', '279.00', '0.00', '279.00', '1', '279.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411212116874162176', '925', '528.00', '0.00', '528.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411212344478064640', '917', '999.00', '0.00', '999.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411212457774592000', '916', '33.90', '0.00', '33.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411212528058576896', '923', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411212639203414016', '919', '20.70', '0.00', '20.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411212908289003520', '920', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411213155459317760', '921', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411214849752674304', '922', '99.03', '0.00', '99.03', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411215220071936000', '924', '118.25', '0.00', '118.25', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411217127830155264', '926', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411217983518482432', '927', '8.40', '0.00', '8.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411218846693646336', '928', '1.30', '0.00', '1.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411219687701975040', '929', '34.25', '0.00', '34.25', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411220087826001920', '930', '2.60', '0.00', '2.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411220367477010432', '932', '11.90', '0.00', '11.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411220481058762752', '938', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411220733924929536', '933', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411220876388659200', '934', '398.00', '0.00', '398.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411221679870533632', '936', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411223255297245184', '937', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411223461124337664', '939', '24.50', '0.00', '24.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411224870959910912', '942', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411225247558074368', '940', '4.60', '0.00', '4.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411225761062522880', '944', '148.99', '0.00', '148.99', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411225827907174400', '943', '12.20', '0.00', '12.20', '1', '12.20', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411226467462991872', '945', '2.50', '0.00', '2.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411229119974445056', '946', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411229440817725440', '949', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411229729993977856', '947', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411229907798908928', '948', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411230392098435072', '952', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411232480807276544', '950', '0.24', '0.00', '0.24', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411232753269284864', '954', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411232797514989568', '951', '6.40', '0.00', '6.40', '1', '6.40', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411233516385157120', '955', '99.00', '0.00', '99.00', '1', '99.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411233716335988736', '953', '1.60', '0.00', '1.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411236055096733696', '957', '7.80', '0.00', '7.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411238342351355904', '958', '37.00', '0.00', '37.00', '1', '37.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411239553418866688', '960', '17.50', '0.00', '17.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411241692669087744', '961', '28.10', '0.00', '28.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411242117363310592', '962', '399.00', '0.00', '399.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411242832160808960', '963', '15.20', '0.00', '15.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411244901244571648', '964', '199.00', '0.00', '199.00', '1', '199.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411245728315170816', '965', '8.00', '0.00', '8.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411247195671453696', '966', '228.35', '0.00', '228.35', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411249427469004800', '968', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411251135058194432', '970', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411252970905100288', '971', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411255551144476672', '972', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411256124249980928', '973', '197.34', '0.00', '197.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411257003510239232', '974', '18.50', '0.00', '18.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411258076639682560', '975', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411258426616590336', '976', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411259155091726336', '977', '15.20', '0.00', '15.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411259861387313152', '978', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411261619161419776', '980', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411261767706873856', '981', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411265328247398400', '984', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411267423994269696', '982', '19.90', '0.00', '19.90', '1', '19.90', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411269839586222080', '983', '23.94', '0.00', '23.94', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411270857317302272', '986', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411271412060176384', '987', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411273063630278656', '988', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411276475830775808', '991', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411280774380003328', '992', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411282280718155776', '995', '115.00', '0.00', '115.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411282759586136064', '994', '26.26', '0.00', '26.26', '1', '26.26', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411283315658498048', '996', '198.01', '0.00', '198.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411284192830074880', '997', '6.50', '0.00', '6.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411284407683305472', '998', '6.00', '0.00', '6.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411284954494689280', '999', '18.40', '0.00', '18.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411286160805896192', '1000', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411287658356985856', '1002', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411287890868191232', '1003', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411291551770005504', '1006', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411291790442672128', '1004', '191.00', '0.00', '191.00', '1', '191.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411293599785693184', '1009', '178.00', '0.00', '178.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411294867904184320', '1005', '16.79', '0.00', '16.79', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411295537554161664', '1007', '197.17', '0.00', '197.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411299246799572992', '1008', '11.20', '0.00', '11.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411300395753549824', '1010', '5.00', '0.00', '5.00', '1', '5.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411301194244206592', '1011', '7.00', '0.00', '7.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411301370870530048', '1012', '2.92', '0.00', '2.92', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411301514164822016', '1013', '51.06', '0.00', '51.06', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411301879102730240', '1014', '7.70', '0.00', '7.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411302938760171520', '1017', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411304093514899456', '1015', '20.10', '0.00', '20.10', '1', '20.10', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411304550371147776', '1016', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411305450976215040', '1018', '93.00', '0.00', '93.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:49', 'SYS', '2021-09-01 17:54:49', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411307488187428864', '1019', '1.30', '0.00', '1.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411308296979341312', '1024', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411311454392586240', '1025', '692.40', '0.00', '692.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411311490199371776', '1022', '0.31', '0.00', '0.31', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411311587263926272', '1023', '54.33', '0.00', '54.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411312090538446848', '1026', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411314377512075264', '1027', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411314986629914624', '1028', '1.31', '0.00', '1.31', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411317090148827136', '1030', '4.40', '0.00', '4.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411317185074323456', '1029', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411320627519991808', '1031', '2.30', '0.00', '2.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411326540926566400', '1032', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411331394122272768', '1034', '357.02', '0.00', '357.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411334159770771456', '1035', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411334211209707520', '1036', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411335095721312256', '1037', '7.20', '0.00', '7.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411335341884973056', '1038', '7.90', '0.00', '7.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411335853191634944', '1039', '17.00', '0.00', '17.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411336062474784768', '1043', '149.00', '0.00', '149.00', '1', '149.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411336083647746048', '1040', '0.34', '0.00', '0.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411336706547945472', '1041', '5.10', '0.00', '5.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411337957377474560', '1042', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411339821296803840', '1046', '1.10', '0.00', '1.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411341061300871168', '1047', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411344434859237376', '1048', '81.00', '0.00', '81.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411351499912679424', '1049', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411357510174236672', '1050', '55.20', '0.00', '55.20', '1', '55.20', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411359805985181696', '1051', '122.16', '0.00', '122.16', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411364736389599232', '1054', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411366146686480384', '1055', '20.00', '0.00', '20.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411366884581969920', '1056', '8.66', '0.00', '8.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411369223887941632', '1057', '10.10', '0.00', '10.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411370398653771776', '1058', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411373976231514112', '1059', '7.60', '0.00', '7.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411374146809671680', '1060', '15.90', '0.00', '15.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411383273749352448', '1061', '9.00', '0.00', '9.00', '1', '9.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411408127814975488', '1062', '579.00', '0.00', '579.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411410302528028672', '1063', '1.70', '0.00', '1.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411413104369250304', '1065', '281.16', '0.00', '281.16', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411413831107989504', '1066', '8.70', '0.00', '8.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411440403718221824', '1068', '1294.01', '0.00', '1294.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411441621781860352', '1069', '21.50', '0.00', '21.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411445864790212608', '1070', '10.02', '0.00', '10.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411448791097294848', '1071', '21.80', '0.00', '21.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411451292164988928', '1072', '132.36', '0.00', '132.36', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411459887950610432', '1073', '27.30', '0.00', '27.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411464629267337216', '1074', '0.77', '0.00', '0.77', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411482303510749184', '1076', '116.57', '0.00', '116.57', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411482612911984640', '1078', '192.34', '0.00', '192.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411482693325201408', '1077', '6.50', '0.00', '6.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411486309922512896', '1084', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411486846600478720', '1082', '60.27', '0.00', '60.27', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411486928259440640', '1083', '13.70', '0.00', '13.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411487628938883072', '1085', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411488930246868992', '1086', '73.70', '0.00', '73.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411488987641692160', '1087', '11.81', '0.00', '11.81', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411490004768800768', '1088', '3.80', '0.00', '3.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411490394746798080', '1089', '279.00', '0.00', '279.00', '1', '279.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411498294093434880', '1090', '9.20', '0.00', '9.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411498616740368384', '1091', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411507385352228864', '1093', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411507686205431808', '1094', '1110.79', '0.00', '1110.79', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411508072337268736', '1095', '79.00', '0.00', '79.00', '1', '79.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411508422901379072', '1096', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411508741874020352', '1097', '3.10', '0.00', '3.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411509630319878144', '1099', '273.18', '0.00', '273.18', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411511449850920960', '1100', '46.43', '0.00', '46.43', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411512810118225920', '1102', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411514045839958016', '1101', '47.17', '0.00', '47.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411514850861015040', '1106', '93.55', '0.00', '93.55', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411514862215086080', '1104', '56.08', '0.00', '56.08', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411514866161926144', '1111', '179.00', '0.00', '179.00', '1', '179.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411514882922250240', '1105', '7.60', '0.00', '7.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411515472595267584', '1107', '10.70', '0.00', '10.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411515571857678336', '1108', '42.50', '0.00', '42.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411515759397621760', '1109', '2.80', '0.00', '2.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411518573897224192', '1113', '3.70', '0.00', '3.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411519586158923776', '1114', '0.90', '0.00', '0.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411520487821037568', '1115', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411521976069128192', '1116', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411522249546252288', '1121', '11.20', '0.00', '11.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411524916012044288', '1117', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411525375909056512', '1118', '130.50', '0.00', '130.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411526058636988416', '1119', '5.28', '0.00', '5.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411526213255737344', '1125', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411526415983239168', '1120', '298.00', '0.00', '298.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411527749545361408', '1123', '64.00', '0.00', '64.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411528241147265024', '1128', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411530899887124480', '1127', '470.81', '0.00', '470.81', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411530913766096896', '1133', '199.00', '0.00', '199.00', '1', '199.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411531095232663552', '1126', '30.80', '0.00', '30.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411531789398327296', '1129', '7.26', '0.00', '7.26', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411532160996986880', '1130', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411533439987073024', '1131', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411533832951316480', '1132', '227.18', '0.00', '227.18', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411535452481150976', '1135', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411535454662205440', '1134', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411536473282568192', '1139', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411536482090598400', '1136', '22.02', '0.00', '22.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411536978524225536', '1138', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411538335129812992', '1140', '8.90', '0.00', '8.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411538562972897280', '1141', '15.50', '0.00', '15.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411539753907679232', '1142', '149.00', '0.00', '149.00', '1', '149.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411540874764103680', '1143', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411540893437247488', '1144', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411541192759496704', '1146', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411542834787553280', '1148', '128.11', '0.00', '128.11', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411543455175450624', '1149', '303.49', '0.00', '303.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411543810286182400', '1150', '23.17', '0.00', '23.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411544935265656832', '1151', '211.00', '0.00', '211.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411546076489613312', '1152', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411546496498827264', '1162', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411547024490397696', '1153', '137.50', '0.00', '137.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411549476971216896', '1154', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411550338028331008', '1155', '90.88', '0.00', '90.88', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411550406261329920', '1156', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411550619000528896', '1157', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411552180095320064', '1163', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411552230221529088', '1159', '94.61', '0.00', '94.61', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411552296080490496', '1161', '116.98', '0.00', '116.98', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411554497767022592', '1164', '278.00', '0.00', '278.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411555020255780864', '1165', '815.80', '0.00', '815.80', '1', '815.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411555974980030464', '1166', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411556654868250624', '1167', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411557735824244736', '1168', '21.00', '0.00', '21.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411557946558648320', '1169', '35.20', '0.00', '35.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:50', 'SYS', '2021-09-01 17:54:50', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411560501741346816', '1172', '68.90', '0.00', '68.90', '1', '68.90', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411560571450572800', '1173', '63.57', '0.00', '63.57', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411564924681048064', '1174', '1.70', '0.00', '1.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411565540996198400', '1177', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411565703420620800', '1178', '2.80', '0.00', '2.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411565876024606720', '1175', '19.80', '0.00', '19.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411566027795488768', '1176', '28.50', '0.00', '28.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411567121074405376', '1179', '28.50', '0.00', '28.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411568495233220608', '1181', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411569092778921984', '1180', '6.50', '0.00', '6.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411570874091556864', '1182', '97.99', '0.00', '97.99', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411571372513214464', '1185', '110.50', '0.00', '110.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411571487210721280', '1184', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411572398159028224', '1183', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411573357492813824', '1186', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411573427638288384', '1188', '3.60', '0.00', '3.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411573510937128960', '1187', '186.00', '0.00', '186.00', '1', '186.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411573864227594240', '1189', '15.40', '0.00', '15.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411575857268527104', '1190', '1.20', '0.00', '1.20', '1', '1.20', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411576357883899904', '1191', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411579054309761024', '1192', '15.00', '0.00', '15.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411579302331424768', '1194', '97.00', '0.00', '97.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411581066174681088', '1198', '73.51', '0.00', '73.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411581443200667648', '1196', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411581691365056512', '1197', '298.51', '0.00', '298.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411581734964846592', '1199', '9.50', '0.00', '9.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411582264277622784', '1200', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411582789404499968', '1202', '99.00', '0.00', '99.00', '1', '99.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411582830265417728', '1201', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411583922642485248', '1204', '3.90', '0.00', '3.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411583988690235392', '1205', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411586697946353664', '1207', '26.05', '0.00', '26.05', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411586980281749504', '1206', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411589110107377664', '1210', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411589414597148672', '1208', '219.00', '0.00', '219.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411589687478566912', '1209', '997.00', '0.00', '997.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411590675417452544', '1212', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411591350792626176', '1213', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411591986980483072', '1214', '8.40', '0.00', '8.40', '1', '8.40', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411592980539887616', '1215', '12.50', '0.00', '12.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411593865881862144', '1216', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411595048063238144', '1217', '179.00', '0.00', '179.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411596703383031808', '1219', '10.40', '0.00', '10.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411599197060382720', '1220', '822.31', '0.00', '822.31', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411599563793543168', '1221', '178.00', '0.00', '178.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411599846669991936', '1222', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411602949599285248', '1223', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411603368954216448', '1224', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411605782176354304', '1225', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411607443573727232', '1226', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411607612683853824', '1227', '2099.00', '0.00', '2099.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411607652861104128', '1228', '12.90', '0.00', '12.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411613238369591296', '1230', '11.83', '0.00', '11.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411613469890985984', '1231', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411613473556828160', '1232', '27.80', '0.00', '27.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411614407930306560', '1233', '34.10', '0.00', '34.10', '1', '34.10', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411614629976756224', '1234', '506.69', '0.00', '506.69', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411614771010265088', '1236', '8.00', '0.00', '8.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411614873246384128', '1238', '274.67', '0.00', '274.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411615006344269824', '1235', '79.00', '0.00', '79.00', '1', '79.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411615117111713792', '1241', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411615296476811264', '1237', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411615467193425920', '1239', '219.00', '0.00', '219.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411617152083079168', '1240', '10.20', '0.00', '10.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411618081624739840', '1242', '8.50', '0.00', '8.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411619062848606208', '1243', '38.43', '0.00', '38.43', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411619246877958144', '1244', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411620216726765568', '1246', '41.88', '0.00', '41.88', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411620870362943488', '1247', '0.60', '0.00', '0.60', '1', '0.60', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411624041344798720', '1249', '58.00', '0.00', '58.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411625560580427776', '1255', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411625984893014016', '1250', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411626634204860416', '1252', '4.80', '0.00', '4.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411626812261425152', '1253', '439.83', '0.00', '439.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411627389229907968', '1254', '208.45', '0.00', '208.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411628704509079552', '1256', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411630648824942592', '1261', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411630766370217984', '1257', '19.50', '0.00', '19.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411631083845468160', '1258', '88.00', '0.00', '88.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411631522536112128', '1259', '6.10', '0.00', '6.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411631687842021376', '1260', '16.60', '0.00', '16.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411633938367139840', '1263', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411634007736766464', '1262', '179.00', '0.00', '179.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411634944148664320', '1264', '31.44', '0.00', '31.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411636301169594368', '1266', '25.60', '0.00', '25.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411638692627525632', '1267', '5.80', '0.00', '5.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411639129774735360', '1270', '279.00', '0.00', '279.00', '1', '279.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411642350891089920', '1268', '18.80', '0.00', '18.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411643002467786752', '1269', '252.34', '0.00', '252.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411644366015156224', '1271', '2.10', '0.00', '2.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411644715786469376', '1272', '2249.00', '0.00', '2249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411645301923762176', '1273', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411648391728996352', '1274', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411650552621940736', '1275', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411653691097919488', '1277', '3.69', '0.00', '3.69', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411654194905116672', '1278', '122.17', '0.00', '122.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411662478198423552', '1280', '1.20', '0.00', '1.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411663821998800896', '1281', '10.10', '0.00', '10.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411664943111122944', '1282', '120.75', '0.00', '120.75', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411665041421484032', '1283', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411666582312214528', '1284', '2.30', '0.00', '2.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411668500619067392', '1285', '33.90', '0.00', '33.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411668755305623552', '1287', '73.60', '0.00', '73.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411668824910073856', '1286', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411674813134688256', '1288', '113.00', '0.00', '113.00', '1', '113.00', '2', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411676132914479104', '1289', '3.00', '0.00', '3.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411676247540613120', '1290', '282.49', '0.00', '282.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411679114095673344', '1292', '186.00', '0.00', '186.00', '1', '186.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411679164582518784', '1299', '5449.00', '0.00', '5449.00', '1', '5449.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411679498046431232', '1293', '0.70', '0.00', '0.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411679631068880896', '1294', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411680463948595200', '1295', '113.00', '0.00', '113.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411683413341122560', '1297', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411683686084145152', '1298', '89.67', '0.00', '89.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411686377996820480', '1300', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411686780423536640', '1301', '0.81', '0.00', '0.81', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411686982266019840', '1302', '11.90', '0.00', '11.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411687187765977088', '1303', '43.00', '0.00', '43.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411687709445107712', '1304', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411688288552660992', '1305', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411689223098101760', '1306', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411689674006765568', '1307', '498.00', '0.00', '498.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411691559170215936', '1308', '1612.44', '0.00', '1612.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411695237755207680', '1316', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411695324485013504', '1311', '5.80', '0.00', '5.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411695930377424896', '1310', '51.00', '0.00', '51.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411697062176776192', '1312', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411699824977379328', '1313', '64.40', '0.00', '64.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:51', 'SYS', '2021-09-01 17:54:51', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411699989956132864', '1315', '0.02', '0.00', '0.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411700013641396224', '1314', '141.60', '0.00', '141.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411700872140021760', '1317', '666.16', '0.00', '666.16', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411703112087035904', '1318', '32.50', '0.00', '32.50', '1', '32.50', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411703169553158144', '1319', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411704133462937600', '1320', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411706216186540032', '1321', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411707623732027392', '1322', '19.90', '0.00', '19.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411707833103302656', '1323', '2.50', '0.00', '2.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411710096010100736', '1324', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411712502177341440', '1325', '5.20', '0.00', '5.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411714546674089984', '1326', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411716309913309184', '1327', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411717949986856960', '1328', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411719224820486144', '1329', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411719526919323648', '1330', '100.48', '0.00', '100.48', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411720430863179776', '1331', '1.30', '0.00', '1.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411721165252202496', '1332', '495.68', '0.00', '495.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411721955337560064', '1333', '801.10', '0.00', '801.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411730210054881280', '1334', '29.00', '0.00', '29.00', '1', '29.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411731417142042624', '1335', '0.63', '0.00', '0.63', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411734143062228992', '1336', '0.70', '0.00', '0.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411736768830754816', '1337', '19.66', '0.00', '19.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411738155345924096', '1338', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411742494496026624', '1339', '248.49', '0.00', '248.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411745068745887744', '1340', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411755703772831744', '1341', '2.20', '0.00', '2.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411760224515276800', '1342', '150.00', '0.00', '150.00', '1', '150.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411760737126318080', '1343', '14.00', '0.00', '14.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411771718812446720', '1346', '5.30', '0.00', '5.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411783829735243776', '1347', '4.70', '0.00', '4.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411785190455533568', '1348', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411789050406490112', '1349', '27.10', '0.00', '27.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411795263718416384', '1350', '3379.00', '0.00', '3379.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411797957501669376', '1352', '38.50', '0.00', '38.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411798319260422144', '1351', '88.00', '0.00', '88.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411836007925661696', '1353', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411837936500199424', '1354', '254.97', '0.00', '254.97', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411838912795656192', '1355', '41.00', '0.00', '41.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411844844543954944', '1356', '19.70', '0.00', '19.70', '1', '19.70', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411847829793722368', '1357', '15.70', '0.00', '15.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411848393160032256', '1358', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411849796720918528', '1359', '465.50', '0.00', '465.50', '1', '465.50', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411852173175857152', '1360', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411855753303687168', '1361', '28.50', '0.00', '28.50', '1', '28.50', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411856605284311040', '1362', '66.34', '0.00', '66.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411860428711247872', '1364', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411862297122611200', '1363', '30.16', '0.00', '30.16', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411863921970814976', '1366', '21.41', '0.00', '21.41', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411864873545109504', '1367', '120.15', '0.00', '120.15', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411865125186568192', '1368', '64.00', '0.00', '64.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411865912155488256', '1369', '19.00', '0.00', '19.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411867915749318656', '1371', '179.00', '0.00', '179.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411868295841374208', '1370', '20.80', '0.00', '20.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411870003401220096', '1372', '15.20', '0.00', '15.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411870560987889664', '1376', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411870771386650624', '1373', '10.79', '0.00', '10.79', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411870781142601728', '1374', '44.10', '0.00', '44.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411871256588042240', '1375', '68.50', '0.00', '68.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411871700425101312', '1377', '479.00', '0.00', '479.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411873636750647296', '1378', '630.67', '0.00', '630.67', '1', '630.67', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411873718355001344', '1379', '929.00', '0.00', '929.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411876442429620224', '1380', '3299.00', '0.00', '3299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411877908607328256', '1383', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411878643105415168', '1381', '64.34', '0.00', '64.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411879226931601408', '1382', '30.00', '0.00', '30.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411880601937674240', '1384', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411880803620773888', '1385', '26.10', '0.00', '26.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411881089538187264', '1388', '13.51', '0.00', '13.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411881317347504128', '1387', '232.33', '0.00', '232.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411881564228448256', '1389', '9.00', '0.00', '9.00', '1', '9.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411882399561814016', '1392', '28.50', '0.00', '28.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411882682429915136', '1390', '2.50', '0.00', '2.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411882856732610560', '1391', '202.68', '0.00', '202.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411883218457731072', '1393', '2.68', '0.00', '2.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411883339421487104', '1401', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411883380152389632', '1395', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411883640815804416', '1394', '31.17', '0.00', '31.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411883780834201600', '1398', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411884342426460160', '1399', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411884386701410304', '1397', '198.00', '0.00', '198.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411884453256630272', '1396', '1.30', '0.00', '1.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411886810900074496', '1400', '298.00', '0.00', '298.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411887676054986752', '1406', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411888732788961280', '1402', '97.49', '0.00', '97.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411888812057108480', '1403', '23.90', '0.00', '23.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411890517406519296', '1404', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411890772193816576', '1407', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411891727652085760', '1409', '146.00', '0.00', '146.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411891885504602112', '1411', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411892785371627520', '1413', '1.23', '0.00', '1.23', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411893775562952704', '1408', '628.92', '0.00', '628.92', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411893905296945152', '1410', '191.00', '0.00', '191.00', '1', '191.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411895282928697344', '1412', '28.67', '0.00', '28.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411897988263165952', '1414', '30.66', '0.00', '30.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411899502037798912', '1416', '198.00', '0.00', '198.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411899534719787008', '1415', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411901226798534656', '1417', '1.80', '0.00', '1.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411901441312002048', '1421', '2591.67', '0.00', '2591.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411901987339100160', '1419', '191.00', '0.00', '191.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411902176917446656', '1418', '16.00', '0.00', '16.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411903181818126336', '1425', '0.70', '0.00', '0.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411905307604549632', '1422', '9.60', '0.00', '9.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411905429147189248', '1423', '12.79', '0.00', '12.79', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411906439940886528', '1426', '146.35', '0.00', '146.35', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411907484695871488', '1427', '198.17', '0.00', '198.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411907926968369152', '1432', '9.30', '0.00', '9.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411907960996843520', '1431', '179.00', '0.00', '179.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411908398303281152', '1428', '4.70', '0.00', '4.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411909041470509056', '1433', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411909062102323200', '1429', '2.55', '0.00', '2.55', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411912535837376512', '1436', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411912884442828800', '1437', '7.20', '0.00', '7.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411913771793981440', '1438', '1.30', '0.00', '1.30', '1', '1.30', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411914943556734976', '1439', '22.50', '0.00', '22.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411915595552862208', '1447', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411915800822132736', '1441', '20.83', '0.00', '20.83', '1', '20.83', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:52', 'SYS', '2021-09-01 17:54:52', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411916170449330176', '1442', '220.85', '0.00', '220.85', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411916770197061632', '1443', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411917061441069056', '1444', '95.40', '0.00', '95.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411917466384412672', '1445', '101.17', '0.00', '101.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411917957810069504', '1449', '6.80', '0.00', '6.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411918154116087808', '1446', '21.25', '0.00', '21.25', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411921117236654080', '1450', '91.40', '0.00', '91.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411921153840332800', '1451', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411921702128177152', '1452', '87.00', '0.00', '87.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411921855132176384', '1454', '198.34', '0.00', '198.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411922355156123648', '1455', '3.00', '0.00', '3.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411924287463559168', '1457', '89.51', '0.00', '89.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411926122853183488', '1461', '50.75', '0.00', '50.75', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411926165265977344', '1460', '89.17', '0.00', '89.17', '1', '89.17', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411926440169123840', '1459', '58.66', '0.00', '58.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411927881487097856', '1463', '89.17', '0.00', '89.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411928408459563008', '1464', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411928681487749120', '1467', '1279.00', '0.00', '1279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411929096606326784', '1465', '257.10', '0.00', '257.10', '1', '257.10', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411929115472367616', '1466', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411929407077093376', '1469', '23.33', '0.00', '23.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411929444112916480', '1468', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411930527862333440', '1470', '1.80', '0.00', '1.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411930634276016128', '1471', '198.00', '0.00', '198.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411933218084732928', '1473', '12028.80', '0.00', '12028.80', '1', '12028.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411933563955388416', '1474', '8.40', '0.00', '8.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411934921198612480', '1475', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411935026341437440', '1476', '882.33', '0.00', '882.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411935320622211072', '1477', '31.60', '0.00', '31.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411935416210407424', '1478', '3007.20', '0.00', '3007.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411936506511306752', '1480', '33.90', '0.00', '33.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411937545612398592', '1489', '3.20', '0.00', '3.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411937838395768832', '1484', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411937987251654656', '1481', '10.40', '0.00', '10.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411938071364198400', '1483', '2.90', '0.00', '2.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411938090280538112', '1482', '305.82', '0.00', '305.82', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411938252356804608', '1485', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411938518552481792', '1486', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411938646403284992', '1488', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411938948690948096', '1490', '9.00', '0.00', '9.00', '1', '9.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411938961932386304', '1487', '32.60', '0.00', '32.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411939661907202048', '1491', '762.34', '0.00', '762.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411939784389287936', '1492', '154.91', '0.00', '154.91', '1', '154.91', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411941192773627904', '1493', '1.50', '0.00', '1.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411941653421469696', '1494', '216.33', '0.00', '216.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411942368248205312', '1495', '33.70', '0.00', '33.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411943722303750144', '1496', '36.80', '0.00', '36.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411945603285614592', '1497', '114.90', '0.00', '114.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411946300223725568', '1499', '305.00', '0.00', '305.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411946357341696000', '1504', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411946379307257856', '1498', '626.50', '0.00', '626.50', '1', '626.50', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411946739484807168', '1501', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411946916912263168', '1500', '148.00', '0.00', '148.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411947335675793408', '1502', '10.86', '0.00', '10.86', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411947846453891072', '1503', '154.91', '0.00', '154.91', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411948810053341184', '1505', '110.80', '0.00', '110.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411952384040636416', '1510', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411952773687377920', '1507', '17.50', '0.00', '17.50', '1', '17.50', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411952797091508224', '1511', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411952983742332928', '1508', '8.50', '0.00', '8.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411952995788382208', '1509', '30.60', '0.00', '30.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411955326781165568', '1512', '599.00', '0.00', '599.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411956450179358720', '1513', '599.00', '0.00', '599.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411958227947708416', '1515', '257.10', '0.00', '257.10', '1', '257.10', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411960697956585472', '1516', '198.00', '0.00', '198.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411961260651819008', '1517', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411961455527530496', '1519', '15.20', '0.00', '15.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411961798655082496', '1524', '619.00', '0.00', '619.00', '1', '619.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411961821170225152', '1518', '1973.74', '0.00', '1973.74', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411962139501113344', '1520', '189.17', '0.00', '189.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411963000058941440', '1523', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411963027707887616', '1521', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411963697726971904', '1525', '1503.60', '0.00', '1503.60', '1', '1503.60', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411963720900517888', '1536', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411964220370800640', '1528', '167.37', '0.00', '167.37', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411964388071653376', '1527', '1198.51', '0.00', '1198.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411964409932386304', '1529', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411964832743395328', '1532', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411965690335952896', '1533', '2.80', '0.00', '2.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411965699626311680', '1534', '639.00', '0.00', '639.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411966019018383360', '1543', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411966602936786944', '1535', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411968452838809600', '1539', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411968528160116736', '1538', '35.20', '0.00', '35.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411968784683700224', '1540', '1.70', '0.00', '1.70', '1', '1.70', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411969505613307904', '1542', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411969753450532864', '1541', '6.60', '0.00', '6.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411972610484551680', '1544', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411973060189437952', '1551', '13.80', '0.00', '13.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411973500280991744', '1545', '1.80', '0.00', '1.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411974118030659584', '1548', '125.30', '0.00', '125.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411975728232345600', '1550', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411977003351085056', '1552', '25.22', '0.00', '25.22', '1', '25.22', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411977094484955136', '1553', '198.00', '0.00', '198.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411977662146244608', '1554', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411978146810671104', '1555', '4.00', '0.00', '4.00', '1', '4.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411978923797061632', '1557', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411979254601838592', '1558', '61.66', '0.00', '61.66', '1', '61.66', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411980433352286208', '1560', '298.00', '0.00', '298.00', '1', '298.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411981719380369408', '1561', '26.00', '0.00', '26.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411983042444238848', '1562', '110.10', '0.00', '110.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411983222681772032', '1564', '9.90', '0.00', '9.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411983429989552128', '1563', '14.84', '0.00', '14.84', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411983711964180480', '1565', '7.60', '0.00', '7.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411985155807129600', '1567', '87.17', '0.00', '87.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411985280625520640', '1568', '755.97', '0.00', '755.97', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411985992369549312', '1569', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411987201876774912', '1570', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411987285821583360', '1571', '479.00', '0.00', '479.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411987381787262976', '1574', '549.00', '0.00', '549.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411988644994158592', '1572', '179.00', '0.00', '179.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411989231584354304', '1573', '176.00', '0.00', '176.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411991728709419008', '1576', '479.00', '0.00', '479.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411991971790286848', '1575', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411992152673759232', '1577', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411993878571237376', '1578', '3759.00', '0.00', '3759.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411994351688716288', '1580', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411994891977969664', '1579', '2249.00', '0.00', '2249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411995828222119936', '1581', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411996988819578880', '1582', '10.20', '0.00', '10.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1411998639118757888', '1583', '16.50', '0.00', '16.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412000677974204416', '1584', '231.66', '0.00', '231.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412000760505552896', '1585', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412001679175565312', '1586', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412002568967692288', '1587', '22.34', '0.00', '22.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412003108887953408', '1590', '7.84', '0.00', '7.84', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412003360797757440', '1588', '1099.00', '0.00', '1099.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412003510194737152', '1591', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412004296513540096', '1593', '599.00', '0.00', '599.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412004415652728832', '1592', '17.00', '0.00', '17.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412004784260653056', '1594', '7.80', '0.00', '7.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412005639672254464', '1596', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412005671980974080', '1599', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412006404197433344', '1597', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412006445960015872', '1598', '1.50', '0.00', '1.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412006955672805376', '1600', '0.50', '0.00', '0.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412008566902181888', '1601', '5.20', '0.00', '5.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412008607339483136', '1602', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412008804610162688', '1603', '4.10', '0.00', '4.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412008897673310208', '1604', '379.00', '0.00', '379.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412009485781827584', '1605', '18.50', '0.00', '18.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412009736731348992', '1606', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412010701169610752', '1609', '122.80', '0.00', '122.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412011095639601152', '1607', '0.50', '0.00', '0.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412011178036772864', '1608', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412011789146857472', '1610', '196.00', '0.00', '196.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412011977156575232', '1611', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412012965993074688', '1612', '10.70', '0.00', '10.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412013089846677504', '1613', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:53', 'SYS', '2021-09-01 17:54:53', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412013464788094976', '1614', '131.34', '0.00', '131.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412016460590624768', '1615', '4.00', '0.00', '4.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412017254232625152', '1616', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412017315150692352', '1617', '1.70', '0.00', '1.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412018110445297664', '1618', '899.00', '0.00', '899.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412019911022231552', '1619', '32.00', '0.00', '32.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412020168963559424', '1620', '1.40', '0.00', '1.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412021188519182336', '1622', '2.87', '0.00', '2.87', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412021937235984384', '1623', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412022326253514752', '1624', '1.60', '0.00', '1.60', '1', '1.60', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412023685849772032', '1625', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412024460030205952', '1626', '19.00', '0.00', '19.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412026961320099840', '1628', '849.00', '0.00', '849.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412027000440397824', '1629', '0.20', '0.00', '0.20', '1', '0.20', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412027398517641216', '1627', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412028822974525440', '1630', '6.80', '0.00', '6.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412030892385464320', '1631', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412031249471746048', '1632', '679.00', '0.00', '679.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412031917339168768', '1633', '197.00', '0.00', '197.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412033832433213440', '1634', '3.85', '0.00', '3.85', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412034002000433152', '1635', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412034157416177664', '1642', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412034238978629632', '1636', '6.80', '0.00', '6.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412034419010707456', '1638', '2199.00', '0.00', '2199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412035664022745088', '1639', '31.00', '0.00', '31.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412035717600800768', '1640', '86.92', '0.00', '86.92', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412036059184918528', '1641', '103.00', '0.00', '103.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412038203908808704', '1643', '8.00', '0.00', '8.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412041827300859904', '1644', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412044791625179136', '1645', '23.90', '0.00', '23.90', '1', '23.90', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412045620692262912', '1650', '126.70', '0.00', '126.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412046112004685824', '1646', '46.00', '0.00', '46.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412047336812761088', '1649', '101.60', '0.00', '101.60', '1', '101.60', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412047534767144960', '1648', '23.90', '0.00', '23.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412049513903951872', '1651', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412049568241274880', '1653', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412050386025701376', '1655', '12.90', '0.00', '12.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412050507211722752', '1654', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412051387004735488', '1656', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412052414449717248', '1657', '184.00', '0.00', '184.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412054142700167168', '1658', '8.70', '0.00', '8.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412054866758696960', '1660', '98.34', '0.00', '98.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412057056608985088', '1665', '23.16', '0.00', '23.16', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412057099206332416', '1661', '125.30', '0.00', '125.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412057589231058944', '1662', '53.33', '0.00', '53.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412058221748817920', '1663', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412059554329616384', '1664', '1.08', '0.00', '1.08', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412059775398797312', '1666', '253.90', '0.00', '253.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412062244023439360', '1667', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412063140799188992', '1668', '0.70', '0.00', '0.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412064532423237632', '1669', '1.50', '0.00', '1.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412065181848248320', '1670', '67.33', '0.00', '67.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412068323914612736', '1673', '7.00', '0.00', '7.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412068735270916096', '1675', '99.00', '0.00', '99.00', '1', '99.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412068807798935552', '1674', '10.40', '0.00', '10.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412070043507974144', '1676', '17.90', '0.00', '17.90', '1', '17.90', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412071474101182464', '1679', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412071589255794688', '1677', '34.10', '0.00', '34.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412071995381854208', '1678', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412079409992818688', '1680', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412085508422709248', '1684', '20.80', '0.00', '20.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412086715006574592', '1682', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412088127203442688', '1683', '2220.82', '0.00', '2220.82', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412093568683843584', '1685', '7.00', '0.00', '7.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412103557028749312', '1687', '0.62', '0.00', '0.62', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412107481290874880', '1688', '14.60', '0.00', '14.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412108893584293888', '1689', '2.70', '0.00', '2.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412110316824928256', '1690', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412118587522625536', '1691', '1.30', '0.00', '1.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412122631376957440', '1692', '1.70', '1.08', '1.70', '1', '0.62', '2', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412123346564521984', '1693', '33.30', '0.00', '33.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412124754017771520', '1694', '8.70', '0.00', '8.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412137194008862720', '1696', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412137540290592768', '1695', '3299.00', '0.00', '3299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412141549986471936', '1697', '0.20', '0.00', '0.20', '1', '0.20', '2', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412145124946976768', '1698', '0.20', '0.00', '0.20', '1', '0.20', '2', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412156037456449536', '1699', '0.90', '0.00', '0.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412160000423596032', '1700', '12.70', '0.00', '12.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412161445252284416', '1704', '1.60', '0.00', '1.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412164131762708480', '1701', '1.60', '0.00', '1.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412164348453036032', '1702', '3.80', '0.00', '3.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412165782254841856', '1703', '42.75', '0.00', '42.75', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412168903400038400', '1705', '79.86', '0.00', '79.86', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412171612777848832', '1706', '0.60', '0.04', '0.60', '1', '0.56', '4', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412176098086871040', '1707', '99.00', '0.00', '99.00', '1', '99.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412179320994209792', '1708', '4.10', '0.00', '4.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412186370574880768', '1709', '10.13', '0.00', '10.13', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412187736588386304', '1710', '11.60', '0.00', '11.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412188862905806848', '1711', '16.80', '0.00', '16.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412189119890825216', '1712', '1.20', '0.00', '1.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412192014442942464', '1713', '1130.39', '0.00', '1130.39', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412198695633612800', '1714', '3.70', '0.00', '3.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412200727312465920', '1715', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412203000449142784', '1716', '79.00', '0.00', '79.00', '1', '79.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412205502984818688', '1718', '1.80', '0.00', '1.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412208497168465920', '1719', '198.00', '0.00', '198.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412209682608771072', '1721', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412210078983086080', '1722', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412211179803344896', '1723', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412212055964098560', '1725', '2.60', '0.00', '2.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412212722246053888', '1724', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412214075232038912', '1726', '4.60', '0.00', '4.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412214084409212928', '1727', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412217087065305088', '1728', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412218515657834496', '1729', '13.20', '0.00', '13.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412218762396041216', '1735', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412218765101453312', '1730', '815.67', '0.00', '815.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412218888506290176', '1733', '499.00', '0.00', '499.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412219853313626112', '1732', '9.90', '0.00', '9.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412221765974986752', '1734', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412225489850036224', '1736', '10.20', '0.00', '10.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412225560129818624', '1738', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412225576214949888', '1737', '40.00', '0.00', '40.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412225618233516032', '1739', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412226756425003008', '1740', '68.90', '0.00', '68.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412228471861776384', '1741', '62.18', '0.00', '62.18', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412228714959437824', '1742', '29.30', '0.00', '29.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412229143575379968', '1743', '18.40', '0.00', '18.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412229474703093760', '1744', '99.00', '0.00', '99.00', '1', '99.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412230024345661440', '1745', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412230430031216640', '1746', '23.90', '0.00', '23.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412230481709305856', '1747', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412231198180249600', '1748', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412232420090167296', '1749', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412234911418667008', '1750', '1.70', '0.00', '1.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412235010345488384', '1751', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412235033904910336', '1752', '2.20', '0.00', '2.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412235423769640960', '1753', '15.80', '0.00', '15.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412236457061634048', '1756', '21.14', '0.00', '21.14', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412236577748422656', '1754', '191.77', '0.00', '191.77', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412237806910287872', '1757', '170.80', '0.00', '170.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412237881610735616', '1758', '10.69', '0.00', '10.69', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412239317765685248', '1759', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412240067879211008', '1760', '90.77', '0.00', '90.77', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412240449426669568', '1761', '187.88', '0.00', '187.88', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412240978844311552', '1762', '22.30', '0.00', '22.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412240983508369408', '1763', '36.00', '0.00', '36.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412241140119453696', '1767', '166.37', '0.00', '166.37', '1', '166.37', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412241390867546112', '1764', '85.34', '0.00', '85.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412241573844037632', '1765', '5.20', '0.00', '5.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412241928275296256', '1768', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412242336020303872', '1766', '115.83', '0.00', '115.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:54', 'SYS', '2021-09-01 17:54:54', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412243070786867200', '1769', '0.70', '0.00', '0.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412243425184649216', '1770', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412244200426266624', '1771', '206.30', '0.00', '206.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412244750203023360', '1772', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412244973230972928', '1773', '6.02', '0.00', '6.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412245014939127808', '1779', '23.20', '0.00', '23.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412245731699576832', '1774', '2248.17', '0.00', '2248.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412246176128020480', '1776', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412246224698023936', '1775', '4306.79', '0.00', '4306.79', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412247160275279872', '1777', '30.24', '0.00', '30.24', '1', '30.24', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412248027732832256', '1778', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412248310085001216', '1782', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412248883731619840', '1784', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412249017869598720', '1781', '76.44', '0.00', '76.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412249048706154496', '1783', '104.45', '0.00', '104.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412249314234863616', '1785', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412250299892183040', '1786', '3.00', '0.00', '3.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412252008949411840', '1789', '5079.00', '0.00', '5079.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412252155536203776', '1788', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412253837363998720', '1790', '65.67', '0.00', '65.67', '1', '65.67', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412253940736823296', '1791', '1.09', '0.00', '1.09', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412254441310187520', '1792', '1.50', '0.00', '1.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412254482070495232', '1793', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412255439143501824', '1797', '52.17', '0.00', '52.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412255893340516352', '1796', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412256129714692096', '1795', '6.80', '0.00', '6.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412257175631536128', '1798', '578.00', '0.00', '578.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412257335614767104', '1801', '18.51', '0.00', '18.51', '1', '18.51', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412257803795628032', '1799', '153.41', '0.00', '153.41', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412257972293439488', '1800', '33.90', '0.00', '33.90', '1', '33.90', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412259109885173760', '1804', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412259624241025024', '1802', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412260382839537664', '1803', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412260384186003456', '1812', '32.00', '0.00', '32.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412260888299393024', '1810', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412260963469737984', '1805', '3.82', '0.00', '3.82', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412261652526780416', '1807', '2.60', '0.00', '2.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412261749113176064', '1808', '10.01', '0.00', '10.01', '1', '10.01', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412263219384537088', '1815', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412265010994020352', '1814', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412266414919897088', '1816', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412267814374563840', '1817', '83.00', '0.00', '83.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412267965436588032', '1818', '35.20', '0.00', '35.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412268098295300096', '1819', '20.31', '0.00', '20.31', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412269174792888320', '1820', '77.36', '0.00', '77.36', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412269844518367232', '1821', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412271228420571136', '1822', '96.00', '0.00', '96.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412271437053681664', '1823', '299.00', '0.00', '299.00', '1', '299.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412272093059571712', '1830', '762.60', '0.00', '762.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412272494072807424', '1824', '64.83', '0.00', '64.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412273205292544000', '1825', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412273258585374720', '1826', '3.00', '0.00', '3.00', '1', '3.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412274131419996160', '1828', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412274847966523392', '1829', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412275769832607744', '1831', '3.40', '0.00', '3.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412276074645254144', '1833', '269.00', '0.00', '269.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412277310194843648', '1834', '5.70', '0.00', '5.70', '1', '5.70', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412277701728931840', '1836', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412277782557466624', '1835', '21.00', '0.00', '21.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412278513561739264', '1837', '65.67', '0.00', '65.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412280003105878016', '1838', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412280106327691264', '1839', '2229.00', '0.00', '2229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412282473882292224', '1840', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412282949684137984', '1841', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412283047310774272', '1849', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412284171178684416', '1842', '2.90', '0.00', '2.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412285083070717952', '1845', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412285191657050112', '1846', '225.91', '0.00', '225.91', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412285561707917312', '1847', '16.70', '0.00', '16.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412285641974218752', '1848', '75.00', '0.00', '75.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412287258551332864', '1854', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412289242905952256', '1850', '0.50', '0.00', '0.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412289262459756544', '1851', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412289425462923264', '1862', '1099.00', '0.00', '1099.00', '1', '1099.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412289803600498688', '1852', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412291244033544192', '1857', '10.10', '0.00', '10.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412291569939369984', '1858', '399.00', '0.00', '399.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412291852798988288', '1859', '42.27', '0.00', '42.27', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412293904480579584', '1861', '36.49', '0.00', '36.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412294384954839040', '1863', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412295600111849472', '1866', '391.66', '0.00', '391.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412295968891793408', '1865', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412297813030793216', '1867', '279.00', '0.00', '279.00', '1', '279.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412298438019846144', '1868', '6.80', '0.00', '6.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412299024224182272', '1869', '72.02', '0.00', '72.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412301414155358208', '1870', '8.00', '0.00', '8.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412301421805768704', '1876', '148.00', '0.00', '148.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412301785560993792', '1871', '103.00', '0.00', '103.00', '1', '103.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412302163392266240', '1874', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412303135728402432', '1873', '146.29', '0.00', '146.29', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412303234776895488', '1875', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412304913639366656', '1877', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412305054337269760', '1878', '139.22', '0.00', '139.22', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412305083135381504', '1879', '30.00', '0.00', '30.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412307385204330496', '1881', '32.83', '0.00', '32.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412307437926686720', '1882', '44.10', '0.00', '44.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412309185265389568', '1884', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412309237979377664', '1885', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412309894140497920', '1886', '1.90', '0.00', '1.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412310399902232576', '1888', '1.90', '0.00', '1.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412311104666939392', '1887', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412311280357933056', '1889', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412311612047683584', '1890', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412312606315868160', '1892', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412313853584408576', '1895', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412314473888444416', '1894', '850.34', '0.00', '850.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412314994955128832', '1896', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412316557786435584', '1897', '7.90', '0.00', '7.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412318539053924352', '1898', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412318734948962304', '1899', '21.17', '0.00', '21.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412319341873074176', '1900', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412320261864374272', '1904', '183.28', '0.00', '183.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412320331158462464', '1901', '10.95', '0.00', '10.95', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412320381087469568', '1902', '72.00', '0.00', '72.00', '1', '72.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412320968201969664', '1903', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412321901946273792', '1905', '15.30', '0.00', '15.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412321909839994880', '1906', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412322907438428160', '1907', '219.00', '0.00', '219.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412323041077350400', '1908', '48.90', '0.00', '48.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412323071645433856', '1909', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412324387595714560', '1911', '1428.12', '0.00', '1428.12', '1', '1428.12', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412324594584596480', '1910', '8.70', '0.00', '8.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412326015845470208', '1912', '0.50', '0.00', '0.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412326222335254528', '1913', '6.60', '0.00', '6.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412326405957693440', '1914', '10.10', '0.00', '10.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412326586895757312', '1916', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412326629115678720', '1915', '35.90', '0.00', '35.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412326932615471104', '1919', '674.30', '0.00', '674.30', '1', '674.30', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412327047233220608', '1918', '48.73', '0.00', '48.73', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412328552539553792', '1921', '0.50', '0.00', '0.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412329387403210752', '1928', '98.71', '0.00', '98.71', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412329451450236928', '1920', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412329453790666752', '1922', '15.75', '0.00', '15.75', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412329761182801920', '1923', '1428.12', '0.00', '1428.12', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412329987348066304', '1924', '549.00', '0.00', '549.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412330113101672448', '1925', '222.34', '0.00', '222.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412330883725361152', '1926', '4.10', '0.00', '4.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412330907175694336', '1927', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412332065394995200', '1929', '9.10', '0.00', '9.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412332772357537792', '1930', '7.00', '0.00', '7.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412333224998461440', '1939', '979.00', '0.00', '979.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412333982678491136', '1932', '61.00', '0.00', '61.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412334236043829248', '1933', '45.74', '0.00', '45.74', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412334377811300352', '1937', '3.40', '0.00', '3.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412334399449665536', '1935', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412334412384915456', '1938', '11.73', '0.00', '11.73', '1', '11.73', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412334680572923904', '1934', '9.60', '0.00', '9.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:55', 'SYS', '2021-09-01 17:54:55', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412337367561519104', '1945', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412338169013297152', '1940', '299.00', '0.00', '299.00', '1', '299.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412338830195023872', '1941', '273.00', '0.00', '273.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412340338240217088', '1942', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412341116652720128', '1944', '12.00', '0.00', '12.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412342617378787328', '1946', '88.00', '0.00', '88.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412342794772766720', '1948', '179.00', '0.00', '179.00', '1', '179.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412343331433984000', '1947', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412343656232476672', '1951', '438.00', '0.00', '438.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412343754010079232', '1949', '7.60', '0.00', '7.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412344785158770688', '1954', '61.25', '0.00', '61.25', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412344871645339648', '1952', '1.30', '0.00', '1.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412344975005532160', '1953', '479.00', '0.00', '479.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412345004323749888', '1958', '2299.00', '0.00', '2299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412346308995538944', '1955', '674.30', '0.00', '674.30', '1', '674.30', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412347201191104512', '1956', '21.80', '0.00', '21.80', '1', '21.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412347917360148480', '1959', '100.00', '0.00', '100.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412348310945214464', '1957', '2224.72', '0.00', '2224.72', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412349631463129088', '1960', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412350335476957184', '1962', '4306.50', '0.00', '4306.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412351199704997888', '1961', '6.70', '0.00', '6.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412352779682541568', '1976', '148.00', '0.00', '148.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412353906188730368', '1964', '51.45', '0.00', '51.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412355804052525056', '1965', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412356461010599936', '1968', '11.00', '0.00', '11.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412356939626770432', '1969', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412357000771276800', '1972', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412357194061639680', '1970', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412357701748596736', '1971', '0.02', '0.00', '0.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412358279807574016', '1973', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412358520048930816', '1975', '3.60', '0.00', '3.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412358635740401664', '1974', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412358656472883200', '1977', '10.20', '0.00', '10.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412359310998212608', '1978', '124.36', '0.00', '124.36', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412359513109155840', '1979', '104.50', '0.00', '104.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412359942375190528', '1980', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412362477345398784', '1984', '73.00', '0.00', '73.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412364346918572032', '1981', '95.29', '0.00', '95.29', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412364518469799936', '1982', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412364864474796032', '1983', '100.00', '0.00', '100.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412367245371441152', '1986', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412368215400722432', '1987', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412368373211435008', '1988', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412368446703931392', '1989', '13.90', '0.00', '13.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412368981767168000', '1990', '0.35', '0.00', '0.35', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412369533729185792', '1993', '1.20', '0.00', '1.20', '1', '1.20', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412369621453049856', '1992', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412370069194993664', '1994', '4.70', '0.00', '4.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412371325691060224', '1996', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412371354422030336', '1998', '71.00', '0.00', '71.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412372267924705280', '1997', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412372956239294464', '2000', '33.90', '0.00', '33.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412373316425170944', '2001', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412374157559324672', '2002', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412376581372076032', '2003', '18.20', '15.67', '18.20', '1', '2.53', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412378087236276224', '2004', '35.00', '0.00', '35.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412378821675704320', '2008', '1842.70', '0.00', '1842.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412379137506783232', '2005', '75.06', '0.00', '75.06', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412379899267891200', '2012', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412381106527002624', '2006', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412383161018724352', '2007', '85.40', '0.00', '85.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412384060785025024', '2015', '399.00', '0.00', '399.00', '1', '399.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412385413603192832', '2009', '217.51', '0.00', '217.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412385629794451456', '2010', '130.67', '0.00', '130.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412385740184309760', '2011', '4.60', '0.00', '4.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412388135601684480', '2013', '322.47', '0.00', '322.47', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412390681485455360', '2016', '147.00', '0.00', '147.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412391039163142144', '2017', '3.70', '0.00', '3.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412391068045078528', '2018', '79.00', '0.00', '79.00', '1', '79.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412391826312339456', '2019', '4.00', '0.00', '4.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412392874615635968', '2020', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412393065670492160', '2025', '38.00', '0.00', '38.00', '1', '38.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412393850118553600', '2021', '199.00', '0.00', '199.00', '1', '199.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412394107611082752', '2022', '1279.00', '0.00', '1279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412394265753128960', '2026', '399.00', '0.00', '399.00', '1', '399.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412394656007847936', '2023', '5.00', '0.00', '5.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412394997923385344', '2024', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412396273184690176', '2027', '1.01', '0.00', '1.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412396694485762048', '2028', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412396942859853824', '2029', '22.30', '0.00', '22.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412398588524437504', '2031', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412398735383748608', '2030', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412400273883840512', '2032', '4.50', '0.00', '4.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412400585201856512', '2033', '730.14', '0.00', '730.14', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412401823016435712', '2034', '997.67', '0.00', '997.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412403743735095296', '2036', '22.37', '0.00', '22.37', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412404556020748288', '2037', '0.50', '0.00', '0.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412407563559038976', '2038', '7.20', '0.00', '7.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412409209240342528', '2040', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412410337520685056', '2041', '1.90', '0.00', '1.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412411982853857280', '2042', '35.72', '0.00', '35.72', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412416006588149760', '2047', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412417467040579584', '2048', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412419013413335040', '2050', '2255.20', '0.00', '2255.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412419067809259520', '2051', '0.30', '0.00', '0.30', '1', '0.30', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412419386752507904', '2052', '21.80', '0.00', '21.80', '1', '21.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412420716300754944', '2057', '99.00', '0.00', '99.00', '1', '99.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412421057905831936', '2053', '6.60', '0.00', '6.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412421226915344384', '2060', '2.60', '0.00', '2.60', '1', '2.60', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412422261398470656', '2055', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412422747509915648', '2056', '5.90', '0.00', '5.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412422873657798656', '2058', '162.86', '0.00', '162.86', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412424122121723904', '2059', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412424222046846976', '2061', '63.83', '0.00', '63.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412425371617513472', '2062', '7.20', '0.00', '7.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412425695723941888', '2063', '1.10', '0.00', '1.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412426409418301440', '2064', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412426667523203072', '2065', '2.30', '0.00', '2.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412427223306272768', '2066', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412427906390573056', '2068', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412428531257987072', '2067', '2.30', '0.00', '2.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412428738741813248', '2069', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412428836829806592', '2070', '7.00', '0.00', '7.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412429272693547008', '2075', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412431530000797696', '2073', '2.30', '0.00', '2.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412431897795133440', '2074', '0.05', '0.00', '0.05', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412435214562693120', '2077', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412435816168464384', '2078', '948.00', '0.00', '948.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412436807735468032', '2080', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412437257306169344', '2081', '0.15', '0.00', '0.15', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412437824535474176', '2083', '414.68', '0.00', '414.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412437968546836480', '2082', '21.30', '0.00', '21.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412438235120066560', '2084', '19.60', '0.00', '19.60', '1', '19.60', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412439418148667392', '2085', '22.86', '0.00', '22.86', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412442130403696640', '2086', '90.00', '0.00', '90.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412445381706559488', '2087', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412447217922486272', '2088', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412448759085932544', '2089', '9.43', '0.00', '9.43', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412449897432645632', '2090', '105.10', '0.00', '105.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412451431780392960', '2091', '2.80', '0.00', '2.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412452846548430848', '2092', '6.00', '0.00', '6.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412453626768674816', '2093', '15.67', '0.00', '15.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412456161957056512', '2094', '28.40', '0.00', '28.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412456304093573120', '2095', '21.20', '0.00', '21.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412456468518735872', '2096', '22.20', '0.00', '22.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412458500742852608', '2098', '23.90', '0.00', '23.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412458556623593472', '2097', '10.80', '0.00', '10.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412459357374976000', '2099', '3.80', '0.00', '3.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412468978923741184', '2101', '0.50', '0.00', '0.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412470248833220608', '2102', '1.95', '0.00', '1.95', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412474188245143552', '2103', '44.10', '0.00', '44.10', '1', '44.10', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412487482628513792', '2104', '1.90', '0.00', '1.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412487931599433728', '2105', '0.10', '0.00', '0.10', '1', '0.10', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412488922780606464', '2106', '7.50', '0.00', '7.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412510964590465024', '2107', '7.80', '0.00', '7.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412523251300728832', '2109', '16.60', '0.00', '16.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412526054278610944', '2113', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412528848356122624', '2111', '111.05', '0.00', '111.05', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412530453461745664', '2112', '17.00', '0.00', '17.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:56', 'SYS', '2021-09-01 17:54:56', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412534687380996096', '2114', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412542795796848640', '2116', '242.00', '0.00', '242.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412543262052519936', '2115', '0.90', '0.00', '0.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412547024469037056', '2117', '92.99', '0.00', '92.99', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412550565707296768', '2118', '131.66', '0.00', '131.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412556398851674112', '2119', '1.40', '0.00', '1.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412557561693102080', '2120', '98.34', '0.00', '98.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412561231667150848', '2121', '5.75', '0.00', '5.75', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412563815681368064', '2122', '6.15', '0.00', '6.15', '1', '6.15', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412565962267439104', '2123', '60.72', '0.00', '60.72', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412567465308917760', '2124', '21.78', '0.00', '21.78', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412568214667427840', '2125', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412569285569703936', '2126', '5.30', '0.00', '5.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412569626591805440', '2127', '2.60', '0.00', '2.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412569873376280576', '2128', '33.90', '0.00', '33.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412570284912963584', '2129', '17.00', '0.00', '17.00', '1', '17.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412570398658310144', '2130', '402.60', '0.00', '402.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412571223996641280', '2131', '5.20', '0.00', '5.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412573174037651456', '2137', '218.96', '0.00', '218.96', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412573348873027584', '2133', '655.70', '0.00', '655.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412573351783886848', '2132', '381.50', '0.00', '381.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412573603605721088', '2134', '3.50', '0.00', '3.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412575291917877248', '2135', '294.26', '0.00', '294.26', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412577087767851008', '2136', '48.10', '0.00', '48.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412580870040231936', '2138', '6.00', '0.00', '6.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412580905259823104', '2139', '295.80', '0.00', '295.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412581542773047296', '2140', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412582357529178112', '2141', '115.00', '0.00', '115.00', '1', '115.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412584133200367616', '2143', '222.92', '0.00', '222.92', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412585701555474432', '2144', '97.66', '0.00', '97.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412586931820335104', '2146', '2198.33', '0.00', '2198.33', '1', '2198.33', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412587217364340736', '2147', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412588215856160768', '2150', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412588274186338304', '2149', '55.09', '0.00', '55.09', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412588383578021888', '2156', '49.28', '0.00', '49.28', '1', '49.28', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412589452219531264', '2153', '1.90', '0.00', '1.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412589575834095616', '2154', '3.40', '0.00', '3.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412589753123106816', '2155', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412589967032627200', '2160', '134.00', '0.00', '134.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412590666537652224', '2157', '87.70', '0.00', '87.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412591255174651904', '2161', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412592483703095296', '2164', '118.01', '0.00', '118.01', '1', '118.01', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412592633628512256', '2162', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412592775727337472', '2163', '49.28', '0.00', '49.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412593579817324544', '2165', '10.00', '0.00', '10.00', '1', '10.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412593644631941120', '2166', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412594116625334272', '2168', '11.00', '0.00', '11.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412595462518808576', '2169', '17.35', '0.00', '17.35', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412597082279297024', '2170', '2198.33', '0.00', '2198.33', '1', '2198.33', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412597320570310656', '2171', '26.33', '0.00', '26.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412597374278361088', '2172', '93.63', '0.00', '93.63', '1', '93.63', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412597810544656384', '2174', '195.66', '0.00', '195.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412598028006760448', '2173', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412598864367767552', '2176', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412599971919835136', '2177', '3.30', '0.00', '3.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412600162995560448', '2183', '1.00', '0.00', '1.00', '1', '1.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412600626319355904', '2179', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412600642861727744', '2178', '93.63', '0.00', '93.63', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412600850161000448', '2180', '16.50', '0.00', '16.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412601020806234112', '2181', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412601110392393728', '2182', '0.93', '0.00', '0.93', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412601415502852096', '2184', '279.00', '0.00', '279.00', '1', '279.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412602118896001024', '2186', '25.30', '0.00', '25.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412602320130342912', '2187', '29.50', '0.00', '29.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412602838428884992', '2189', '198.00', '0.00', '198.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412603058487214080', '2188', '6.20', '0.00', '6.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412603417070862336', '2190', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412603702736519168', '2191', '1.00', '0.00', '1.00', '1', '1.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412604385695006720', '2195', '69.02', '0.00', '69.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412604554096328704', '2192', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412604635713273856', '2199', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412604906912780288', '2193', '33.50', '0.00', '33.50', '1', '33.50', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412605050408280064', '2194', '68.14', '0.00', '68.14', '1', '68.14', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412605203299053568', '2196', '443.47', '0.00', '443.47', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412605290251198464', '2197', '4.00', '0.00', '4.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412605490680193024', '2201', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412606006399258624', '2202', '29.40', '0.00', '29.40', '1', '29.40', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412607332709494784', '2203', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412607341685321728', '2206', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412608044973572096', '2204', '77.88', '0.00', '77.88', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412608396896694272', '2210', '599.00', '0.00', '599.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412608963903664128', '2207', '22.33', '0.00', '22.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412609036624486400', '2208', '97.30', '0.00', '97.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412609371346718720', '2209', '33.90', '0.00', '33.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412609744329396224', '2211', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412609865943289856', '2212', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412610233376854016', '2213', '149.00', '0.00', '149.00', '1', '149.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412610255724138496', '2214', '58.22', '0.00', '58.22', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412611466112208896', '2216', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412611505270173696', '2215', '5.10', '0.00', '5.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412612396853395456', '2217', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412613917720584192', '2221', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412614214379515904', '2220', '198.00', '0.00', '198.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412614662566117376', '2218', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412615448964538368', '2222', '319.00', '0.00', '319.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412616021675798528', '2223', '67.33', '0.00', '67.33', '1', '67.33', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412616350148468736', '2224', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412617484036636672', '2225', '5.40', '0.00', '5.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412617830440026112', '2227', '229.00', '0.00', '229.00', '1', '229.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412618366824402944', '2228', '4299.00', '0.00', '4299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412618670651355136', '2229', '179.00', '0.00', '179.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412618808564305920', '2230', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412619753377415168', '2231', '33.90', '0.00', '33.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412619991546789888', '2233', '46.80', '0.00', '46.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412621166585262080', '2234', '375.46', '0.00', '375.46', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412621623298797568', '2235', '80.00', '0.00', '80.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412622519625752576', '2236', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412622958945579008', '2237', '16.90', '0.00', '16.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412625276659183616', '2242', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412625317385936896', '2239', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412625377645453312', '2240', '2299.00', '0.00', '2299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412625525415022592', '2241', '6.45', '0.00', '6.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412626665967906816', '2243', '100.00', '0.00', '100.00', '1', '100.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412626902782496768', '2244', '286.74', '0.00', '286.74', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412628214987251712', '2246', '610.79', '0.00', '610.79', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412628298235830272', '2245', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412628802013687808', '2247', '33.90', '0.00', '33.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412629764602224640', '2248', '211.00', '0.00', '211.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412629806016835584', '2251', '100.00', '0.00', '100.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412629940838526976', '2249', '70.84', '0.00', '70.84', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412630071486918656', '2250', '91.60', '0.00', '91.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412630448441573376', '2252', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412630627198644224', '2253', '30.00', '0.00', '30.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412631807077285888', '2254', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412632213186588672', '2256', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412632862389374976', '2258', '207.96', '0.00', '207.96', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412634272195567616', '2260', '9.95', '0.00', '9.95', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412634548864471040', '2259', '26.70', '0.00', '26.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412634750505607168', '2261', '171.04', '0.00', '171.04', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412635530495148032', '2262', '2.01', '0.00', '2.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412635556810252288', '2263', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412636673958944768', '2267', '30.28', '0.00', '30.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412637126893387776', '2264', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412638907979415552', '2266', '16.60', '0.00', '16.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412639296967581696', '2268', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412639616770686976', '2269', '49.00', '0.00', '49.00', '1', '49.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412639874854563840', '2270', '13.90', '0.00', '13.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412640480545611776', '2273', '479.00', '0.00', '479.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412641547811463168', '2274', '30.50', '0.00', '30.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412641658536890368', '2275', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412642349716238336', '2276', '23.80', '0.00', '23.80', '1', '23.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412643376058212352', '2278', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412643609198661632', '2279', '10.00', '0.00', '10.00', '1', '10.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412644615416336384', '2280', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412644860665716736', '2281', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412644941708075008', '2282', '2.90', '0.00', '2.90', '1', '2.90', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412645845035307008', '2284', '3.70', '0.00', '3.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412646876926349312', '2285', '2.30', '1.41', '2.30', '1', '0.89', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412647335913246720', '2290', '32.00', '0.00', '32.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412647994905526272', '2286', '2952.71', '0.00', '2952.71', '1', '2952.71', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412648369196838912', '2287', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412648849633370112', '2298', '12.00', '0.00', '12.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412649054881628160', '2289', '3299.00', '0.00', '3299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412649172217274368', '2294', '7.20', '0.00', '7.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412649327523987456', '2288', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412649535020363776', '2291', '0.20', '0.00', '0.20', '1', '0.20', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:57', 'SYS', '2021-09-01 17:54:57', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412649574849478656', '2295', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412649749479329792', '2293', '196.50', '0.00', '196.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412649755431067648', '2292', '576.00', '0.00', '576.00', '1', '576.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412649977867550720', '2296', '2.41', '0.00', '2.41', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412650081752113152', '2297', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412650418655408128', '2299', '287.05', '0.00', '287.05', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412650466269085696', '2301', '5202.71', '0.00', '5202.71', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412650580316463104', '2300', '101.34', '0.00', '101.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412651338235568128', '2302', '2.90', '0.00', '2.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412651509518368768', '2303', '424.71', '0.00', '424.71', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412651975513935872', '2305', '458.67', '0.00', '458.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412652116392210432', '2306', '3.60', '0.00', '3.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412652436509859840', '2308', '29.40', '0.00', '29.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412652546262212608', '2307', '399.00', '0.00', '399.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412653442744381440', '2309', '67.33', '0.00', '67.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412654011949195264', '2312', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412654099022884864', '2310', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412654977335349248', '2314', '1697.00', '0.00', '1697.00', '1', '1697.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412655450742251520', '2319', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412655795748896768', '2317', '27.04', '0.00', '27.04', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412655843568156672', '2318', '3.70', '0.00', '3.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412656685222375424', '2320', '13.70', '0.00', '13.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412658766457016320', '2322', '13.80', '0.00', '13.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412660513778855936', '2326', '49.39', '0.00', '49.39', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412660695568429056', '2324', '576.00', '0.00', '576.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412660896068689920', '2325', '238.78', '0.00', '238.78', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412662822990704640', '2327', '4.72', '0.00', '4.72', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412663725869121536', '2328', '10.80', '0.00', '10.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412664293614333952', '2329', '149.00', '0.00', '149.00', '1', '149.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412665267867287552', '2330', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412665739827097600', '2336', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412665840477822976', '2331', '13.00', '0.00', '13.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412666071789506560', '2332', '1.50', '0.00', '1.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412666498920632320', '2333', '17.70', '0.00', '17.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412666908515401728', '2335', '7.80', '0.00', '7.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412667704506220544', '2334', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412669354423812096', '2340', '399.00', '0.00', '399.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412669905370767360', '2338', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412670193087422464', '2337', '2526.96', '0.00', '2526.96', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412670702749908992', '2339', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412671355354251264', '2341', '13.90', '0.00', '13.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412671811602280448', '2342', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412672398624485376', '2343', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412672783376343040', '2345', '58.00', '0.00', '58.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412673082774183936', '2344', '11.80', '0.00', '11.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412674014274543616', '2348', '479.00', '0.00', '479.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412674494904020992', '2346', '33.90', '0.00', '33.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412675058140356608', '2347', '1298.34', '0.00', '1298.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412675298700439552', '2349', '1.80', '0.00', '1.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412675652607455232', '2350', '122.12', '0.00', '122.12', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412675986197221376', '2351', '12.00', '0.00', '12.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412676923544461312', '2352', '4079.00', '0.00', '4079.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412679105584959488', '2353', '14.34', '0.00', '14.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412679450998591488', '2354', '45.95', '0.00', '45.95', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412681826727878656', '2357', '10.80', '0.00', '10.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412682395748048896', '2358', '9.07', '0.00', '9.07', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412683270768009216', '2359', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412684276197216256', '2360', '3.30', '0.00', '3.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412684570284937216', '2361', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412684840779890688', '2362', '2.40', '0.00', '2.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412685057717596160', '2363', '16.83', '0.00', '16.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412685972386246656', '2364', '118.00', '0.00', '118.00', '1', '118.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412687689081319424', '2365', '1.40', '0.00', '1.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412689498504097792', '2367', '80.00', '0.00', '80.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412689642268061696', '2366', '4.85', '0.00', '4.85', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412691459932635136', '2370', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412691478035267584', '2368', '499.00', '0.00', '499.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412691697808408576', '2369', '317.21', '0.00', '317.21', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412691936518791168', '2371', '3.05', '0.00', '3.05', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412692237334298624', '2372', '80.00', '0.00', '80.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412692542474088448', '2373', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412693244910985216', '2374', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412698010210742272', '2376', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412698043949711360', '2375', '24.60', '0.00', '24.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412698455096381440', '2377', '556.20', '0.00', '556.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412698711678709760', '2378', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412699025001594880', '2379', '6.15', '0.00', '6.15', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412699986881372160', '2380', '61.20', '0.00', '61.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412700295976435712', '2381', '1.80', '0.00', '1.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412700680044613632', '2383', '79.33', '0.00', '79.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412700824655826944', '2382', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412702361121656832', '2384', '5.60', '0.00', '5.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412703564844937216', '2385', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412704794497478656', '2386', '37.70', '0.00', '37.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412705852560982016', '2387', '574.80', '0.00', '574.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412706002612199424', '2388', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412706279197212672', '2390', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412707150597439488', '2391', '33.30', '0.00', '33.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412708371462815744', '2393', '147.60', '0.00', '147.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412709497738342400', '2394', '116.50', '0.00', '116.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412709792933400576', '2395', '144.33', '0.00', '144.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412709862848253952', '2396', '145.50', '0.00', '145.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412710358354948096', '2397', '4.30', '0.00', '4.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412710840695730176', '2398', '100.00', '0.00', '100.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412711506918961152', '2399', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412711688653942784', '2403', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412711854417043456', '2401', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412712008620666880', '2400', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412712079500197888', '2402', '0.50', '0.00', '0.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412712619713990656', '2404', '12.70', '0.00', '12.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412713413951569920', '2420', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412713475293278208', '2405', '22.20', '0.00', '22.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412713679652331520', '2406', '28.50', '0.00', '28.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412713921894379520', '2407', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412715022299373568', '2408', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412715193800298496', '2411', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412715390005592064', '2412', '80.00', '0.00', '80.00', '1', '80.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412717329476993024', '2413', '18.20', '0.00', '18.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412717794226843648', '2414', '95.00', '0.00', '95.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412718230354743296', '2416', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412718277410623488', '2415', '99.00', '0.00', '99.00', '1', '99.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412718629275004928', '2417', '20.30', '0.00', '20.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412719044620156928', '2419', '864.00', '0.00', '864.00', '1', '864.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412721340473118720', '2422', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412721360870010880', '2423', '23.90', '0.00', '23.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412721781323788288', '2424', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412721990825062400', '2425', '9.40', '0.00', '9.40', '1', '9.40', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412722336934875136', '2426', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412722981247070208', '2427', '75.00', '0.00', '75.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412723436446482432', '2428', '3.60', '0.00', '3.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412724733090426880', '2429', '379.00', '0.00', '379.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412727499988901888', '2431', '2.90', '0.00', '2.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412727519295225856', '2430', '4.90', '0.00', '4.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412728383892320256', '2432', '24.40', '0.00', '24.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412729586852229120', '2433', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412730843956424704', '2436', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412731668170747904', '2435', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412733568261783552', '2437', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412733679784120320', '2438', '1.60', '0.00', '1.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412734195389927424', '2440', '79.00', '0.00', '79.00', '1', '79.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412734301166026752', '2445', '27.00', '0.00', '27.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412734444334411776', '2439', '3.50', '0.00', '3.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412734956467331072', '2442', '116.02', '0.00', '116.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412735035194388480', '2444', '70.68', '0.00', '70.68', '1', '70.68', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412735265860177920', '2443', '36.22', '0.00', '36.22', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412740220297904128', '2446', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412740415123300352', '2448', '46.00', '0.00', '46.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412740852761169920', '2447', '46.45', '0.00', '46.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412741330731483136', '2451', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412741825835524096', '2449', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412742256582180864', '2450', '0.90', '0.00', '0.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412743220747763712', '2453', '5.50', '0.00', '5.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412743366642479104', '2452', '224.00', '0.00', '224.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412743490785431552', '2455', '70.70', '0.00', '70.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412744472202264576', '2454', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412744517005791232', '2456', '6.45', '0.00', '6.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412744864822702080', '2457', '2.60', '0.00', '2.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412745528353198080', '2459', '387.00', '0.00', '387.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412746206471434240', '2460', '150.90', '0.00', '150.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412746768306905088', '2461', '8.40', '0.00', '8.40', '1', '8.40', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412747128597602304', '2462', '241.90', '0.00', '241.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412747183530385408', '2464', '77.06', '0.00', '77.06', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412749215502938112', '2465', '6.08', '0.00', '6.08', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412749609482289152', '2466', '109.00', '0.00', '109.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412750219594121216', '2471', '5.10', '0.00', '5.10', '1', '5.10', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412750599379968000', '2468', '2.40', '0.00', '2.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412750975432871936', '2467', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:58', 'SYS', '2021-09-01 17:54:58', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412751191967981568', '2470', '8380.00', '0.00', '8380.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412751317952299008', '2469', '26.29', '0.00', '26.29', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412751851727835136', '2472', '164.00', '0.00', '164.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412752211183890432', '2474', '165.00', '0.00', '165.00', '1', '165.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412752394609164288', '2473', '130.00', '0.00', '130.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412753098996379648', '2475', '4.80', '0.00', '4.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412753252210159616', '2478', '1.50', '0.00', '1.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412753263815770112', '2477', '29.15', '0.00', '29.15', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412754953323393024', '2485', '45.60', '0.00', '45.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412755434317774848', '2480', '272.93', '0.00', '272.93', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412756084514566144', '2479', '100.80', '0.00', '100.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412756865271644160', '2482', '2.40', '0.00', '2.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412757796415586304', '2483', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412758495027236864', '2484', '46.70', '0.00', '46.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412763353704742912', '2488', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412764442030157824', '2504', '37.80', '0.00', '37.80', '1', '37.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412765191653015552', '2489', '27.20', '0.00', '27.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412765523829243904', '2490', '183.33', '0.00', '183.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412766427521417216', '2493', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412766805579210752', '2492', '140.00', '0.00', '140.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412767200930082816', '2494', '9.03', '0.00', '9.03', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412768013836599296', '2498', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412768185333280768', '2496', '1.60', '0.00', '1.60', '1', '1.60', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412768614582542336', '2497', '62.00', '0.00', '62.00', '1', '62.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412769139436761088', '2499', '6.40', '0.00', '6.40', '1', '6.40', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412769684486590464', '2500', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412770061730684928', '2502', '24.00', '0.00', '24.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412770323010605056', '2503', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412770399594459136', '2505', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412771210995089408', '2506', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412771477970968576', '2507', '1.60', '0.00', '1.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412773008585719808', '2509', '7.00', '0.00', '7.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412773534329147392', '2510', '13.90', '0.00', '13.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412775236897808384', '2512', '5.40', '0.00', '5.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412775415050895360', '2513', '154.97', '0.00', '154.97', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412776752006217728', '2516', '33.90', '0.00', '33.90', '1', '33.90', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412776940296966144', '2517', '570.00', '0.00', '570.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412777499586424832', '2518', '15.80', '0.00', '15.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412778339084742656', '2519', '171.20', '0.00', '171.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412778870301753344', '2522', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412778887787819008', '2520', '149.00', '0.00', '149.00', '1', '149.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412778925876269056', '2521', '38.00', '0.00', '38.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412779698886475776', '2524', '118.34', '0.00', '118.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412779973814755328', '2523', '11.00', '0.00', '11.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412781651343413248', '2525', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412782705288065024', '2526', '229.00', '0.00', '229.00', '1', '229.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412783658867343360', '2527', '3.90', '0.00', '3.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412784386159599616', '2534', '163.45', '0.00', '163.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412784405256265728', '2529', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412784464840552448', '2528', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412785084087631872', '2530', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412786026891632640', '2531', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412787135785926656', '2532', '157.92', '0.00', '157.92', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412796682911072256', '2536', '8.20', '0.00', '8.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412797012939857920', '2537', '38.00', '0.00', '38.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412797481154207744', '2538', '7.72', '0.00', '7.72', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412803256907952128', '2541', '3.30', '0.00', '3.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412803351309119488', '2542', '49992.00', '0.00', '49992.00', '1', '49992.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412804181550669824', '2544', '389.83', '0.00', '389.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412805885738266624', '2545', '235.00', '0.00', '235.00', '1', '235.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412806605506056192', '2546', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412808744668209152', '2547', '2299.00', '0.00', '2299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412813346998284288', '2548', '18.07', '0.00', '18.07', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412822689458114560', '2549', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412825151757836288', '2550', '191.59', '0.00', '191.59', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412825726843052032', '2551', '1.40', '0.00', '1.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412827918702452736', '2552', '1.30', '0.00', '1.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412830423700168704', '2553', '28.30', '0.00', '28.30', '1', '28.30', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412830850512568320', '2557', '399.00', '0.00', '399.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412831109783461888', '2554', '35.20', '0.00', '35.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412831733845524480', '2556', '294.16', '0.00', '294.16', '1', '294.16', '1', 'DSRT', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412846810246123520', '2560', '2.60', '0.00', '2.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412852616286937088', '2561', '71.70', '0.00', '71.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412855168579604480', '2563', '10.30', '0.00', '10.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412863752877080576', '2564', '25.30', '0.00', '25.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412876795199574016', '2566', '39.00', '0.00', '39.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412886810035679232', '2567', '542.34', '0.00', '542.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412894695134281728', '2568', '14.50', '0.00', '14.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412897677313802240', '2569', '174.10', '0.00', '174.10', '1', '174.10', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412899291768500224', '2570', '0.90', '0.00', '0.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412899705561772032', '2571', '76.00', '0.00', '76.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412902918721556480', '2572', '15.60', '0.00', '15.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412911925410586624', '2573', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412921847485509632', '2574', '53.40', '0.00', '53.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412928718619471872', '2575', '234.62', '0.00', '234.62', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412933051146792960', '2576', '7.83', '0.00', '7.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412934471996608512', '2577', '168.74', '0.00', '168.74', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412934686954708992', '2578', '10.25', '0.00', '10.25', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412938612567379968', '2579', '27.11', '0.00', '27.11', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412938706083581952', '2580', '64.11', '0.00', '64.11', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412938711804628992', '2581', '2.75', '0.00', '2.75', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412939685768163328', '2582', '38.00', '0.00', '38.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412940551669600256', '2584', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412940870591954944', '2583', '202.37', '0.00', '202.37', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412942132662206464', '2585', '21.00', '0.00', '21.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412944644735717376', '2586', '26.58', '0.00', '26.58', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412945256596570112', '2587', '174.50', '0.00', '174.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412945460569751552', '2588', '23.90', '0.00', '23.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412946233370279936', '2589', '169.77', '0.00', '169.77', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412947045165252608', '2590', '26.80', '0.00', '26.80', '1', '26.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412947519511707648', '2594', '122.45', '0.00', '122.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412949665942515712', '2591', '647.00', '0.00', '647.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412949770951110656', '2595', '28.90', '0.00', '28.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412949833416925184', '2592', '215.02', '0.00', '215.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412949879780773888', '2593', '21.80', '0.00', '21.80', '1', '21.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412949898126610432', '2598', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412950020386426880', '2597', '81.51', '0.00', '81.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412950420825018368', '2599', '347.17', '0.00', '347.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412950470649139200', '2603', '299.00', '0.00', '299.00', '1', '299.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412950883578368000', '2600', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412951332830244864', '2601', '12.80', '0.00', '12.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412951998663467008', '2602', '118.46', '0.00', '118.46', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412952557130788864', '2605', '478.75', '0.00', '478.75', '1', '478.75', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412954104917045248', '2615', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412954106083090432', '2606', '4.30', '0.00', '4.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412954142342864896', '2607', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412954788370509824', '2608', '256.92', '0.00', '256.92', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412955070978535424', '2609', '48.17', '0.00', '48.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412955224225804288', '2610', '7.20', '0.00', '7.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412955792222662656', '2613', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412956647210565632', '2611', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412956649022513152', '2612', '478.75', '0.00', '478.75', '1', '478.75', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412957146559209472', '2626', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412958394540810240', '2614', '8.61', '0.00', '8.61', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412958927343247360', '2617', '12.00', '0.00', '12.00', '1', '12.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412959119983472640', '2616', '263.50', '0.00', '263.50', '1', '263.50', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412959802405113856', '2618', '160.50', '0.00', '160.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412960278278250496', '2620', '9.50', '0.00', '9.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412960285903482880', '2621', '358.00', '0.00', '358.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412960316891017216', '2619', '63.53', '0.00', '63.53', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412960374818541568', '2622', '199.96', '0.00', '199.96', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412960416266661888', '2635', '527.00', '0.00', '527.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412960929297117184', '2624', '98.17', '0.00', '98.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412961431095291904', '2625', '14.93', '0.00', '14.93', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412962362281111552', '2632', '279.00', '0.00', '279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412962757086756864', '2627', '218.33', '0.00', '218.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412963246369058816', '2628', '347.17', '0.00', '347.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412963282414968832', '2634', '236.00', '0.00', '236.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412963296453304320', '2630', '96.34', '0.00', '96.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412963405798772736', '2629', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:54:59', 'SYS', '2021-09-01 17:54:59', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412963635722170368', '2631', '12.00', '0.00', '12.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412963936030101504', '2633', '27.47', '0.00', '27.47', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412964983108714496', '2636', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412965277393711104', '2637', '101.33', '0.00', '101.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412965731624247296', '2640', '478.00', '0.00', '478.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412965779841921024', '2639', '1.75', '0.00', '1.75', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412966051897069568', '2642', '169.62', '0.00', '169.62', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412966304016728064', '2641', '24.66', '0.00', '24.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412966461814788096', '2647', '72.83', '0.00', '72.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412966726353772544', '2643', '151.06', '0.00', '151.06', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412967530762543104', '2644', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412968209807802368', '2645', '564.50', '0.00', '564.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412968735291142144', '2646', '159.34', '0.00', '159.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412968997846204416', '2649', '149.28', '0.00', '149.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412969295725641728', '2648', '119.48', '0.00', '119.48', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412969326193127424', '2650', '27.00', '0.00', '27.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412969572247740416', '2651', '51.53', '0.00', '51.53', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412969763164090368', '2653', '2.28', '0.00', '2.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412969921490661376', '2657', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412970340602294272', '2654', '43.50', '0.00', '43.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412970357526339584', '2656', '108.17', '0.00', '108.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412970388094406656', '2655', '9.10', '0.00', '9.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412970568449462272', '2659', '36.50', '0.00', '36.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412970585750978560', '2658', '694.34', '0.00', '694.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412970695591428096', '2660', '4.40', '0.00', '4.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412970925212758016', '2662', '418.33', '0.00', '418.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412970974047043584', '2661', '31.20', '0.00', '31.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412971612298485760', '2663', '14.10', '0.00', '14.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412972097596272640', '2666', '4.40', '0.00', '4.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412972476643880960', '2665', '27.56', '0.00', '27.56', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412972679526563840', '2669', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412972684710756352', '2667', '300.25', '0.00', '300.25', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412973097354747904', '2668', '176.95', '0.00', '176.95', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412974499896442880', '2670', '125.29', '0.00', '125.29', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412975558362619904', '2671', '32.08', '0.00', '32.08', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412976612076654592', '2674', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412977915318222848', '2675', '91.00', '0.00', '91.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412978783564308480', '2676', '73.69', '0.00', '73.69', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412980079469965312', '2678', '4.00', '0.00', '4.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412980110272942080', '2677', '21.19', '0.00', '21.19', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412981734588461056', '2679', '4.40', '0.00', '4.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412982817817804800', '2680', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412982990056964096', '2682', '51.99', '0.00', '51.99', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412983010961330176', '2681', '46.45', '0.00', '46.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412983295360331776', '2683', '14.83', '0.00', '14.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412983674361802752', '2685', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412983811918221312', '2689', '203.87', '0.00', '203.87', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412983812824203264', '2684', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412984506478157824', '2686', '56.80', '0.00', '56.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412986398721642496', '2687', '0.70', '0.00', '0.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412986715064418304', '2688', '8.00', '0.00', '8.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412987001694773248', '2691', '5.90', '0.00', '5.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412988075507916800', '2690', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412988834454683648', '2692', '1.70', '0.00', '1.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412990354084560896', '2693', '47.59', '0.00', '47.59', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412991215896571904', '2694', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412992672976830464', '2698', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412992800982810624', '2708', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412992846260285440', '2696', '1148.17', '0.00', '1148.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412993066884841472', '2697', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412993363422134272', '2701', '4299.00', '0.00', '4299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412993531408211968', '2700', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412993781321670656', '2699', '90.53', '0.00', '90.53', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412994060444172288', '2702', '23.90', '0.00', '23.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412994495892660224', '2703', '211.38', '0.00', '211.38', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412994634317225984', '2704', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412995369767460864', '2706', '19.00', '0.00', '19.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412995468061020160', '2707', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412995811197030400', '2709', '110.88', '0.00', '110.88', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412997641117315072', '2710', '4.84', '0.00', '4.84', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1412998773688479744', '2717', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413000410532376576', '2711', '23.83', '0.00', '23.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413000838871494656', '2713', '10.21', '0.00', '10.21', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413001023404060672', '2714', '101.66', '0.00', '101.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413001213523456000', '2716', '10.90', '0.00', '10.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413001401092751360', '2718', '1850.00', '0.00', '1850.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413002023435173888', '2720', '116.69', '0.00', '116.69', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413003333245005824', '2719', '510.40', '0.00', '510.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413004054149378048', '2722', '54.60', '0.00', '54.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413004080355393536', '2721', '7.33', '0.00', '7.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413004846096932864', '2723', '248.51', '0.00', '248.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413005017321000960', '2724', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413006846050140160', '2726', '139.19', '0.00', '139.19', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413006996428517376', '2727', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413007285453815808', '2728', '132.00', '0.00', '132.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413008065598558208', '2729', '188.02', '0.00', '188.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413008376438415360', '2730', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413008852567392256', '2731', '260.68', '0.00', '260.68', '1', '260.68', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413009498016268288', '2734', '134.25', '0.00', '134.25', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413009584947417088', '2735', '565.00', '0.00', '565.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413009878854848512', '2737', '20.98', '0.00', '20.98', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413009997729849344', '2739', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413011002584428544', '2738', '132.86', '0.00', '132.86', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413011347070980096', '2740', '173.16', '0.00', '173.16', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413011768925691904', '2741', '3.00', '0.00', '3.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413013559969017856', '2742', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413014899638120448', '2746', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413015038310182912', '2743', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413015058593837056', '2744', '6.10', '0.00', '6.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413015093310070784', '2750', '192.00', '0.00', '192.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413015435212963840', '2745', '260.68', '0.00', '260.68', '1', '260.68', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413015790264979456', '2751', '260.68', '0.00', '260.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413016215739371520', '2752', '399.00', '0.00', '399.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413016309104586752', '2748', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413016851461677056', '2749', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413018845463109632', '2753', '25.20', '0.00', '25.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413019061759160320', '2754', '11.11', '0.00', '11.11', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413019175680708608', '2755', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413019595278872576', '2756', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413020751879151616', '2758', '1.10', '0.00', '1.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413021590626713600', '2759', '7.00', '0.00', '7.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413023308961759232', '2760', '141.31', '0.00', '141.31', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413024765035384832', '2761', '88.54', '0.00', '88.54', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413024867141517312', '2762', '58.08', '0.00', '58.08', '1', '58.08', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413025594366738432', '2766', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413025759349686272', '2765', '176.80', '0.00', '176.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413026862585835520', '2769', '91.00', '0.00', '91.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413027335959175168', '2767', '44.10', '0.00', '44.10', '1', '44.10', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413028321511567360', '2768', '58.08', '0.00', '58.08', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413030887125311488', '2770', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413031460348280832', '2771', '298.00', '0.00', '298.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413031469974167552', '2772', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413031732298522624', '2775', '4.32', '0.00', '4.32', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413032364308824064', '2773', '309.33', '0.00', '309.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413033158772932608', '2776', '7.50', '0.00', '7.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413034182074105856', '2778', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413034446105481216', '2779', '22.50', '0.00', '22.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413035042292277248', '2780', '33.90', '0.00', '33.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413035468001632256', '2782', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413035667977654272', '2781', '65.11', '0.00', '65.11', '1', '65.11', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413036094429261824', '2783', '29.20', '0.00', '29.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413036182358618112', '2784', '14.30', '0.00', '14.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413036363523186688', '2785', '0.30', '0.12', '0.30', '1', '0.18', '3', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413036819993579520', '2786', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413037919391895552', '2787', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413037931182067712', '2788', '4.57', '0.00', '4.57', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413038232458891264', '2789', '78.00', '0.00', '78.00', '1', '78.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413038274347433984', '2790', '5.50', '0.00', '5.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413038881531682816', '2791', '61.83', '0.00', '61.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413039325985247232', '2792', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413039667741339648', '2801', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413040358996193280', '2793', '24.00', '0.00', '24.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413040485374771200', '2794', '65.11', '0.00', '65.11', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413040857967398912', '2795', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413041184661737472', '2796', '264.20', '0.00', '264.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413041702565978112', '2799', '2.10', '0.00', '2.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413041736116256768', '2797', '92.67', '0.00', '92.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413041992715337728', '2798', '24.40', '0.00', '24.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413042809182756864', '2802', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413044251029397504', '2803', '81.17', '0.00', '81.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413044363356995584', '2806', '8.90', '0.00', '8.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413044625891028992', '2805', '7.00', '0.00', '7.00', '1', '7.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413044985552601088', '2807', '289.37', '0.00', '289.37', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413045100216487936', '2808', '46.50', '0.00', '46.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413045781484699648', '2814', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413045918776860672', '2809', '27.67', '0.00', '27.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413048007993221120', '2812', '13.80', '0.00', '13.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413048680512110592', '2810', '479.00', '0.00', '479.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:00', 'SYS', '2021-09-01 17:55:00', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413048702091825152', '2811', '399.00', '0.00', '399.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413049340393619456', '2813', '115.00', '0.00', '115.00', '1', '115.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413049644753289216', '2816', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413049948425052160', '2815', '9.60', '0.00', '9.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413050650958368768', '2817', '20.70', '0.00', '20.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413051114965835776', '2818', '44.04', '0.00', '44.04', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413051565379670016', '2819', '197.11', '0.00', '197.11', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413051663014604800', '2820', '98.34', '0.00', '98.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413051962525642752', '2821', '0.90', '0.00', '0.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413052032943812608', '2822', '79.26', '0.00', '79.26', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413052417683120128', '2824', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413052453569585152', '2823', '38.60', '0.00', '38.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413053763165515776', '2825', '89.00', '0.00', '89.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413054272559562752', '2826', '103.74', '0.00', '103.74', '1', '103.74', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413054748663410688', '2827', '596.00', '0.00', '596.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413055084069302272', '2829', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413055147826888704', '2828', '65.67', '0.00', '65.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413055899458781184', '2830', '103.74', '0.00', '103.74', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413056804488888320', '2838', '43.00', '0.00', '43.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413057051491495936', '2836', '840.37', '0.00', '840.37', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413057074606309376', '2833', '2.28', '0.00', '2.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413057684445487104', '2832', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413058325796499456', '2837', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413058368062607360', '2835', '724.03', '0.00', '724.03', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413058414896132096', '2834', '2.80', '0.00', '2.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413059975621775360', '2839', '314.17', '0.00', '314.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413060159168737280', '2840', '562.00', '0.00', '562.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413061366444634112', '2841', '12.34', '0.00', '12.34', '1', '12.34', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413061393875361792', '2844', '0.80', '0.00', '0.80', '1', '0.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413061800613896192', '2843', '257.99', '0.00', '257.99', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413061866573455360', '2845', '1.60', '0.00', '1.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413062382779015168', '2846', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413062708810670080', '2848', '196.00', '0.00', '196.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413062815476011008', '2847', '12.34', '0.00', '12.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413063019784708096', '2849', '66.00', '0.00', '66.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413063358214742016', '2855', '29.67', '0.00', '29.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413063539949748224', '2850', '44.10', '0.00', '44.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413063967881957376', '2851', '359.04', '0.00', '359.04', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413064509928652800', '2852', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413065130153070592', '2854', '1.20', '0.00', '1.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413065482248003584', '2856', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413066152086769664', '2857', '295.40', '0.00', '295.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413068106162679808', '2858', '196.50', '0.00', '196.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413069486554337280', '2860', '20.00', '0.00', '20.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413069509203488768', '2859', '304.80', '0.00', '304.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413069771876007936', '2861', '5.20', '0.00', '5.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413069790297325568', '2863', '164.83', '0.00', '164.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413070831780802560', '2864', '31.53', '0.00', '31.53', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413072423473037312', '2865', '2.10', '0.00', '2.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413073172131135488', '2867', '0.90', '0.00', '0.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413073333666357248', '2868', '511.90', '0.00', '511.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413074201820160000', '2869', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413075417384005632', '2871', '305.60', '0.00', '305.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413075527878762496', '2870', '47.60', '0.00', '47.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413076112225067008', '2873', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413076291460194304', '2872', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413077805893341184', '2874', '44.96', '0.00', '44.96', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413078107434504192', '2875', '33.90', '0.00', '33.90', '1', '33.90', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413078667277500416', '2885', '7.00', '0.00', '7.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413079404107702272', '2877', '464.87', '0.00', '464.87', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413079506163507200', '2876', '31.99', '0.00', '31.99', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413080532333617152', '2878', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413081554682511360', '2879', '88.83', '0.00', '88.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413081976449150976', '2880', '31.33', '0.00', '31.33', '1', '31.33', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413082710569836544', '2881', '297.01', '0.00', '297.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413082857026514944', '2883', '12.40', '0.00', '12.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413084960310603776', '2887', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413085865483370496', '2898', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413086378153095168', '2888', '30.70', '0.00', '30.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413086805577945088', '2889', '1.40', '0.00', '1.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413087167021985792', '2890', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413087216418353152', '2891', '12.00', '0.00', '12.00', '1', '12.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413087628005371904', '2892', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413087674104963072', '2893', '31.18', '0.00', '31.18', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413088335911600128', '2894', '8.90', '0.00', '8.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413089383137083392', '2895', '54.60', '0.00', '54.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413090091643105280', '2896', '26.79', '0.00', '26.79', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413091182023704576', '2897', '75.50', '0.00', '75.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413091314261745664', '2899', '17.46', '0.00', '17.46', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413092349160128512', '2900', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413092910832017408', '2901', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413092929936961536', '2902', '64.83', '0.00', '64.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413093626740875264', '2903', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413094296487383040', '2917', '188.20', '0.00', '188.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413094372781760512', '2904', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413094542613295104', '2905', '20.70', '0.00', '20.70', '1', '20.70', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413095084286713856', '2911', '66.67', '0.00', '66.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413095479050407936', '2906', '198.33', '0.00', '198.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413096165465042944', '2907', '579.00', '0.00', '579.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413096922616586240', '2909', '7.40', '0.00', '7.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413098881960521728', '2912', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413099363231784960', '2913', '38.00', '0.00', '38.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413099564575215616', '2914', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413099760906391552', '2915', '4.64', '0.00', '4.64', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413102230294429696', '2919', '6.30', '0.00', '6.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413102285978005504', '2920', '164.00', '0.00', '164.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413102759649136640', '2921', '1.40', '0.00', '1.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413102823427735552', '2923', '219.00', '0.00', '219.00', '1', '219.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413103494730297344', '2924', '13.83', '0.00', '13.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413103639123439616', '2925', '2.50', '0.00', '2.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413103640545308672', '2926', '27.34', '0.00', '27.34', '1', '27.34', '2', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413103660602458112', '2927', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413104763461120000', '2929', '8380.00', '0.00', '8380.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413104843601694720', '2928', '7.70', '0.00', '7.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413105054310965248', '2930', '46.51', '0.00', '46.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413105897487712256', '2932', '3762.00', '0.00', '3762.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413105999421890560', '2933', '355.46', '0.00', '355.46', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413106826219847680', '2934', '28.40', '0.00', '28.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413107963585048576', '2935', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413109240322822144', '2937', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413109271008321536', '2936', '27.34', '0.00', '27.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413111319565111296', '2938', '3453.71', '0.00', '3453.71', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413111786005200896', '2939', '9.33', '0.00', '9.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413114845347397632', '2941', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413115264442171392', '2945', '88.85', '0.00', '88.85', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413116673296314368', '2943', '379.00', '0.00', '379.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413116913416089600', '2942', '6.90', '0.00', '6.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413118125469294592', '2944', '77.00', '0.00', '77.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413119672634777600', '2946', '439.17', '0.00', '439.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413120006568521728', '2957', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413120354091765760', '2948', '31.66', '0.00', '31.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413120475797856256', '2950', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413121151470878720', '2949', '219.00', '0.00', '219.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413121996241465344', '2951', '12.59', '0.00', '12.59', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413122067154546688', '2953', '5434.00', '0.00', '5434.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413122207957372928', '2952', '12.00', '0.00', '12.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413122972683812864', '2955', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413123016040353792', '2954', '6704.00', '0.00', '6704.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413123402683899904', '2959', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413124918941450240', '2958', '5.40', '0.00', '5.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413126852737896448', '2960', '20.40', '0.00', '20.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413128411794255872', '2961', '843.34', '0.00', '843.34', '1', '843.34', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413129932799959040', '2962', '55.00', '0.00', '55.00', '1', '55.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413131004088143872', '2963', '7.00', '0.00', '7.00', '1', '7.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413131297156718592', '2964', '43.59', '0.00', '43.59', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413132654206914560', '2967', '4.10', '0.00', '4.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413133080599973888', '2969', '1676.00', '0.00', '1676.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413133104847228928', '2968', '22.30', '0.00', '22.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413134589446303744', '2971', '299.00', '0.00', '299.00', '1', '299.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413134851820986368', '2970', '164.36', '0.00', '164.36', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413135891010101248', '2972', '25.30', '0.00', '25.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413136435107729408', '2973', '2.20', '0.00', '2.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413137121476304896', '2975', '4180.00', '0.00', '4180.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413138397345837056', '2976', '28.50', '0.00', '28.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413138442887593984', '2977', '10.60', '0.00', '10.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413138880500215808', '2978', '17.70', '0.00', '17.70', '1', '17.70', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413140680716525568', '2979', '49.00', '0.00', '49.00', '1', '49.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413142021098659840', '2980', '29.66', '0.00', '29.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413142042632241152', '2981', '12.42', '0.00', '12.42', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413142288565260288', '2982', '765.00', '0.00', '765.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413143223144153088', '2983', '10.60', '0.00', '10.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413143758316494848', '2984', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413143991024861184', '2986', '7.20', '0.00', '7.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413144346471108608', '2987', '0.98', '0.00', '0.98', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413145224724848640', '2988', '5.10', '0.00', '5.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413145227757228032', '2989', '6.20', '0.00', '6.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413145539813564416', '2990', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413145866570805248', '2991', '177.60', '0.00', '177.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413146423939174400', '2992', '114.12', '0.00', '114.12', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413146778613780480', '2993', '3.70', '0.00', '3.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:01', 'SYS', '2021-09-01 17:55:01', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413147063306371072', '2995', '6.70', '0.00', '6.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413148524278910976', '2996', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413150118131236864', '2997', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413150181045706752', '2998', '209.00', '0.00', '209.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413150824150024192', '2999', '47.80', '0.00', '47.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413150969927172096', '3000', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413151213138206720', '3001', '6.50', '0.00', '6.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413151989327683584', '3003', '4.70', '0.00', '4.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413152160551763968', '3004', '46.70', '0.00', '46.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413153206883713024', '3007', '15.70', '0.00', '15.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413153311787565056', '3006', '180.20', '0.00', '180.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413153740621590528', '3013', '86.90', '0.00', '86.90', '1', '86.90', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413154425312354304', '3009', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413154612457979904', '3008', '10.80', '0.00', '10.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413154814459785216', '3011', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413154996047982592', '3010', '5.00', '0.00', '5.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413156305308454912', '3012', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413157401468829696', '3016', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413157639550021632', '3015', '499.00', '0.00', '499.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413157738229485568', '3018', '13.76', '0.00', '13.76', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413158400728174592', '3017', '27.50', '0.00', '27.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413162937253851136', '3019', '890.00', '0.00', '890.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413165028877783040', '3020', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413167388773453824', '3021', '11.40', '0.00', '11.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413172124012646400', '3022', '104.00', '0.00', '104.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413177782527275008', '3023', '13.00', '0.00', '13.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413179152089088000', '3024', '597.00', '0.00', '597.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413182577342373888', '3025', '33.90', '0.00', '33.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413184273648848896', '3026', '30.00', '0.00', '30.00', '1', '30.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413200876528709632', '3027', '33.90', '0.00', '33.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413213111481233408', '3028', '69.40', '0.00', '69.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413249462867984384', '3029', '27.50', '0.00', '27.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413250839874772992', '3030', '55.60', '0.00', '55.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413263147741085696', '3031', '54.30', '0.00', '54.30', '1', '54.30', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413275521168576512', '3033', '11.50', '0.00', '11.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413283551524364288', '3034', '554.00', '0.00', '554.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413287912015097856', '3037', '60.90', '0.00', '60.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413288834581643264', '3036', '42.90', '0.00', '42.90', '1', '42.90', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413296364045160448', '3040', '11732.00', '0.00', '11732.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413300920581824512', '3041', '20.80', '0.00', '20.80', '1', '20.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413309300201365504', '3044', '39.80', '0.00', '39.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413312620571865088', '3061', '31.83', '0.00', '31.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413313474691588096', '3052', '312.58', '0.00', '312.58', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413317496664174592', '3053', '434.32', '0.00', '434.32', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413318196844539904', '3051', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413318300636680192', '3055', '0.67', '0.00', '0.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413318305946738688', '3056', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413318434263121920', '3054', '217.92', '0.00', '217.92', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413318814350848000', '3057', '182.44', '0.00', '182.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413319143444328448', '3063', '143.34', '0.00', '143.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413319184015826944', '3064', '100.00', '0.00', '100.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413319431618244608', '3067', '230.60', '0.00', '230.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413319466535845888', '3059', '482.34', '0.00', '482.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413319540703731712', '3060', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413319848829865984', '3062', '42.53', '0.00', '42.53', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413319942236938240', '3065', '14.17', '0.00', '14.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413320020334985216', '3066', '57.00', '0.00', '57.00', '1', '57.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413320067663466496', '3068', '81.50', '0.00', '81.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413320412695326720', '3071', '21.34', '0.00', '21.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413320647911882752', '3080', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413320787166998528', '3073', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413320884533473280', '3075', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413321886984810496', '3078', '17.00', '0.00', '17.00', '1', '17.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413321982522667008', '3079', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413322463642894336', '3090', '399.00', '0.00', '399.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413322748792639488', '3082', '168.89', '0.00', '168.89', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413323236510494720', '3084', '4.50', '0.00', '4.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413323289375420416', '3094', '148.00', '0.00', '148.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413323365330071552', '3089', '75.77', '0.00', '75.77', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413323441599365120', '3085', '97.00', '0.00', '97.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413323618145935360', '3086', '83.10', '0.00', '83.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413323888074563584', '3087', '101.33', '0.00', '101.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413323951035363328', '3088', '2.10', '0.00', '2.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413324195898720256', '3092', '6.50', '0.00', '6.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413324241318842368', '3091', '150.67', '0.00', '150.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413324671906099200', '3093', '536.27', '0.00', '536.27', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413324866060419072', '3095', '9.60', '0.00', '9.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413325623602077696', '3096', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413325930469961728', '3098', '385.92', '0.00', '385.92', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413326588568842240', '3099', '170.70', '0.00', '170.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413328303737176064', '3101', '68.10', '0.00', '68.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413328526035292160', '3102', '298.00', '0.00', '298.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413328670793285632', '3105', '61.26', '0.00', '61.26', '1', '61.26', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413329007977619456', '3103', '2.30', '0.00', '2.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413329117159542784', '3104', '9.99', '0.00', '9.99', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413329463235772416', '3106', '298.00', '0.00', '298.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413329530277519360', '3107', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413329779075207168', '3108', '2638.00', '0.00', '2638.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413329822444367872', '3112', '145.60', '0.00', '145.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413330139172999168', '3114', '130.87', '0.00', '130.87', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413330313962266624', '3110', '47.10', '0.00', '47.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413330536906268672', '3113', '97.34', '0.00', '97.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413331096204136448', '3115', '33.90', '0.00', '33.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413331143167791104', '3117', '48.33', '0.00', '48.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413331176088834048', '3116', '202.73', '0.00', '202.73', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413331511868051456', '3120', '182.44', '0.00', '182.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413331749873836032', '3121', '22.40', '0.00', '22.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413331817930604544', '3119', '17.82', '0.00', '17.82', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413332052702556160', '3122', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413332212211961856', '3123', '196.17', '0.00', '196.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413333261878456320', '3130', '188.50', '0.00', '188.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413334090765213696', '3125', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413334372953796608', '3129', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413334830762082304', '3126', '173.00', '0.00', '173.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413335197621096448', '3127', '2.20', '0.00', '2.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413335659581693952', '3128', '129.66', '0.00', '129.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413336338798891008', '3131', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413336463344615424', '3132', '32.50', '0.00', '32.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413336563445858304', '3133', '114.37', '0.00', '114.37', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413336682115284992', '3134', '10.15', '0.00', '10.15', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413337617881305088', '3136', '11.50', '0.00', '11.50', '1', '11.50', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413337997839060992', '3138', '122.87', '0.00', '122.87', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413338042089000960', '3137', '61.26', '0.00', '61.26', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413338246620020736', '3140', '49.00', '0.00', '49.00', '1', '49.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413338387661881344', '3139', '3.37', '0.00', '3.37', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413338505626693632', '3141', '131.00', '0.00', '131.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413338966001868800', '3144', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413339084096724992', '3142', '12.50', '0.00', '12.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413339268453158912', '3148', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413339519507406848', '3146', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413339724520820736', '3145', '30.33', '0.00', '30.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413339802568400896', '3149', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413340477645840384', '3150', '39.28', '0.00', '39.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413340509010808832', '3151', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413340770844446720', '3152', '11.50', '0.00', '11.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413341612410564608', '3154', '203.66', '0.00', '203.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413341736331304960', '3156', '80.60', '0.00', '80.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413341848608591872', '3155', '53.40', '0.00', '53.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413341972609019904', '3171', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413341973292695552', '3158', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413342294689648640', '3157', '33.80', '0.00', '33.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413343650594897920', '3160', '443.67', '0.00', '443.67', '1', '443.67', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413343718538366976', '3161', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413343765300711424', '3162', '499.00', '0.00', '499.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413344000303321088', '3163', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413344561501196288', '3164', '22.52', '0.00', '22.52', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413345129208664064', '3165', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413345476367011840', '3167', '45.34', '0.00', '45.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413345531425615872', '3166', '22.52', '0.00', '22.52', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413345545614966784', '3170', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413345913585418240', '3168', '242.61', '0.00', '242.61', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413345974507720704', '3169', '20.32', '0.00', '20.32', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413346209741037568', '3172', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413346292742172672', '3173', '2.66', '0.00', '2.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413346711941873664', '3174', '6.70', '0.00', '6.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413347255695654912', '3175', '146.26', '0.00', '146.26', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413347306127966208', '3176', '10.01', '0.00', '10.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:02', 'SYS', '2021-09-01 17:55:02', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413347509379710976', '3177', '27.60', '0.00', '27.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413347861474783232', '3179', '197.00', '0.00', '197.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413348462635958272', '3180', '2.41', '0.00', '2.41', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413348704609517568', '3181', '48.17', '0.00', '48.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413350141309644800', '3184', '142.67', '0.00', '142.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413350190861197312', '3186', '4.70', '0.00', '4.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413350198478061568', '3183', '10.43', '0.00', '10.43', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413351153588166656', '3191', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413351234085273600', '3187', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413351458153365504', '3188', '3.80', '0.00', '3.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413351549740158976', '3190', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413351577477107712', '3189', '132.00', '0.00', '132.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413352783947644928', '3193', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413353391912034304', '3201', '91.50', '0.00', '91.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413353457724903424', '3194', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413353542860865536', '3195', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413353846994010112', '3196', '10.01', '0.00', '10.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413353908239220736', '3198', '4.44', '0.00', '4.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413353960055689216', '3197', '64.78', '0.00', '64.78', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413354334816722944', '3202', '3.60', '0.00', '3.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413354680939069440', '3204', '189.34', '0.00', '189.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413354913257422848', '3212', '392.09', '0.00', '392.09', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413355616319238144', '3215', '63.50', '0.00', '63.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413356220252884992', '3205', '98.82', '0.00', '98.82', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413356672805687296', '3206', '89.17', '0.00', '89.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413356837406986240', '3207', '151.67', '0.00', '151.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413357324147560448', '3208', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413357352220020736', '3209', '30.90', '0.00', '30.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413357397107494912', '3210', '178.66', '0.00', '178.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413358324698767360', '3213', '364.00', '0.00', '364.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413358430403608576', '3214', '199.00', '0.00', '199.00', '1', '199.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413360403966234624', '3220', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413360509314613248', '3218', '478.70', '0.00', '478.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413360838806491136', '3216', '76.20', '0.00', '76.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413361083774865408', '3217', '93.44', '0.00', '93.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413362412404514816', '3221', '286.99', '0.00', '286.99', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413362781281005568', '3222', '70.55', '0.00', '70.55', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413363611925155840', '3223', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413363872227835904', '3227', '268.65', '0.00', '268.65', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413364339167154176', '3225', '14.20', '0.00', '14.20', '1', '14.20', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413364689815109632', '3238', '91.00', '0.00', '91.00', '1', '91.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413365521738555392', '3228', '63.07', '0.00', '63.07', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413365571483029504', '3229', '87.89', '0.00', '87.89', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413365829474603008', '3230', '68.90', '0.00', '68.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413366292022480896', '3241', '171.00', '0.00', '171.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413366779585175552', '3231', '42.16', '0.00', '42.16', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413367324018401280', '3233', '11.70', '0.00', '11.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413367741339045888', '3234', '533.66', '0.00', '533.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413368122064408576', '3235', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413368201298997248', '3236', '89.92', '0.00', '89.92', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413368820021751808', '3237', '30.33', '0.00', '30.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413369108040445952', '3245', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413369189003096064', '3248', '5.90', '0.00', '5.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413369937011101696', '3239', '3.40', '0.00', '3.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413369939154378752', '3240', '97.00', '0.00', '97.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413370096956653568', '3253', '91.00', '0.00', '91.00', '1', '91.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413370885095710720', '3246', '78.68', '0.00', '78.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413370986828611584', '3243', '15.20', '0.00', '15.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413371133180399616', '3244', '6.60', '0.00', '6.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413371368371810304', '3268', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413372002533842944', '3249', '1.28', '0.00', '1.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413372703838257152', '3252', '23.18', '0.00', '23.18', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413372707013300224', '3250', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413372951885185024', '3251', '0.63', '0.00', '0.63', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413372973519392768', '3254', '131.83', '0.00', '131.83', '1', '131.83', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413373408061898752', '3255', '7.00', '0.00', '7.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413373447547011072', '3256', '22.90', '0.00', '22.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413373912326225920', '3257', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413374121542356992', '3259', '210.54', '0.00', '210.54', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413374131944206336', '3258', '330.52', '0.00', '330.52', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413374286521102336', '3262', '53.87', '0.00', '53.87', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413374466825867264', '3260', '41.11', '0.00', '41.11', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413374511352537088', '3261', '753.45', '0.00', '753.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413374696438833152', '3265', '50.51', '0.00', '50.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413375186069241856', '3273', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413375453770760192', '3266', '4.00', '0.00', '4.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413375500872761344', '3264', '248.49', '0.00', '248.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413375632838152192', '3263', '0.43', '0.00', '0.43', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413375932022026240', '3271', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413375942310690816', '3269', '340.22', '0.00', '340.22', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413376282653286400', '3274', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413376356879876096', '3267', '193.49', '0.00', '193.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413376738913853440', '3270', '48.17', '0.00', '48.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413377033987371008', '3272', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413377438318243840', '3276', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413377920193441792', '3275', '2.20', '0.00', '2.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413378706042429440', '3277', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413378948460617728', '3279', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413379857424990208', '3280', '17.00', '0.00', '17.00', '1', '17.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413379919005806592', '3281', '4099.00', '0.00', '4099.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413380490412580864', '3283', '12.83', '0.00', '12.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413380519978266624', '3284', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413380727717924864', '3285', '174.68', '0.00', '174.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413382180654194688', '3288', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413382496632094720', '3286', '69.11', '0.00', '69.11', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413382572523823104', '3287', '334.60', '0.00', '334.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413382792225636352', '3296', '49.00', '0.00', '49.00', '1', '49.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413382887453134848', '3289', '14.51', '0.00', '14.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413382943497420800', '3290', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413383499787956224', '3293', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413384025929830400', '3292', '383.62', '0.00', '383.62', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413384081315659776', '3291', '329.83', '0.00', '329.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413384496925016064', '3294', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413384562687504384', '3295', '0.90', '0.00', '0.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413384702794084352', '3297', '345.75', '0.00', '345.75', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413384799938322432', '3300', '0.35', '0.00', '0.35', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413384828140859392', '3298', '3.00', '0.00', '3.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413384829663342592', '3299', '65.00', '0.00', '65.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413384994214297600', '3301', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413385193649295360', '3304', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413385261680836608', '3305', '330.31', '0.00', '330.31', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413385269415186432', '3302', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413385310812962816', '3303', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413385802586701824', '3306', '2.10', '0.00', '2.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413386439588261888', '3307', '122.90', '0.00', '122.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413386516008435712', '3310', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413386729850847232', '3308', '124.11', '0.00', '124.11', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413387499312672768', '3311', '152.80', '0.00', '152.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413387542501433344', '3312', '155.17', '0.00', '155.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413387548134379520', '3309', '21.37', '0.00', '21.37', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413388596374839296', '3313', '850.00', '0.00', '850.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413389603825709056', '3316', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413389927432994816', '3319', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413390027039330304', '3320', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413390189094678528', '3317', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413390420913831936', '3318', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413390740968603648', '3321', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413391272760221696', '3325', '499.00', '0.00', '499.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413391334257115136', '3324', '294.60', '0.00', '294.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413391524372312064', '3326', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413391847405035520', '3328', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413392070307164160', '3327', '1211.00', '0.00', '1211.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413393639962521600', '3330', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413395123991113728', '3333', '46.50', '0.00', '46.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413395137668751360', '3337', '26.55', '0.00', '26.55', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413395239946874880', '3336', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413395293269082112', '3334', '313.77', '0.00', '313.77', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413395334910107648', '3335', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413395817531854848', '3338', '32.90', '0.00', '32.90', '1', '32.90', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413396068590354432', '3340', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413396071908040704', '3341', '499.00', '0.00', '499.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413396160021958656', '3339', '1194.00', '0.00', '1194.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413397272586276864', '3343', '412.66', '0.00', '412.66', '1', '412.66', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413398439793983488', '3344', '742.48', '0.00', '742.48', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413398599735369728', '3345', '17.45', '0.00', '17.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413398800868990976', '3346', '27.49', '0.00', '27.49', '1', '27.49', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413398801288482816', '3350', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413398823384064000', '3347', '1.70', '0.00', '1.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413399011741839360', '3348', '21.87', '0.00', '21.87', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413399012937224192', '3349', '30.33', '0.00', '30.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413399345293836288', '3352', '48.00', '10.65', '48.00', '1', '37.35', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413399730331009024', '3353', '45.56', '0.00', '45.56', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413399842172125184', '3354', '4.10', '0.00', '4.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413400002109259776', '3355', '39.94', '0.00', '39.94', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413400154710659072', '3356', '12.46', '0.00', '12.46', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413400334944083968', '3357', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413400760443645952', '3358', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413400974344781824', '3360', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:03', 'SYS', '2021-09-01 17:55:03', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413401694032789504', '3362', '147.10', '0.00', '147.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413402967578705920', '3364', '51.60', '0.00', '51.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413403214807736320', '3365', '2.21', '0.00', '2.21', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413403411201822720', '3366', '2.00', '0.00', '2.00', '1', '2.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413405324488130560', '3368', '3.20', '0.00', '3.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413405529774141440', '3369', '102.22', '0.00', '102.22', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413405688121712640', '3370', '1.50', '0.00', '1.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413406029735170048', '3374', '298.00', '0.00', '298.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413406191882768384', '3372', '1.20', '0.00', '1.20', '1', '1.20', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413406202355961856', '3371', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413406461580718080', '3375', '1199.00', '0.00', '1199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413406659732197376', '3373', '170.03', '0.00', '170.03', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413406694075224064', '3376', '79.60', '0.00', '79.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413406789403316224', '3378', '495.00', '0.00', '495.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413406948572950528', '3377', '0.80', '0.00', '0.80', '1', '0.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413407036611420160', '3379', '206.84', '0.00', '206.84', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413407928907644928', '3383', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413407995441893376', '3380', '94.46', '0.00', '94.46', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413408118267912192', '3382', '7.80', '0.00', '7.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413408858495418368', '3384', '89.63', '0.00', '89.63', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413409312767901696', '3386', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413409337208127488', '3387', '53.41', '0.00', '53.41', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413409435124170752', '3385', '307.40', '0.00', '307.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413409717639909376', '3388', '148.50', '0.00', '148.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413409924322590720', '3390', '1915.66', '0.00', '1915.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413410044543963136', '3391', '22.89', '0.00', '22.89', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413410236399800320', '3394', '47.62', '0.00', '47.62', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413410250509451264', '3396', '71.00', '0.00', '71.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413410710368718848', '3393', '249.00', '0.00', '249.00', '1', '249.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413411444602617856', '3395', '9.30', '0.00', '9.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413411684214792192', '3397', '27.70', '0.00', '27.70', '1', '27.70', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413412705083273216', '3399', '16.00', '0.00', '16.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413412843222614016', '3398', '499.00', '0.00', '499.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413413065990520832', '3405', '399.00', '0.00', '399.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413413631667920896', '3401', '1.50', '0.00', '1.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413413660566659072', '3404', '379.00', '0.00', '379.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413414702154924032', '3403', '19.70', '0.00', '19.70', '1', '19.70', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413414918916587520', '3408', '229.00', '0.00', '229.00', '1', '229.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413415054128340992', '3406', '249.76', '0.00', '249.76', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413415272852942848', '3407', '82.25', '0.00', '82.25', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413415501916495872', '3409', '83.59', '0.00', '83.59', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413415641930702848', '3410', '1.50', '0.00', '1.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413416189136388096', '3411', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413416611414777856', '3443', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413417144577900544', '3416', '179.00', '0.00', '179.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413417630332805120', '3413', '12.00', '0.00', '12.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413417755776081920', '3414', '38.14', '0.00', '38.14', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413418460138147840', '3434', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413418913827586048', '3418', '25.27', '0.00', '25.27', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413419034434768896', '3419', '18.47', '0.00', '18.47', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413419132816441344', '3422', '47.00', '0.00', '47.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413419301255499776', '3421', '679.00', '0.00', '679.00', '1', '679.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413419670513553408', '3423', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413420407805165568', '3424', '45.83', '0.00', '45.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413420541108445184', '3442', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413420559961878528', '3425', '37.70', '0.00', '37.70', '1', '37.70', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413420643596328960', '3426', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413420687762284544', '3429', '17.54', '0.00', '17.54', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413420821061472256', '3428', '43.32', '0.00', '43.32', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413421223324585984', '3430', '106.12', '0.00', '106.12', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413421274843217920', '3431', '69.86', '0.00', '69.86', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413421380711710720', '3432', '120.02', '0.00', '120.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413421522072260608', '3433', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413421604247072768', '3435', '71.50', '0.00', '71.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413421689257250816', '3438', '278.00', '0.00', '278.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413421726674620416', '3436', '3.64', '0.00', '3.64', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413421807649898496', '3437', '17.68', '0.00', '17.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413422282415734784', '3441', '171.49', '0.00', '171.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413422536108212224', '3439', '131.67', '0.00', '131.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413422671575896064', '3440', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413423456476913664', '3444', '69.60', '0.00', '69.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413423522084196352', '3445', '18.80', '0.00', '18.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413423544930619392', '3446', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413424503928807424', '3447', '82.48', '0.00', '82.48', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413424807063801856', '3448', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413424862785077248', '3456', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413425079341236224', '3449', '202.70', '0.00', '202.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413425494308933632', '3450', '92.75', '0.00', '92.75', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413425713624895488', '3452', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413426120614871040', '3451', '19.20', '0.00', '19.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413426716680093696', '3453', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413426818916188160', '3454', '254.10', '0.00', '254.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413426959366660096', '3455', '106.50', '0.00', '106.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413427476201443328', '3458', '334.82', '0.00', '334.82', '1', '334.82', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413427893186568192', '3459', '34.00', '0.00', '34.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413428515797438464', '3464', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413428714766761984', '3461', '18.51', '0.00', '18.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413428866692882432', '3462', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413429072071118848', '3460', '17.20', '0.00', '17.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413429192925827072', '3463', '113.28', '0.00', '113.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413429625836707840', '3465', '54.32', '0.00', '54.32', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413429801083195392', '3466', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413429839184248832', '3472', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413429966443589632', '3467', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413430466727550976', '3474', '23.33', '0.00', '23.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413430562072494080', '3471', '100.00', '0.00', '100.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413430565629263872', '3468', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413430678938341376', '3469', '74.03', '0.00', '74.03', '1', '74.03', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413430708415918080', '3473', '59.00', '0.00', '59.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413430800556449792', '3470', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413430934077870080', '3475', '164.10', '0.00', '164.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413431568067899392', '3476', '12.89', '0.00', '12.89', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413432998019420160', '3477', '601.94', '0.00', '601.94', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413433167788040192', '3478', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413433514434736128', '3479', '4.00', '0.00', '4.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413433640037318656', '3481', '2.60', '0.00', '2.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413433681065988096', '3480', '55.13', '0.00', '55.13', '1', '55.13', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413433766038396928', '3482', '6.17', '0.00', '6.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413434030984220672', '3483', '105.00', '0.00', '105.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413434082863587328', '3485', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413434161934606336', '3486', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413434315521605632', '3484', '26.28', '0.00', '26.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413434511563374592', '3487', '11.20', '0.00', '11.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413434668895940608', '3490', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413434706913091584', '3496', '334.82', '0.00', '334.82', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413434999780360192', '3488', '77.00', '0.00', '77.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413435205901004800', '3489', '9.00', '0.00', '9.00', '1', '9.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413435352064135168', '3497', '178.27', '0.00', '178.27', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413435392375537664', '3491', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413435769917431808', '3493', '4.10', '0.00', '4.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413435824313352192', '3495', '11.00', '0.00', '11.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413435839064752128', '3494', '27.00', '0.00', '27.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413436518957252608', '3499', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413436735534313472', '3500', '71.40', '0.00', '71.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413437156126543872', '3502', '8.00', '0.00', '8.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413437313287081984', '3503', '359.97', '0.00', '359.97', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413437387014594560', '3512', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413437531793555456', '3504', '387.82', '0.00', '387.82', '1', '387.82', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413437601905631232', '3508', '64.21', '0.00', '64.21', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413437999013941248', '3510', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413438292841693184', '3505', '5.50', '0.00', '5.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413438339671035904', '3506', '14.00', '0.00', '14.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413438628822183936', '3507', '11.80', '0.00', '11.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413438842459115520', '3517', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413439038307930112', '3511', '133.17', '0.00', '133.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413439065562468352', '3514', '80.00', '0.00', '80.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413439195497877504', '3515', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413439363160911872', '3516', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413439678786453504', '3519', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413440055602765824', '3518', '3.04', '0.00', '3.04', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413440484583612416', '3521', '5.60', '0.00', '5.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413440657338626048', '3522', '4831.66', '0.00', '4831.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413440739374968832', '3523', '51.44', '0.00', '51.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413441441560240128', '3527', '58.80', '0.00', '58.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413442150825381888', '3530', '179.00', '0.00', '179.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413442578736693248', '3533', '1265.00', '0.00', '1265.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413442810035798016', '3531', '48.60', '0.00', '48.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413443120661721088', '3534', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413443153545080832', '3532', '14.13', '0.00', '14.13', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413443183811215360', '3546', '35.00', '0.00', '35.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413443635709665280', '3538', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413443730396041216', '3545', '18.90', '0.00', '18.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413443808594718720', '3537', '15.70', '0.00', '15.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413443961468661760', '3539', '229.00', '0.00', '229.00', '1', '229.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:04', 'SYS', '2021-09-01 17:55:04', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413444439812288512', '3540', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413444801227104256', '3541', '41.28', '0.00', '41.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413444871649423360', '3542', '48.20', '0.00', '48.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413444946840694784', '3543', '207.07', '0.00', '207.07', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413445057780039680', '3544', '3.00', '0.00', '3.00', '1', '3.00', '8', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413446082721140736', '3547', '18.10', '0.00', '18.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413446152644415488', '3548', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413446496057245696', '3549', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413446974165897216', '3551', '101.66', '0.00', '101.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413446981426278400', '3550', '5.80', '0.00', '5.80', '1', '5.80', '2', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413447079057072128', '3552', '3.60', '0.00', '3.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413447342161612800', '3553', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413447437204455424', '3554', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413448106741219328', '3557', '90.76', '0.00', '90.76', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413448425357393920', '3556', '1.90', '0.00', '1.90', '1', '1.90', '4', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413448654353846272', '3558', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413448660917936128', '3561', '4.50', '0.00', '4.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413448870448488448', '3575', '13.00', '0.00', '13.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413448888878260224', '3559', '11.60', '0.00', '11.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413449027290349568', '3560', '24.10', '0.00', '24.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413449981695754240', '3564', '379.00', '0.00', '379.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413450293500370944', '3565', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413450722829369344', '3566', '119.51', '0.00', '119.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413450740273405952', '3567', '12.34', '0.00', '12.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413451161742254080', '3569', '1.30', '1.04', '1.30', '1', '0.26', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413451861473771520', '3571', '2.87', '0.00', '2.87', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413451922660380672', '3570', '56.52', '0.00', '56.52', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413452100884733952', '3572', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413452380627927040', '3573', '35.20', '0.00', '35.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413452645754167296', '3574', '2.30', '0.00', '2.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413452881704701952', '3582', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413453215567151104', '3576', '290.56', '0.00', '290.56', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413453468781395968', '3577', '32.90', '0.00', '32.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413453537341526016', '3578', '23.00', '0.00', '23.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413453539681939456', '3579', '2.90', '0.00', '2.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413453720523628544', '3580', '882.34', '0.00', '882.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413453925293621248', '3581', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413454609980243968', '3583', '41.25', '0.00', '41.25', '1', '41.25', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413455294159314944', '3584', '11.90', '0.00', '11.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413455518609080320', '3585', '10.70', '0.00', '10.70', '1', '10.70', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413455764164669440', '3587', '1992.00', '0.00', '1992.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413456272044490752', '3588', '10.70', '0.00', '10.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413456353397239808', '3589', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413456982375124992', '3590', '437.88', '0.00', '437.88', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413457235413262336', '3591', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413457664306036736', '3593', '98.17', '0.00', '98.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413458252779442176', '3594', '2.50', '0.00', '2.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413459342543507456', '3602', '118.80', '0.00', '118.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413459356980264960', '3596', '8.00', '0.00', '8.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413459815514185728', '3595', '7.00', '0.00', '7.00', '1', '7.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413460213352251392', '3598', '3.50', '0.00', '3.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413460269455323136', '3597', '7.80', '0.00', '7.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413460472698687488', '3600', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413460755772329984', '3599', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413461242324090880', '3601', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413461574118715392', '3603', '179.00', '0.00', '179.00', '1', '179.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413462320948133888', '3604', '98.00', '0.00', '98.00', '1', '98.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413462474933551104', '3605', '72.40', '0.00', '72.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413462620098473984', '3606', '60.83', '0.00', '60.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413462872243208192', '3607', '28.50', '0.00', '28.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413463081480335360', '3609', '41.25', '0.00', '41.25', '1', '41.25', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413463372225273856', '3610', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413463591524491264', '3611', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413463831392485376', '3612', '181.57', '0.00', '181.57', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413464019028869120', '3613', '2.80', '0.00', '2.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413464624988360704', '3614', '20.60', '0.00', '20.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413464795411341312', '3617', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413464896485687296', '3615', '28.60', '0.00', '28.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413464924281339904', '3616', '180.67', '0.00', '180.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413465163683823616', '3618', '95.80', '0.00', '95.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413465677926465536', '3619', '202.25', '0.00', '202.25', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413465977785634816', '3620', '5.52', '0.00', '5.52', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413466106085236736', '3621', '46.67', '0.00', '46.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413466221764083712', '3622', '10.80', '0.00', '10.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413466280744415232', '3623', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413466696634789888', '3624', '0.70', '0.00', '0.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413466710190829568', '3625', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413467147874766848', '3627', '7.00', '0.00', '7.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413467306281127936', '3633', '8.46', '0.00', '8.46', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413467496442466304', '3626', '880.00', '0.00', '880.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413467748847210496', '3628', '387.82', '0.00', '387.82', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413468541977530368', '3630', '25.20', '0.00', '25.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413468658235269120', '3632', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413468717425315840', '3631', '17.00', '0.00', '17.00', '1', '17.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413469829893152768', '3635', '20112.00', '0.00', '20112.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413469835131764736', '3634', '98.00', '0.00', '98.00', '1', '98.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413469942992539648', '3637', '13.70', '0.00', '13.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413470865013764096', '3636', '13.60', '0.00', '13.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413471330707419136', '3638', '12.80', '0.00', '12.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413471616280711168', '3639', '92.54', '0.00', '92.54', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413471728683900928', '3640', '47.00', '0.00', '47.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413471851161767936', '3641', '17.50', '0.00', '17.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413471933189795840', '3643', '169.42', '0.00', '169.42', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413471963015434240', '3642', '21758.00', '0.00', '21758.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413472558422069248', '3644', '229.00', '0.00', '229.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413472797904310272', '3650', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413472838555471872', '3647', '90.00', '0.00', '90.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413473199148171264', '3652', '29.00', '0.00', '29.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413473611414712320', '3646', '285.00', '0.00', '285.00', '1', '285.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413473838997659648', '3648', '47.00', '0.00', '47.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413473954995363840', '3649', '2199.00', '0.00', '2199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413474551295365120', '3651', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413475479893303296', '3653', '23.00', '0.00', '23.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413476886935441408', '3654', '29.00', '0.00', '29.00', '1', '29.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413477234718773248', '3655', '13.60', '0.00', '13.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413477761405931520', '3656', '8.54', '0.00', '8.54', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413477827189354496', '3673', '479.00', '0.00', '479.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413478138117255168', '3658', '399.00', '0.00', '399.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413478185928155136', '3659', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413479681864474624', '3661', '188.57', '0.00', '188.57', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413479722918322176', '3662', '46.34', '0.00', '46.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413480713839333376', '3663', '219.30', '0.00', '219.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413480746366164992', '3664', '1257.00', '0.00', '1257.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413480962330918912', '3666', '213.83', '0.00', '213.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413481940094496768', '3665', '411.00', '0.00', '411.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413482138514481152', '3667', '39.06', '0.00', '39.06', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413482449241026560', '3668', '1257.00', '0.00', '1257.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413482489531555840', '3671', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413482951026577408', '3669', '15.01', '0.00', '15.01', '1', '15.01', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413483330883710976', '3670', '219.00', '0.00', '219.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413483673919049728', '3672', '199.00', '0.00', '199.00', '1', '199.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413484768275947520', '3674', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413484916888465408', '3675', '96.51', '0.00', '96.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413485644029820928', '3679', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413485891988676608', '3677', '6270.00', '0.00', '6270.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413485897118285824', '3678', '41.30', '0.00', '41.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413486312887095296', '3680', '95.54', '0.00', '95.54', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413486606970736640', '3682', '17.00', '0.00', '17.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413487000882946048', '3683', '90.00', '0.00', '90.00', '1', '90.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413487149248090112', '3684', '1279.00', '0.00', '1279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413488155683876864', '3689', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413488737366765568', '3690', '528.88', '0.00', '528.88', '1', '528.88', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413488743553355776', '3691', '13408.00', '0.00', '13408.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:05', 'SYS', '2021-09-01 17:55:05', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413489368710242304', '3693', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413489544837361664', '3694', '0.50', '0.00', '0.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413489967166033920', '3695', '7.10', '0.00', '7.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413490549519966208', '3696', '3.10', '0.00', '3.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413491247359885312', '3697', '528.88', '0.00', '528.88', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413492959659327488', '3700', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413493020007063552', '3699', '80.20', '0.00', '80.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413493653569159168', '3704', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413494466739830784', '3701', '4.50', '0.00', '4.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413494555600392192', '3702', '3.80', '0.00', '3.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413494678233468928', '3703', '378.80', '0.00', '378.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413495376094371840', '3705', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413495425876582400', '3706', '193.62', '0.00', '193.62', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413495857898307584', '3707', '22.30', '0.00', '22.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413497528208539648', '3708', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413497770622492672', '3709', '2.13', '0.00', '2.13', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413498652240080896', '3712', '148.50', '0.00', '148.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413498746876092416', '3711', '8380.00', '0.00', '8380.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413499251056623616', '3714', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413499348096024576', '3715', '30.99', '0.00', '30.99', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413499727672229888', '3716', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413500374425518080', '3718', '3.80', '0.00', '3.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413500683713474560', '3722', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413501242155630592', '3719', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413501338175832064', '3720', '2.00', '0.00', '2.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413501982735560704', '3721', '179.00', '0.00', '179.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413504604309798912', '3723', '3.00', '0.00', '3.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413506221490802688', '3724', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413506528580931584', '3725', '102.70', '0.00', '102.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413507064088707072', '3727', '2.80', '0.00', '2.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413507163170734080', '3728', '41.91', '0.00', '41.91', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413508860777570304', '3729', '19.21', '0.00', '19.21', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413509618264666112', '3731', '1.76', '0.00', '1.76', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413509770241097728', '3732', '5.00', '0.00', '5.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413509999979888640', '3733', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413510424556670976', '3735', '19.98', '0.00', '19.98', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413510675489251328', '3734', '799.00', '0.00', '799.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413511171323088896', '3736', '303.60', '0.00', '303.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413511505852452864', '3737', '2.40', '0.00', '2.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413512160709132288', '3738', '379.00', '0.00', '379.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413512982507524096', '3739', '13.10', '0.00', '13.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413512996394852352', '3741', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413514839208378368', '3742', '160.90', '0.00', '160.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413517799913082880', '3744', '79.00', '0.00', '79.00', '1', '79.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413518643177889792', '3745', '2.90', '0.28', '2.90', '1', '2.62', '2', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413518934052941824', '3751', '174.16', '0.00', '174.16', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413519356155101184', '3748', '231.66', '0.00', '231.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413519611957248000', '3747', '8.90', '0.00', '8.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413519693175803904', '3750', '148.34', '0.00', '148.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413522005399121920', '3752', '4.30', '0.00', '4.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413522169165709312', '3753', '779.00', '0.00', '779.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413523030222790656', '3754', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413528546357411840', '3756', '5.40', '0.00', '5.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413529930012213248', '3757', '11.52', '0.00', '11.52', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413530131938615296', '3758', '64.83', '0.00', '64.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413530284108013568', '3759', '22.02', '0.00', '22.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413530561154375680', '3761', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413530567449980928', '3760', '10.76', '0.00', '10.76', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413531549672054784', '3763', '1.00', '0.00', '1.00', '1', '1.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413532862296252416', '3764', '20.80', '0.00', '20.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413533014645960704', '3765', '44.10', '0.00', '44.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413534598251565056', '3766', '2.20', '0.00', '2.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413536426007695360', '3767', '0.80', '0.00', '0.80', '1', '0.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413536651636072448', '3768', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413537070823178240', '3769', '29.60', '0.00', '29.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413537676614893568', '3773', '58.34', '0.00', '58.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413538168862633984', '3771', '4.30', '0.00', '4.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413539582661869568', '3774', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413540466414227456', '3775', '12.70', '0.00', '12.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413540969248387072', '3776', '64.00', '0.00', '64.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413541786458173440', '3777', '9.20', '0.00', '9.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413543534707027968', '3779', '799.00', '0.00', '799.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413548338250403840', '3780', '6.50', '0.00', '6.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413551208270024704', '3781', '249.00', '0.00', '249.00', '1', '249.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413551602178129920', '3782', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413553446040363008', '3783', '1.48', '0.00', '1.48', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413556566854119424', '3785', '20.69', '0.00', '20.69', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413556938301743104', '3786', '30.00', '0.00', '30.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413557209798955008', '3787', '1.30', '0.00', '1.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413558961856282624', '3788', '35.20', '0.00', '35.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413566586660577280', '3790', '3.40', '0.00', '3.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413571929012568064', '3791', '1.03', '0.00', '1.03', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413574636586811392', '3793', '145.05', '0.00', '145.05', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413579508946288640', '3794', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413581243060301824', '3795', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413590819037929472', '3796', '1.30', '0.00', '1.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413595620337467392', '3799', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413597133256515584', '3800', '2.80', '0.00', '2.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413607443837128704', '3801', '0.40', '0.00', '0.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413608367104184320', '3802', '9.00', '0.00', '9.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413611328177889280', '3803', '1279.00', '0.00', '1279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413612668606132224', '3804', '17.00', '0.00', '17.00', '1', '17.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413616361716027392', '3805', '38.30', '0.00', '38.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413620556380749824', '3806', '8.00', '0.00', '8.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413623707385118720', '3807', '41.66', '0.00', '41.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413623908481056768', '3808', '6.00', '0.00', '6.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413624911301332992', '3809', '35.83', '0.00', '35.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413625483958120448', '3810', '83.33', '0.00', '83.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413628920250736640', '3812', '91.01', '0.00', '91.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413629201738780672', '3811', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413629688273883136', '3813', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413633367072821248', '3815', '43.43', '0.00', '43.43', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413635852596404224', '3817', '68.32', '0.00', '68.32', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413638086109364224', '3820', '1.90', '0.00', '1.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413638306385776640', '3819', '232.59', '0.00', '232.59', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413638606412730368', '3821', '5.70', '0.00', '5.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413639496049864704', '3824', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413639814942773248', '3822', '99.01', '0.00', '99.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413639895016202240', '3823', '192.34', '0.00', '192.34', '1', '192.34', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413642350462414848', '3825', '193.25', '0.00', '193.25', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413643528252403712', '3828', '3.90', '0.00', '3.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413643747715174400', '3826', '201.27', '0.00', '201.27', '1', '201.27', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413643773648556032', '3827', '1347.79', '0.00', '1347.79', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413644406749310976', '3829', '479.00', '0.00', '479.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413645665560637440', '3830', '12.80', '0.00', '12.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413646267778760704', '3831', '6.30', '0.00', '6.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413646712542756864', '3832', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413648223301689344', '3833', '52.52', '0.00', '52.52', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413649923781619712', '3834', '286.43', '0.00', '286.43', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413650565522653184', '3835', '1.54', '0.00', '1.54', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413653024978743296', '3836', '58.51', '0.00', '58.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413653081572397056', '3837', '1.60', '0.00', '1.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413653762530291712', '3838', '52.70', '0.00', '52.70', '1', '52.70', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413654887245504512', '3840', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413654964030640128', '3842', '99.00', '0.00', '99.00', '1', '99.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413655736717901824', '3843', '1.30', '0.00', '1.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413656765597450240', '3844', '66.78', '0.00', '66.78', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413656913081761792', '3845', '351.27', '0.00', '351.27', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413658120441536512', '3846', '368.72', '0.00', '368.72', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413658475640320000', '3847', '12.00', '0.00', '12.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413659371740758016', '3848', '31.99', '0.00', '31.99', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413659529610248192', '3849', '98.00', '0.00', '98.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413659585113403392', '3850', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413659737287004160', '3851', '78.00', '0.00', '78.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413660019999870976', '3855', '90.10', '0.00', '90.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413660071099068416', '3852', '71.59', '0.00', '71.59', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413660086143983616', '3853', '4.25', '0.00', '4.25', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413660164736851968', '3854', '24.22', '0.00', '24.22', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413661719481499648', '3859', '3.83', '0.00', '3.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413661849135767552', '3860', '2.90', '0.00', '2.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413661866709876736', '3858', '82.41', '0.00', '82.41', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413662288677867520', '3861', '679.00', '0.00', '679.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413662294436630528', '3866', '1379.00', '0.00', '1379.00', '1', '1379.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413662670925762560', '3862', '23.17', '0.00', '23.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413663278923710464', '3863', '574.16', '0.00', '574.16', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413663487405821952', '3864', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413663654150328320', '3865', '200.93', '0.00', '200.93', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:06', 'SYS', '2021-09-01 17:55:06', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413665525762060288', '3867', '271.73', '0.00', '271.73', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413665750115287040', '3868', '129.66', '0.00', '129.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413666429001166848', '3869', '64.78', '0.00', '64.78', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413666969525379072', '3870', '1.79', '0.00', '1.79', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413667077964869632', '3871', '19.60', '0.00', '19.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413667819505225728', '3872', '98.49', '0.00', '98.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413668642297696256', '3873', '126.03', '0.00', '126.03', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413668737852366848', '3874', '47.10', '0.00', '47.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413669033202606080', '3875', '56.15', '0.00', '56.15', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413669703150374912', '3876', '209.12', '0.00', '209.12', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413670092931231744', '3877', '639.00', '0.00', '639.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413670915555897344', '3879', '148.49', '0.00', '148.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413670957457014784', '3878', '165.05', '0.00', '165.05', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413672552383102976', '3882', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413672586663051264', '3883', '69.50', '0.00', '69.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413673311124275200', '3884', '98.17', '0.00', '98.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413673933944872960', '3886', '29.00', '0.00', '29.00', '1', '29.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413675174804520960', '3887', '144.34', '0.00', '144.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413675389049556992', '3889', '134.56', '0.00', '134.56', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413675409576493056', '3888', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413675676015480832', '3890', '329.84', '0.00', '329.84', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413676357195530240', '3892', '234.83', '0.00', '234.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413676502364614656', '3893', '17.33', '0.00', '17.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413676916623478784', '3895', '2869.30', '0.00', '2869.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413677055454973952', '3899', '119.79', '0.00', '119.79', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413677350188662784', '3898', '57.82', '0.00', '57.82', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413677591860289536', '3903', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413677959050588160', '3900', '509.22', '0.00', '509.22', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413678221253316608', '3901', '74.03', '0.00', '74.03', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413678374542557184', '3910', '15.34', '0.00', '15.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413678437402644480', '3902', '84.73', '0.00', '84.73', '1', '84.73', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413678999640686592', '3907', '312.80', '0.00', '312.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413679017751658496', '3904', '35.90', '0.00', '35.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413679106398318592', '3911', '222.90', '0.00', '222.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413679340796985344', '3906', '13.83', '0.00', '13.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413679374288490496', '3908', '59.00', '0.00', '59.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413679458019352576', '3912', '297.51', '0.00', '297.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413679538369716224', '3909', '42.84', '0.00', '42.84', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413679646880555008', '3922', '698.49', '0.00', '698.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413679651720695808', '3915', '65.73', '0.00', '65.73', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413679661833195520', '3919', '199.02', '0.00', '199.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413679686072037376', '3913', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413679733522292736', '3914', '219.00', '0.00', '219.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413680224369033216', '3933', '784.34', '0.00', '784.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413680367336050688', '3916', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413680685880836096', '3918', '189.04', '0.00', '189.04', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413681083010166784', '3921', '44.10', '0.00', '44.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413681222793785344', '3926', '90.94', '0.00', '90.94', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413681420467122176', '3920', '1198.34', '0.00', '1198.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413681428516016128', '3925', '178.00', '0.00', '178.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413681497533284352', '3923', '65.66', '0.00', '65.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413681630886977536', '3924', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413681718728278016', '3927', '852.90', '0.00', '852.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413682078813507584', '3929', '35.28', '0.00', '35.28', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413682285299044352', '3928', '22.10', '0.00', '22.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413682285592629248', '3930', '415.01', '0.00', '415.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413682626052694016', '3931', '27.21', '0.00', '27.21', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413682675339923456', '3932', '2.60', '0.00', '2.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413682873990619136', '3936', '400.48', '0.00', '400.48', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413682957348192256', '3934', '151.80', '0.00', '151.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413683172281077760', '3935', '255.50', '0.00', '255.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413683982746501120', '3941', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413684021845725184', '3938', '124.51', '0.00', '124.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413684445541818368', '3942', '15.09', '0.00', '15.09', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413684609723596800', '3944', '50.33', '0.00', '50.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413684633442336768', '3943', '233.87', '0.00', '233.87', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413684899625492480', '3945', '1105.52', '0.00', '1105.52', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413685020643786752', '3947', '49.00', '0.00', '49.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413685351414947840', '3948', '89.17', '0.00', '89.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413685395882901504', '3949', '6.34', '0.00', '6.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413685451650453504', '3950', '228.32', '0.00', '228.32', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413685512472055808', '3951', '219.00', '0.00', '219.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413685702146830336', '3956', '4.53', '0.00', '4.53', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413686007404126208', '3953', '15.01', '0.00', '15.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413686111162851328', '3958', '7.23', '0.00', '7.23', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413686172823220224', '3955', '72.52', '0.00', '72.52', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413686400129421312', '3957', '115.56', '0.00', '115.56', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413686557675778048', '3960', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413686559420624896', '3964', '231.34', '0.00', '231.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413686661224792064', '3959', '98.67', '0.00', '98.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413687119788085248', '3961', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413687148028338176', '3962', '678.98', '0.00', '678.98', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413687256232935424', '3963', '178.00', '0.00', '178.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413687507417235456', '3965', '51.11', '0.00', '51.11', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413687855963918336', '3970', '146.52', '0.00', '146.52', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413687885756071936', '3966', '258.96', '0.00', '258.96', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413688226962698240', '3968', '399.00', '0.00', '399.00', '1', '399.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413688282931466240', '3985', '203.95', '0.00', '203.95', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413688493296771072', '3969', '131.66', '0.00', '131.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413688945233055744', '3972', '47.17', '0.00', '47.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413688998743949312', '3971', '79.73', '0.00', '79.73', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413689302847733760', '3973', '20.80', '0.00', '20.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413689843720110080', '3982', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413689877857456128', '3974', '68.87', '0.00', '68.87', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413690014067458048', '3977', '106.80', '0.00', '106.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413690071353298944', '3975', '48.70', '0.00', '48.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413690136629272576', '3976', '24.40', '0.00', '24.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413690143382044672', '3978', '30.94', '0.00', '30.94', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413690208729399296', '3980', '149.00', '0.00', '149.00', '1', '149.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413690283710894080', '3979', '99.58', '0.00', '99.58', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413690323078705152', '3981', '8.00', '0.00', '8.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413690656538394624', '3989', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413690691447586816', '3983', '130.67', '0.00', '130.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413691094121807872', '3984', '68.23', '0.00', '68.23', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413691764774219776', '3986', '270.63', '0.00', '270.63', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413691805563834368', '3993', '1.84', '0.00', '1.84', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413691847796248576', '3988', '16.73', '0.00', '16.73', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413691953945702400', '3990', '64.66', '0.00', '64.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413692057008111616', '3991', '202.80', '0.00', '202.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413692578720894976', '3997', '1653.00', '0.00', '1653.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413692631522889728', '3994', '65.00', '0.00', '65.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413692665639452672', '3995', '74.70', '0.00', '74.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413692777866428416', '3996', '107.69', '0.00', '107.69', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413693090979590144', '3998', '43.45', '0.00', '43.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413693146231107584', '3999', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413693390956179456', '4001', '811.59', '0.00', '811.59', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413693490549964800', '4002', '232.34', '0.00', '232.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413693516433006592', '4005', '94.00', '0.00', '94.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413693576273178624', '4003', '5.88', '0.00', '5.88', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413693580899385344', '4004', '28.00', '0.00', '28.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413693858772140032', '4019', '65.00', '0.00', '65.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413693876824346624', '4012', '399.00', '0.00', '399.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413693968381829120', '4006', '12.40', '0.00', '12.40', '1', '12.40', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413694018545750016', '4007', '2.84', '0.00', '2.84', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413694032240164864', '4009', '13.00', '0.00', '13.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413694273504825344', '4008', '11.96', '0.00', '11.96', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413694339816775680', '4030', '18.00', '0.00', '18.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413694470599368704', '4010', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413694675835146240', '4011', '213.45', '0.00', '213.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413694977732763648', '4013', '133.46', '0.00', '133.46', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413695170683236352', '4014', '6.90', '0.00', '6.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413695180942598144', '4021', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413695277474488320', '4016', '88.08', '0.00', '88.08', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413695406629609472', '4018', '72.50', '0.00', '72.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413695499634098176', '4023', '28.62', '0.00', '28.62', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413695591455891456', '4022', '137.00', '0.00', '137.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413695656794685440', '4020', '15.39', '0.00', '15.39', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413695922252238848', '4024', '11.00', '0.00', '11.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413696368861671424', '4025', '183.01', '0.00', '183.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413696785838469120', '4027', '0.50', '0.00', '0.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413697573172248576', '4029', '159.01', '0.00', '159.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413697599512395776', '4032', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413697677698400256', '4036', '198.33', '0.00', '198.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413697705494093824', '4031', '65.66', '0.00', '65.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413697757398593536', '4033', '1241.83', '0.00', '1241.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413698053768101888', '4037', '114.00', '0.00', '114.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413698240410456064', '4035', '2560.00', '0.00', '2560.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413698490487459840', '4034', '20.29', '0.00', '20.29', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413698868683636736', '4038', '196.17', '0.00', '196.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413698995355889664', '4039', '2.40', '0.00', '2.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413698996639346688', '4040', '61.57', '0.00', '61.57', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413699275807985664', '4042', '3998.34', '0.00', '3998.34', '1', '3998.34', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413699310687748096', '4041', '221.85', '0.00', '221.85', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413699603244675072', '4043', '223.17', '0.00', '223.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413699719284338688', '4044', '163.33', '0.00', '163.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413699969478754304', '4045', '239.03', '0.00', '239.03', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413700208226959360', '4048', '431.66', '0.00', '431.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413700389479587840', '4047', '180.24', '0.00', '180.24', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413700842028175360', '4050', '207.13', '0.00', '207.13', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413700904338755584', '4049', '94.17', '0.00', '94.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:07', 'SYS', '2021-09-01 17:55:07', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413701010353963008', '4066', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413701395277873152', '4051', '251.90', '0.00', '251.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413701432707821568', '4057', '274.69', '0.00', '274.69', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413701626975416320', '4052', '16.60', '0.00', '16.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413701912557170688', '4054', '1.00', '0.00', '1.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413701990126702592', '4053', '122.17', '0.00', '122.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413702380675006464', '4055', '52.15', '0.00', '52.15', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413702873220636672', '4056', '12.66', '0.00', '12.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413702956808826880', '4067', '23.48', '0.00', '23.48', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413703006981091328', '4065', '92.91', '0.00', '92.91', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413703122915905536', '4058', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413703144575266816', '4059', '2498.26', '0.00', '2498.26', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413703313383395328', '4062', '59.40', '0.00', '59.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413703318034874368', '4061', '55.67', '0.00', '55.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413703381582757888', '4063', '10.01', '0.00', '10.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413703845703450624', '4069', '28.01', '0.00', '28.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413703938837999616', '4072', '231.35', '0.00', '231.35', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413704108497629184', '4070', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413704197542670336', '4071', '1.09', '0.00', '1.09', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413704332326670336', '4079', '40.15', '0.00', '40.15', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413704348676075520', '4074', '138.61', '0.00', '138.61', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413704469493022720', '4075', '19.82', '0.00', '19.82', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413704609976999936', '4076', '90.51', '0.00', '90.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413704625932120064', '4077', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413704704575320064', '4078', '10.61', '0.00', '10.61', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413705427300073472', '4080', '53.68', '0.00', '53.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413705590789832704', '4082', '648.17', '0.00', '648.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413705738391560192', '4084', '0.23', '0.00', '0.23', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413706226658910208', '4083', '999.00', '0.00', '999.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413706568486326272', '4091', '299.00', '0.00', '299.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413706652674322432', '4086', '11.50', '0.00', '11.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413706689999462400', '4085', '65.05', '0.00', '65.05', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413706720458506240', '4087', '1.69', '0.00', '1.69', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413707020107972608', '4089', '363.67', '0.00', '363.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413707027980668928', '4088', '8.34', '0.00', '8.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413707055436591104', '4093', '142.18', '0.00', '142.18', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413707107009757184', '4090', '4.86', '0.00', '4.86', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413707791503433728', '4108', '278.00', '0.00', '278.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413707797543243776', '4110', '439.18', '0.00', '439.18', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413707851804893184', '4095', '323.68', '0.00', '323.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413707904724439040', '4121', '186.11', '0.00', '186.11', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413707997909254144', '4096', '81.58', '0.00', '81.58', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413708102859190272', '4094', '39.65', '0.00', '39.65', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413708441456963584', '4097', '18.00', '0.00', '18.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413708998963757056', '4106', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413709063669350400', '4098', '1.01', '0.00', '1.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413709311032651776', '4100', '77.67', '0.00', '77.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413709344570294272', '4103', '13.63', '0.00', '13.63', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413709354057728000', '4101', '187.94', '0.00', '187.94', '1', '187.94', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413709393324900352', '4102', '65.83', '0.00', '65.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413709458084921344', '4104', '57.73', '0.00', '57.73', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413709590373289984', '4105', '22.60', '0.00', '22.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413709822855208960', '4109', '931.65', '0.00', '931.65', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413710397063774208', '4112', '15.00', '0.00', '15.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413711288948961280', '4111', '393.98', '0.00', '393.98', '1', '393.98', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413711572337147904', '4115', '466.53', '0.00', '466.53', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413711699143471104', '4113', '22.67', '0.00', '22.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413711784849948672', '4114', '196.17', '0.00', '196.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413712218318671872', '4117', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413712435533299712', '4116', '21.47', '0.00', '21.47', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413712545805631488', '4118', '0.80', '0.00', '0.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413712652588445696', '4120', '179.00', '0.00', '179.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413712667973230592', '4119', '4.50', '0.00', '4.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413712982491443200', '4123', '393.98', '0.00', '393.98', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413713276545781760', '4124', '147.81', '0.00', '147.81', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413713311240986624', '4128', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413713350730383360', '4125', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413713517382668288', '4135', '13.60', '0.00', '13.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413713519039410176', '4126', '148.00', '0.00', '148.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413713588052492288', '4134', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413713598588633088', '4127', '152.81', '0.00', '152.81', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413713846643929088', '4129', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413714025249992704', '4132', '15.00', '0.00', '15.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413714054538838016', '4130', '118.33', '0.00', '118.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413714059869741056', '4131', '198.00', '0.00', '198.00', '1', '198.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413714156829429760', '4133', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413714314111733760', '4136', '29.51', '0.00', '29.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413714533331136512', '4139', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413714590306570240', '4137', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413714891457634304', '4138', '38.85', '0.00', '38.85', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413715172622749696', '4140', '18.00', '0.00', '18.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413715177815322624', '4144', '199.00', '0.00', '199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413715178100592640', '4141', '397.51', '0.00', '397.51', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413715232655904768', '4142', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413715293624320000', '4152', '3998.34', '0.00', '3998.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413715798589087744', '4143', '109.07', '0.00', '109.07', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413716220691292160', '4146', '41.34', '0.00', '41.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413716272767819776', '4145', '47.30', '0.00', '47.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413716453793935360', '4147', '87.49', '0.00', '87.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413716631636574208', '4149', '80.77', '0.00', '80.77', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413716686191972352', '4148', '76.91', '0.00', '76.91', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413716918279565312', '4150', '140.71', '0.00', '140.71', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413717026580594688', '4162', '169.15', '0.00', '169.15', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413717226900619264', '4153', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413717449802715136', '4159', '265.00', '0.00', '265.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413717471222992896', '4151', '131.53', '0.00', '131.53', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413717865365958656', '4154', '65.00', '0.00', '65.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413718105028501504', '4155', '114.83', '0.00', '114.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413718179246747648', '4156', '8.30', '0.00', '8.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413718189182984192', '4157', '65.66', '0.00', '65.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413718445165613056', '4158', '122.56', '0.00', '122.56', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413718741925150720', '4170', '22.00', '0.00', '22.00', '1', '22.00', '3', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413718787856969728', '4166', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413718875350151168', '4164', '471.58', '0.00', '471.58', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413718885596852224', '4161', '9.26', '0.00', '9.26', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413718986394357760', '4167', '608.40', '0.00', '608.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413719036914790400', '4163', '17.00', '0.00', '17.00', '1', '17.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413719055390654464', '4165', '10990.00', '0.00', '10990.00', '1', '10990.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413719173246369792', '4168', '235.67', '0.00', '235.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413719275998490624', '4171', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413719732267503616', '4175', '100.00', '0.00', '100.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413719964959035392', '4183', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413719999964729344', '4173', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413720034907459584', '4174', '97.34', '0.00', '97.34', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413720225752506368', '4177', '412.01', '0.00', '412.01', '1', '412.01', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413720368774107136', '4185', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413720389384896512', '4178', '1099.00', '0.00', '1099.00', '1', '1099.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413720478522208256', '4179', '3.00', '0.00', '3.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413720662916349952', '4180', '10990.00', '0.00', '10990.00', '1', '10990.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413720706549800960', '4195', '173.94', '0.00', '173.94', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413720920497029120', '4184', '10990.00', '0.00', '10990.00', '1', '10990.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413721165746393088', '4186', '8792.00', '0.00', '8792.00', '1', '8792.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413721183714725888', '4187', '4.49', '0.00', '4.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413721192111792128', '4190', '10990.00', '0.00', '10990.00', '1', '10990.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413721383543967744', '4188', '44.00', '0.00', '44.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413721384579985408', '4189', '10990.00', '0.00', '10990.00', '1', '10990.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413721431480680448', '4191', '21980.00', '0.00', '21980.00', '1', '21980.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413721484601569280', '4194', '279.01', '0.00', '279.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413721514695680000', '4209', '10990.00', '0.00', '10990.00', '1', '10990.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413721579036323840', '4193', '2198.00', '0.00', '2198.00', '1', '2198.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413722168164057088', '4196', '10990.00', '0.00', '10990.00', '1', '10990.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413722329850245120', '4197', '4396.00', '0.00', '4396.00', '1', '4396.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413722409835614208', '4199', '162.90', '0.00', '162.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413722491733659648', '4200', '125.72', '0.00', '125.72', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413722648973914112', '4203', '379.00', '0.00', '379.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413722799029223424', '4202', '10.01', '0.00', '10.01', '1', '10.01', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413723330758037504', '4204', '29.66', '0.00', '29.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413723878039162880', '4206', '264.94', '0.00', '264.94', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413724201835200512', '4205', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413724973738217472', '4207', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413725301158174720', '4210', '77.80', '0.00', '77.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413726136948723712', '4212', '10990.00', '0.00', '10990.00', '1', '10990.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413726663363162112', '4213', '181.92', '0.00', '181.92', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413726725799575552', '4215', '475.00', '0.00', '475.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413726884616900608', '4219', '617.89', '0.00', '617.89', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413726904913186816', '4214', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413727192306872320', '4216', '3.20', '0.00', '3.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:08', 'SYS', '2021-09-01 17:55:08', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413727367490396160', '4217', '127.06', '0.00', '127.06', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413727385555275776', '4218', '121.50', '0.00', '121.50', '1', '121.50', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413728008971472896', '4220', '1279.00', '0.00', '1279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413728215511535616', '4259', '121.50', '0.00', '121.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413728332494798848', '4221', '64.82', '0.00', '64.82', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413728387868000256', '4225', '0.50', '0.00', '0.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413728619313938432', '4223', '93.19', '0.00', '93.19', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413729034239606784', '4227', '1279.00', '0.00', '1279.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413729052841435136', '4228', '169.24', '0.00', '169.24', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413729223637676032', '4229', '397.85', '0.00', '397.85', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413729242625212416', '4233', '10.23', '0.00', '10.23', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413729354290188288', '4231', '16.70', '0.00', '16.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413729454190129152', '4241', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413729528555134976', '4236', '19.20', '0.00', '19.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413729677348118528', '4235', '34.80', '0.00', '34.80', '1', '34.80', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413729685669650432', '4237', '216.68', '0.00', '216.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413729758008782848', '4238', '102.68', '0.00', '102.68', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413730050997739520', '4239', '2.50', '0.00', '2.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413730055720443904', '4240', '3297.00', '0.00', '3297.00', '1', '3297.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413730363762716672', '4243', '141.50', '0.00', '141.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413730477147373568', '4244', '34.80', '0.00', '34.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413730532214398976', '4251', '92.06', '0.00', '92.06', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413730760371957760', '4302', '10990.00', '0.00', '10990.00', '1', '10990.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413730990580498432', '4285', '10990.00', '0.00', '10990.00', '1', '10990.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413731293048573952', '4245', '79.00', '0.00', '79.00', '1', '79.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413731298522091520', '4248', '79.00', '0.00', '79.00', '1', '79.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413731512733605888', '4246', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413731666035384320', '4247', '213.45', '0.00', '213.45', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413731861934596096', '4249', '135.88', '0.00', '135.88', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413732016742072320', '4250', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413732167581888512', '4253', '25.67', '0.00', '25.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413732172120186880', '4252', '1099.00', '0.00', '1099.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413732214629351424', '4255', '1.10', '0.00', '1.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413732238578905088', '4254', '48.17', '0.00', '48.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413732338881433600', '4256', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413732745972236288', '4261', '54.15', '0.00', '54.15', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413732879959277568', '4264', '4.60', '0.00', '4.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413732919289270272', '4265', '45.00', '0.00', '45.00', '1', '45.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413733204380270592', '4267', '11.80', '0.00', '11.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413733531708014592', '4271', '399.39', '0.00', '399.39', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413733727992991744', '4276', '141.84', '0.00', '141.84', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413734139231940608', '4274', '1099.00', '0.00', '1099.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413734229245931520', '4275', '1099.00', '0.00', '1099.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413734485937262592', '4277', '10990.00', '0.00', '10990.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413735027346391040', '4284', '946.02', '0.00', '946.02', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413735088990113792', '4281', '10.00', '0.00', '10.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413735132246016000', '4282', '101.40', '0.00', '101.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413736180838756352', '4287', '2.01', '0.00', '2.01', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413736291157344256', '4286', '17.00', '0.00', '17.00', '1', '17.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413736355665752064', '4288', '204.66', '0.00', '204.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413736364289208320', '4298', '10990.00', '0.00', '10990.00', '1', '10990.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413736547513253888', '4289', '141.35', '0.00', '141.35', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413736991740358656', '4293', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413737208162189312', '4292', '4.30', '0.00', '4.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413737375443664896', '4295', '23.07', '0.00', '23.07', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413737833793052672', '4297', '100.00', '0.00', '100.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413738041767546880', '4301', '146.90', '0.00', '146.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413738063527628800', '4303', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413738142602797056', '4299', '20.80', '0.00', '20.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413738200756871168', '4304', '68.25', '0.00', '68.25', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413738232230871040', '4300', '102.55', '0.00', '102.55', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413738817747324928', '4306', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413739109779927040', '4307', '1276.88', '0.00', '1276.88', '1', '1276.88', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413739448067358720', '4305', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413739971189387264', '4308', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413739977824722944', '4310', '1765.65', '0.00', '1765.65', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413740206984683520', '4309', '25.60', '0.00', '25.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413740598980186112', '4311', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413740635856474112', '4312', '65.66', '0.00', '65.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413740678135091200', '4313', '236.49', '0.00', '236.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413740712805240832', '4314', '71.19', '0.00', '71.19', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413741201097719808', '4320', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413742064776196096', '4323', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413742567245422592', '4322', '7.00', '0.00', '7.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413742994489737216', '4325', '9.63', '0.00', '9.63', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413743097782947840', '4324', '17.50', '0.00', '17.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413743187260071936', '4326', '44.00', '0.00', '44.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413743239479140352', '4328', '211.00', '0.00', '211.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413743274300223488', '4352', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413743321729425408', '4329', '20.00', '0.00', '20.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413743549429796864', '4327', '135.03', '0.00', '135.03', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413743910152531968', '4334', '1099.00', '0.00', '1099.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413743996341301248', '4330', '6.70', '0.00', '6.70', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413744009494618112', '4331', '70.80', '0.00', '70.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413744177883316224', '4333', '183.29', '0.00', '183.29', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413744198812930048', '4332', '159.84', '0.00', '159.84', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413744825529982976', '4335', '179.00', '0.00', '179.00', '1', '179.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413746020717862912', '4336', '14.83', '0.00', '14.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413746386486382592', '4345', '66.00', '0.00', '66.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413746648936550400', '4337', '51.41', '0.00', '51.41', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413746749574684672', '4340', '179.00', '0.00', '179.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413746777802375168', '4339', '0.30', '0.00', '0.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413747239838453760', '4343', '249.00', '0.00', '249.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413747361397821440', '4342', '150.66', '0.00', '150.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413747658820067328', '4344', '19.90', '0.00', '19.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413748408342261760', '4348', '21.48', '0.00', '21.48', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413748463950340096', '4349', '63.33', '0.00', '63.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413748699636637696', '4351', '277.00', '0.00', '277.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413748816095662080', '4350', '1276.88', '0.00', '1276.88', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413749053455491072', '4353', '8.50', '0.00', '8.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413749997106876416', '4356', '179.00', '0.00', '179.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413750060705058816', '4355', '10.00', '0.00', '10.00', '1', '10.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413750387684659200', '4357', '78.33', '0.00', '78.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413750928938594304', '4358', '12.55', '0.00', '12.55', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413751214780411904', '4359', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413751843233910784', '4361', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413751976025628672', '4362', '17.00', '0.00', '17.00', '1', '17.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413752369140879360', '4363', '136.10', '0.00', '136.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413752444290289664', '4364', '71.94', '0.00', '71.94', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413752694384091136', '4367', '265.67', '0.00', '265.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413752932419219456', '4366', '242.12', '0.00', '242.12', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413753039281680384', '4365', '31.40', '0.00', '31.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413753317204574208', '4368', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413753711972470784', '4370', '5.10', '0.00', '5.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413753870970232832', '4369', '45.83', '0.00', '45.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413754445820563456', '4371', '2.50', '0.00', '2.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413755652119093248', '4376', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413755918675521536', '4373', '2198.00', '0.00', '2198.00', '1', '2198.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413755949730168832', '4374', '3297.00', '0.00', '3297.00', '1', '3297.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413756074510749696', '4375', '179.00', '0.00', '179.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413756287677833216', '4377', '7.00', '3.17', '7.00', '1', '3.83', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413756983617679360', '4379', '174.17', '0.00', '174.17', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413757072092315648', '4380', '949.00', '0.00', '949.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413757408207138816', '4382', '5.00', '0.00', '5.00', '1', '5.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413757493515042816', '4383', '1199.00', '0.00', '1199.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413758155749543936', '4384', '35.20', '0.00', '35.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413758165065060352', '4385', '31.35', '0.00', '31.35', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413758480321536000', '4410', '313.56', '0.00', '313.56', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413758663214149632', '4387', '23.00', '0.00', '23.00', '1', '23.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413758810681741312', '4388', '81.32', '0.00', '81.32', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413758937714581504', '4389', '64.00', '0.00', '64.00', '1', '64.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:09', 'SYS', '2021-09-01 17:55:09', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413758983424069632', '4391', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413759060758728704', '4390', '56.55', '0.00', '56.55', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413759138634379264', '4392', '53.16', '0.00', '53.16', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413759313599746048', '4394', '48.00', '0.00', '48.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413759398656036864', '4393', '81.90', '0.00', '81.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413759979315494912', '4395', '548.67', '0.00', '548.67', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413760010621804544', '4397', '14.20', '0.00', '14.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413760231128870912', '4398', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413760550399336448', '4401', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413760726190993408', '4399', '544.44', '0.00', '544.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413760750828277760', '4400', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413761211518119936', '4403', '130.49', '0.00', '130.49', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413761596337098752', '4405', '379.00', '0.00', '379.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413762136722866176', '4412', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413762251936186368', '4406', '8.89', '5.97', '8.89', '1', '2.92', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413762366386167808', '4408', '24.05', '0.00', '24.05', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413762798340726784', '4407', '64.00', '0.00', '64.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413763231603912704', '4409', '22.30', '0.00', '22.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413764278439333888', '4411', '62.83', '0.00', '62.83', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413765229929709568', '4413', '14.40', '0.00', '14.40', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413765358845861888', '4415', '20.80', '0.00', '20.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413765369889542144', '4414', '0.20', '0.00', '0.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413765377766432768', '4425', '144.30', '0.00', '144.30', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413765733288140800', '4418', '0.60', '0.00', '0.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413765958304198656', '4416', '0.10', '0.00', '0.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413766339671293952', '4419', '129.00', '0.00', '129.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413766793989877760', '4420', '89.33', '0.00', '89.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413766903473876992', '4421', '79.00', '0.00', '79.00', '1', '79.00', '1', 'BOTH', '20210901', '202107', 'WXP', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413767157581524992', '4422', '64.33', '0.00', '64.33', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413767423043276800', '4423', '2.92', '0.00', '2.92', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413767574235316224', '4424', '1.60', '0.00', '1.60', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413768936780144640', '4426', '8.00', '0.00', '8.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413769155081060352', '4427', '78.66', '0.00', '78.66', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413769263289962496', '4428', '599.35', '0.00', '599.35', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413769321066434560', '4429', '9.50', '0.00', '9.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413770232912338944', '4431', '11.00', '0.00', '11.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413770249383313408', '4430', '1.10', '0.00', '1.10', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413770655928901632', '4432', '4.46', '0.00', '4.46', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413770948406075392', '4433', '254.19', '0.00', '254.19', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413770954936582144', '4434', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413771473558102016', '4436', '3.00', '0.00', '3.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413771550880124928', '4435', '33.90', '0.00', '33.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413773385120567296', '4437', '149.00', '0.00', '149.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413773446210584576', '4439', '212.50', '0.00', '212.50', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413773611415838720', '4438', '127.11', '0.00', '127.11', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413774460867231744', '4442', '1703.00', '0.00', '1703.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413774506098659328', '4441', '14.38', '0.00', '14.38', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413774508183244800', '4440', '168.44', '0.00', '168.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413774699598675968', '4443', '21.44', '0.00', '21.44', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413774820168146944', '4457', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413774933972144128', '4446', '174.08', '0.00', '174.08', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413775208086740992', '4444', '99.00', '0.00', '99.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413775235743965184', '4445', '79.00', '0.00', '79.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413775667232899072', '4447', '3.00', '0.00', '3.00', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413775828805902336', '4448', '3.20', '0.00', '3.20', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413776056648916992', '4450', '77.80', '0.00', '77.80', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `balance_summary` VALUES ('202107', 'WXP', '1413776103872589824', '4452', '478.90', '0.00', '478.90', '1', '0.00', '0', 'LEFT', '20210901', '-1', '$$$$', null, 'SYS', '2021-09-01 17:55:10', 'SYS', '2021-09-01 17:55:10', '0', null, null, null);
INSERT INTO `