package cn.quant.andy.util;

import cn.quant.andy.dict.BillCode;
import cn.quant.andy.jpa.entity.BalanceSummaryEntity;
import cn.quant.andy.jpa.entity.EntityConstant;
import cn.quant.andy.jpa.entity.InstitutionTransactionSummaryEntity;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * Created by Administrator on 2021/7/23 0023.
 */
public class TransactionBuilder {
    public static BalanceSummaryEntity createRightTransactionBalance(int summaryNo, InstitutionTransactionSummaryEntity entity) {
        if (entity.getTxnFlag().equals(EntityConstant.CREDIT_TXN_FLAG)) {
            throw new IllegalArgumentException("[ERROR]");
        }
        BalanceSummaryEntity balanceEntity = new BalanceSummaryEntity();
        balanceEntity.setSummaryNo(summaryNo);
        balanceEntity.setTermNo(entity.getTermNo());
        balanceEntity.setBaseCode(entity.getBaseCode());
        balanceEntity.setRtBaseCode(entity.getBaseCode());
        balanceEntity.setRtTermNo(entity.getTermNo());
        balanceEntity.setBaseOrderNo(entity.getBaseOrderNo());
        balanceEntity.setCloseBalance(entity.getPostAmt());
        balanceEntity.setBillCode(BillCode.RAIT.name());
        balanceEntity.setBillDate(LocalDate.now());
        balanceEntity.setOpenBalance(BigDecimal.ZERO);
        balanceEntity.setCreditAmt(BigDecimal.ZERO);
        balanceEntity.setCreditCount(0);
        balanceEntity.setDebitAmt(entity.getPostAmt());
        balanceEntity.setDebitCount(1);
        balanceEntity.setCreatedBy(EntityConstant.CREATED_BY_SYS);
        balanceEntity.setModifiedBy(EntityConstant.CREATED_BY_SYS);
        return balanceEntity;
    }

    public static BalanceSummaryEntity createLeftTransactionBalance(int summaryNo, InstitutionTransactionSummaryEntity entity) {
        if (entity.getTxnFlag().equals(EntityConstant.DEBIT_TXN_FLAG)) {
            throw new IllegalArgumentException("[ERROR]");
        }
        BalanceSummaryEntity balanceEntity = new BalanceSummaryEntity();
        balanceEntity.setSummaryNo(summaryNo);
        balanceEntity.setBaseCode(entity.getBaseCode());
        balanceEntity.setBaseOrderNo(entity.getBaseOrderNo());
        balanceEntity.setRtTermNo(EntityConstant.EMPTY_TERM_NO);
        balanceEntity.setRtBaseCode(EntityConstant.EMPTY_BASE_CODE);
        balanceEntity.setCloseBalance(BigDecimal.ZERO);
        balanceEntity.setBillCode(BillCode.LEFT.name());
        balanceEntity.setBillDate(LocalDate.now());
        balanceEntity.setOpenBalance(entity.getPostAmt());
        balanceEntity.setCreditAmt(entity.getPostAmt());
        balanceEntity.setCreditCount(1);
        balanceEntity.setDebitAmt(BigDecimal.ZERO);
        balanceEntity.setDebitCount(0);
        balanceEntity.setTermNo(entity.getTermNo());
        balanceEntity.setCreatedBy(EntityConstant.CREATED_BY_SYS);
        balanceEntity.setModifiedBy(EntityConstant.CREATED_BY_SYS);
        return balanceEntity;
    }
}
