package cn.quant.andy.config;

import cn.quant.andy.*;
import cn.quant.andy.jpa.entity.ApplicationProfileEntity;
import cn.quant.andy.jpa.entity.InstitutionProfileEntity;
import cn.quant.andy.jpa.model.ImportMapSchema;
import cn.quant.andy.jpa.mybatis.mapper.ApplicationProfileMapper;
import cn.quant.andy.jpa.mybatis.mapper.InstitutionProfileMapper;
import cn.quant.andy.jpa.mybatis.mapper.InstitutionTransactionSummaryMapper;
import cn.quant.andy.jpa.mybatis.mapper.TransactionSummaryMapper;
import cn.quant.andy.text.*;
import cn.quant.spring.context.ServerApplicationContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static cn.quant.andy.jpa.entity.EntityConstant.*;

/**
 * Created by Administrator on 2021/7/19 0019.
 */
@Configuration
public class ApplicationConfiguration {

    @Autowired
    private InstitutionProfileMapper institutionProfileMapper;

    @Autowired
    private ApplicationProfileMapper applicationProfileMapper;

    @Autowired
    private InstitutionTransactionSummaryMapper institutionTransactionSummaryMapper;

    @Autowired
    private TransactionSummaryMapper transactionSummaryMapper;

    @Autowired
    protected ServerApplicationContext serverApplicationContext;

    @PostConstruct
    public void init() {
        StringFormatter.register(PlaceholderSpiltFormatter.FORMATTER_TYPE + "-", new PlaceholderSpiltFormatter("-"));
        StringFormatter.register(DateStringFormatter.FORMATTER_TYPE, new DateStringFormatter());
        StringFormatter.register(BigDecimalFormatter.FORMATTER_TYPE, new BigDecimalFormatter());
        StringFormatter.register(IntStringFormatter.FORMATTER_TYPE, new IntStringFormatter());
    }

    private Map<String, SummaryRepository> repositories(List<ApplicationProfileEntity> entities) {
        //TODO: [hechao]waiting database config bean for mapper
        Map<String, SummaryRepository> repositories = new HashMap<>();
        for (ApplicationProfileEntity entity : entities) {
            if (INSTITUTION_TYPE_CODE.equals(entity.getTypeCode())) {
                SummaryRepository repository = new SummaryRepository(entity.getTableFields(), entity.getPostDateIndex(), institutionTransactionSummaryMapper, serverApplicationContext);
                repositories.put(entity.getTypeCode(), repository);
            } else if (PRODCT_TYPE_CODE.equals(entity.getTypeCode())) {
                SummaryRepository repository = new SummaryRepository(entity.getTableFields(), entity.getPostDateIndex(), transactionSummaryMapper, serverApplicationContext);
                repositories.put(entity.getTypeCode(), repository);
            }
        }
        return repositories;
    }

    @Bean
    public DataLoader dataLoader() {

//        InstitutionTransactionSummaryEntity oneById = institutionTransactionSummaryEntityMapper.findOneById(75590144801505280L);

        Map<String, SummaryRepository> repositories = repositories(applicationProfileMapper.findAll());

        SnapshotDataLoader loader = new SnapshotDataLoader();
        HashMap<String, Object> params = new HashMap<>();
        params.put(AVAILABLE_FLAG, true);
        List<InstitutionProfileEntity> profileEntities = institutionProfileMapper.findAll(params);
        for (InstitutionProfileEntity entity : profileEntities) {
            SnapshotDataOptions option = new SnapshotDataOptions();
            option.setName(entity.getBaseCode() + "-" + entity.getTypeCode());
            option.setAccountNo(entity.getAccountNo());
            option.setEndLine(entity.getEndLine());
            option.setImportFile(entity.getImportFile());
            option.setStartLine(entity.getStartLine());

            List<ImportMapSchema> schemas = entity.getImportDataSchema();

            SummaryHandler handler = new SummaryHandler(entity.getBaseCode(), entity.getDataPrefix());
            handler.setSchemas(schemas);

            SummaryRepository repository = repositories.get(entity.getTypeCode());
            if (repository == null) {
                throw new IllegalArgumentException("No such summary repository." + entity.getTypeCode());
            }
            handler.setRepository(repository);
            option.setHandler(handler);

            loader.setLoaderOptions(entity.getBaseCode() + "$" + entity.getTypeCode(), option);
        }
        repositories.clear();
        return loader;
    }


}
