package cn.quant.andy.text;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Administrator on 2021/7/19 0019.
 */
public class DateStringFormatter extends StringFormatter {

    public final static String FORMATTER_TYPE = "d";

    private Map<String, SimpleDateFormat> formats = new HashMap<>();

    Group format(String pattern, String text) throws ParseException {
        SimpleDateFormat format = formats.get(pattern);
        if (format == null) {
            format = new SimpleDateFormat(pattern);
            formats.put(pattern, format);
        }
        Group group = new Group();
        group.value = format.parse(text);
        return group;
    }
}
