package cn.quant.andy.jpa.entity;

import cn.quant.spring.data.jpa.entity.DescriptionEntity;
import cn.quant.spring.util.StringUtils;

import javax.persistence.Column;
import javax.persistence.Id;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;
import java.util.Objects;

public class TransactionSummaryEntity extends DescriptionEntity{
    @Id
    @Column(name = "TRANSACTION_ID", nullable = false, updatable = false)
    private Long transactionId;

    @Column(name = "BASE_ORDER_NO", nullable = false, updatable = false)
    private String baseOrderNo;

    @Column(name = "TERM_NO", nullable = false, updatable = false)
    private Integer termNo;

    @Column(name = "BASE_CODE", nullable = false, updatable = false)
    private String baseCode;

    @Column(name = "ORDER_NO", nullable = false, updatable = false)
    private String orderNo;

    @Column(name = "GEN_ORDER_NO", nullable = false, updatable = false)
    private String genOrderNo;

    @Column(name = "ROOT_FLAG", nullable = false, updatable = false)
    private String rootFlag;

    @Column(name = "VOLUME", nullable = false, updatable = false)
    private Integer volume;

    @Column(name = "SERIAL_NO", nullable = false, updatable = false)
    private String serialNo;

    @Column(name = "TXN_CODE", nullable = false, updatable = false)
    private String txnCode;

    @Column(name = "TXN_TYPE", nullable = false, updatable = false)
    private String txnType;

    @Column(name = "TXN_FLAG", nullable = false, updatable = false)
    private String txnFlag;

    @Column(name = "ORIGINAL_AMT", nullable = false, updatable = false)
    private BigDecimal originalAmt;

    @Column(name = "POST_AMT", nullable = false, updatable = false)
    private BigDecimal postAmt;

    @Column(name = "POST_DATE", nullable = false, updatable = false)
    private LocalDate postDate;

    @Column(name = "POST_TIME", nullable = false, updatable = false)
    private LocalTime postTime;

    @Column(name = "TXN_TIME", nullable = false, updatable = false)
    private Date txnTime;

    @Column(name = "IMPORT_TIME", nullable = false, updatable = false)
    private Date importTime;


    @Column(name = "POSTED_FLAG", nullable = false, updatable = true)
    private Boolean postedFlag;


    public Long getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(Long transactionId) {
        this.transactionId = transactionId;
    }

    public String getBaseOrderNo() {
        return baseOrderNo;
    }

    public void setBaseOrderNo(String baseOrderNo) {
        this.baseOrderNo = baseOrderNo;
    }

    public Integer getTermNo() {
        return termNo;
    }

    public void setTermNo(Integer termNo) {
        this.termNo = termNo;
    }

    public String getBaseCode() {
        return baseCode;
    }

    public void setBaseCode(String baseCode) {
        this.baseCode = baseCode;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getGenOrderNo() {
        return genOrderNo;
    }

    public void setGenOrderNo(String genOrderNo) {
        this.genOrderNo = genOrderNo;
    }

    public String getRootFlag() {
        return rootFlag;
    }

    public void setRootFlag(String rootFlag) {
        this.rootFlag = rootFlag;
    }

    public Integer getVolume() {
        return volume;
    }

    public void setVolume(Integer volume) {
        this.volume = volume;
    }

    public String getSerialNo() {
        return serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public String getTxnCode() {
        return txnCode;
    }

    public void setTxnCode(String txnCode) {
        this.txnCode = txnCode;
    }

    public String getTxnType() {
        return txnType;
    }

    public void setTxnType(String txnType) {
        this.txnType = txnType;
    }

    public String getTxnFlag() {
        return txnFlag;
    }

    public void setTxnFlag(String txnFlag) {
        this.txnFlag = txnFlag;
    }

    public BigDecimal getOriginalAmt() {
        return originalAmt;
    }

    public void setOriginalAmt(BigDecimal originalAmt) {
        this.originalAmt = originalAmt;
    }

    public BigDecimal getPostAmt() {
        return postAmt;
    }

    public void setPostAmt(BigDecimal postAmt) {
        this.postAmt = postAmt;
    }

    public LocalDate getPostDate() {
        return postDate;
    }

    public void setPostDate(LocalDate postDate) {
        this.postDate = postDate;
    }

    public LocalTime getPostTime() {
        return postTime;
    }

    public void setPostTime(LocalTime postTime) {
        this.postTime = postTime;
    }

    public Date getTxnTime() {
        return txnTime;
    }

    public void setTxnTime(Date txnTime) {
        this.txnTime = txnTime;
    }

    public Date getImportTime() {
        return importTime;
    }

    public void setImportTime(Date importTime) {
        this.importTime = importTime;
    }

    public Boolean getPostedFlag() {
        return postedFlag;
    }

    public void setPostedFlag(Boolean postedFlag) {
        this.postedFlag = postedFlag;
    }

    @Override
    public String persistenceKey() {
        return StringUtils.toDelimitedString(TransactionSummaryEntity.class, transactionId);
    }
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof TransactionSummaryEntity)) return false;
        TransactionSummaryEntity that = (TransactionSummaryEntity) o;
        return Objects.equals(transactionId, that.transactionId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(TransactionSummaryEntity.class, transactionId);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("TransactionSummaryEntity{");
        sb.append("transactionId=").append(transactionId);
        sb.append(", baseOrderNo='").append(baseOrderNo).append('\'');
        sb.append(", termNo=").append(termNo);
        sb.append(", baseCode='").append(baseCode).append('\'');
        sb.append(", orderNo='").append(orderNo).append('\'');
        sb.append(", genOrderNo='").append(genOrderNo).append('\'');
        sb.append(", rootFlag='").append(rootFlag).append('\'');
        sb.append(", volume=").append(volume);
        sb.append(", serialNo='").append(serialNo).append('\'');
        sb.append(", txnCode='").append(txnCode).append('\'');
        sb.append(", txnType='").append(txnType).append('\'');
        sb.append(", txnFlag='").append(txnFlag).append('\'');
        sb.append(", originalAmt=").append(originalAmt);
        sb.append(", postAmt=").append(postAmt);
        sb.append(", postDate=").append(postDate);
        sb.append(", postTime=").append(postTime);
        sb.append(", txnTime=").append(txnTime);
        sb.append(", importTime=").append(importTime);
        sb.append(", postedFlag=").append(postedFlag);
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }


}