select
    dw_order.USER_UUID AS                                                                                             "用户UUID"
    ,CONCAT('#',CAST(MAX(dw_order.ROOT_ORDER_NO) AS varchar)) AS                                                      "根订单号"
    ,COUNT(1) AS                                                                                                        "聚合总条数"
    ,SUM(dw_order.MALL_SALE_COUNT) AS                                                                                 "商城退货数量"
    ,SUM(dw_order.MALL_SKU_FREIGHT_FEE) AS                                                                            "商城运费金额"
    ,SUM(dw_order.MALL_SKU_FREIGHT_DEDUCTION_FEE) AS                                                                  "商城运费抵扣金额"
    ,SUM(dw_order.MALL_SKU_CASH_COUPON_DEDUCTION_FEE) AS                                                              "商城现金抵扣金额"
    ,SUM(dw_order.MALL_SKU_COUPON_DEDUCTION_FEE) AS                                                                   "商城优惠券抵扣金额"
    ,SUM(dw_order.MALL_SKU_ACTIVITY_DEDUCTION_FEE) AS                                                                 "商城活动抵扣金额"
    ,SUM(dw_order.MALL_SKU_REFUND_AMT) AS                                                                             "商城退款金额"
    ,MAX(dw_order.MALL_CREATED_AT) AS                                                                                 "商城最早创建时间"
    ,MIN(dw_order.MALL_CREATED_AT) AS                                                                                 "商城最后创建时间"
    ,'||||' AS                                                                                                          "-"
    ,CONCAT('#',CAST(dw_order.PS_ORDER_NO AS varchar)) AS                                                             "支付根订单号"
    ,SUM(dw_order.PS_MALL_SKU_AMT_FREIGHT) AS                                                                         "支付记运费金额"
    ,SUM(dw_order.PS_MALL_SKU_AMT_DEDUCT_FREIGHT) AS                                                                  "支付记运费抵扣金额"
    ,SUM(dw_order.PS_MALL_SKU_AMT_DEDUCT_CASH_COUPON) AS                                                              "支付记现金抵扣金额"
    ,SUM(dw_order.PS_MALL_SKU_AMT_DEDUCT_COUPON) AS                                                                   "支付记优惠券抵扣金额"
    ,SUM(dw_order.PS_MALL_SKU_AMT_DEDUCT_ACTIVITY) AS                                                                 "支付记活动抵扣金额"
    ,SUM(dw_order.PS_SKU_AMT_DEDUCT_PAY_COUPON) AS                                                                    "支付优惠抵扣金额"
    ,case AVG(dw_order.PS_TRADE_MOTHOD)
        WHEN 1 THEN
        'VCC'
        WHEN 2 THEN
        '微信支付'
        WHEN 3 THEN
        '支付宝支付'
        WHEN 4 THEN
        'VCC&微信'
        WHEN 5 THEN
        'VCC&支付宝'
        ELSE
        CAST(AVG(dw_order.PS_TRADE_MOTHOD) AS varchar)
        END AS                                                                                                          "支付方式"
    ,SUM(dw_order.PS_SKU_VCC_AMT) AS                                                                                  "支付VCC退款金额"
    ,SUM(dw_order.PS_SKU_WX_AMT) AS                                                                                   "支付微信退款金额"
    ,SUM(dw_order.PS_SKU_ZFB_AMT) AS                                                                                  "支付支付宝退款金额"
    ,SUM(dw_order.PS_SKU_REFUND_CASH_DEDUCT_AMOUNT) AS                                                                "支付代金券退款金额"
    ,SUM(dw_order.PS_SKU_REFUND_AMT) AS                                                                               "支付应退金额"
    ,SUM(dw_order.PS_TOTAL_AMT) AS                                                                                    "实退金额"
    ,CAST((SUM(dw_order.MALL_SKU_REFUND_AMT)-SUM(dw_order.PS_SKU_AMT_DEDUCT_PAY_COUPON)
        -SUM(dw_order.PS_TOTAL_AMT))  AS DECIMAL(13,3)) AS                                                            "检测余额"
from(
    select
        sku_detail.USER_UUID AS                                                                     "USER_UUID"                        				--"用户UUID"
        ,MAX(sku_detail.ROOT_ORDER_NO) AS                              								"ROOT_ORDER_NO"                        			--"根订单号"
        ,MAX(sku_detail.MALL_SALE_COUNT) AS                                                         "MALL_SALE_COUNT"                        		--"商城订单销售SKU数量"
        ,MAX(sku_detail.MALL_SKU_PRIME_COSTS) AS                                                    "MALL_SKU_PRIME_COSTS"                        	--"商城SKU供货价"
        ,MAX(sku_detail.MALL_SKU_SALE_PRICE) AS                                                     "MALL_SKU_SALE_PRICE"                        	--"商城SKU销售价"
        ,MAX(sku_detail.MALL_SKU_FREIGHT_FEE) AS                                                    "MALL_SKU_FREIGHT_FEE"                       	--"商城SKU运费金额"
        ,MAX(sku_detail.MALL_SKU_FREIGHT_DEDUCTION_FEE) AS                                          "MALL_SKU_FREIGHT_DEDUCTION_FEE"                --"商城SKU运费抵扣金额"
        ,MAX(sku_detail.MALL_SKU_CASH_COUPON_DEDUCTION_FEE) AS                                      "MALL_SKU_CASH_COUPON_DEDUCTION_FEE"            --"商城SKU现金抵扣金额"
        ,MAX(sku_detail.MALL_SKU_COUPON_DEDUCTION_FEE) AS                                           "MALL_SKU_COUPON_DEDUCTION_FEE"                 --"商城SKU优惠券抵扣金额"
        ,MAX(sku_detail.MALL_SKU_ACTIVITY_DEDUCTION_FEE) AS                                         "MALL_SKU_ACTIVITY_DEDUCTION_FEE"              	--"商城SKU活动抵扣金额"
        ,MAX(sku_detail.MALL_SKU_REFUND_AMT) AS                                                     "MALL_SKU_REFUND_AMT"                       	--"商城SKU退款金额"
        ,MAX(sku_detail.MALL_CREATED_AT) AS                                                         "MALL_CREATED_AT"                       		--"商城订单创建时间"
        ,sku_detail.PS_ORDER_NO AS                                     					            "PS_ORDER_NO"                       			--"支付根订单号"
        ,sku_detail.PS_SKU_NO AS                                       								"PS_SKU_NO"                       				--"支付SKU号"
        ,AVG(sku_detail.PS_TRADE_MOTHOD) AS                                                    		"PS_TRADE_MOTHOD"                       		--"支付方式"
        ,SUM(sku_detail.PS_MALL_SKU_AMT_FREIGHT) AS                                                 "PS_MALL_SKU_AMT_FREIGHT"                       --"支付记SKU运费金额"
        ,SUM(sku_detail.PS_MALL_SKU_AMT_DEDUCT_FREIGHT) AS                                          "PS_MALL_SKU_AMT_DEDUCT_FREIGHT"                --"支付记SKU运费抵扣金额"
        ,SUM(sku_detail.PS_MALL_SKU_AMT_DEDUCT_CASH_COUPON) AS                                      "PS_MALL_SKU_AMT_DEDUCT_CASH_COUPON"            --"支付记SKU现金抵扣金额"
        ,SUM(sku_detail.PS_MALL_SKU_AMT_DEDUCT_COUPON) AS                                           "PS_MALL_SKU_AMT_DEDUCT_COUPON"                 --"支付记SKU优惠券抵扣金额"
        ,SUM(sku_detail.PS_MALL_SKU_AMT_DEDUCT_ACTIVITY) AS                                         "PS_MALL_SKU_AMT_DEDUCT_ACTIVITY"               --"支付记SKU活动抵扣金额"
        ,SUM(sku_detail.PS_SKU_AMT_DEDUCT_PAY_COUPON) AS                                            "PS_SKU_AMT_DEDUCT_PAY_COUPON"                  --"支付SKU优惠抵扣金额"
        ,MAX(sku_detail.PS_SKU_VCC_AMT) AS                                                          "PS_SKU_VCC_AMT"                       			--"支付SKU_VCC退款金额"
        ,MAX(sku_detail.PS_SKU_WX_AMT) AS                                                           "PS_SKU_WX_AMT"                       			--"支付SKU微信退款金额"
        ,MAX(sku_detail.PS_SKU_ZFB_AMT) AS                                                          "PS_SKU_ZFB_AMT"                       			--"支付SKU支付宝退款金额"
        ,MAX(sku_detail.PS_SKU_REFUND_CASH_DEDUCT_AMOUNT) AS                                        "PS_SKU_REFUND_CASH_DEDUCT_AMOUNT"              --"支付SKU代金券退款金额"
        ,SUM(sku_detail.PS_SKU_REFUND_AMT) AS                                                       "PS_SKU_REFUND_AMT"                       		--"支付SKU应退金额"
        ,MAX(sku_detail.PS_TOTAL_AMT) AS                                                            "PS_TOTAL_AMT"                       			--"支付SKU实退金额"
        ,MAX(sku_detail.PS_CREATED_AT) AS                                                           "PS_CREATED_AT"                       			--"支付订单创建时间"
    from(
        select
            dw_ps_order.user_uuid AS                                                                    "USER_UUID"
            ,kdsp_order.root_order_no AS                                                                "ROOT_ORDER_NO"
            ,kdsp_order.order_no AS                                                                     "SUB_ORDER_NO"
            ,kdsp_order.channel_id AS                                                                   "MALL_CHANNEL_ID"                                   --商城销售渠道ID
            ,kdsp_order.CHANNEL_NAME AS                                                                 "MALL_CHANNEL_NAME"                                 --商城销售渠道
            ,kdsp_order.SKU_NO AS                                                                       "MALL_SKU_NO"										--商城SKU号
            ,kdsp_order.categroy_name1 AS                                                               "MALL_CATEGROY1"                                    --商城一级品类
            ,kdsp_order.categroy_name2 AS                                                               "MALL_CATEGROY2"                                    --商城二级品类
            ,kdsp_order.categroy_name3 AS                                                               "MALL_CATEGROY3"									--商城三级品类
            ,kdsp_order.sku_name AS                                                                     "MALL_SKU_NAME"									    --商城SKU名称
            ,kdsp_order.sku_source AS                                                                   "MALL_SKU_SOURCE"                                   --商城商品来源
            -- ,kdsp_order.ORDER_PAY_AMOUNT AS                                                             "MALL_ORDER_PAY_AMOUNT"								--商城订单退款金额
            ,kdsp_order.order_status AS                                                                 "MALL_ORDER_STATUS"									--商城订单状态
            ,kdsp_order.price AS                                                                        "MALL_SKU_SALE_PRICE"                               --商城SKU销售价
            ,kdsp_order.cost_price AS                                                                   "MALL_SKU_PRIME_COSTS"                              --商城SKU供货单价
            ,kdsp_order.pay_status AS                                                                   "MALL_PAY_STATUS"									--商城支付状态
            ,kdsp_order.sale_count AS                                                                   "MALL_SALE_COUNT"									--商城SKU退货数量
            ,kdsp_order.freight_fee AS                                                                  "MALL_SKU_FREIGHT_FEE"                              --商城SKU运费金额
            ,kdsp_order.freight_deduction_fee AS                                                        "MALL_SKU_FREIGHT_DEDUCTION_FEE"                    --商城SKU运费抵扣金额
            ,kdsp_order.cash_coupon_deduction_fee AS                                                    "MALL_SKU_CASH_COUPON_DEDUCTION_FEE"                --商城SKU现金抵扣金额
            ,kdsp_order.coupon_deduction_fee AS                                                         "MALL_SKU_COUPON_DEDUCTION_FEE"                     --商城SKU优惠券抵扣金额
            ,kdsp_order.fr_activity_deduction_fee AS                                                    "MALL_SKU_ACTIVITY_DEDUCTION_FEE"                   --商城SKU活动抵扣金额
            ,kdsp_order.pay_amount AS                                                                   "MALL_SKU_REFUND_AMT"								--商城SKU退款金额
            ,kdsp_order.after_create_time AS                                                            "MALL_SKU_AFT_TIME"									--商城SKU售后时间
            ,kdsp_order.created_at AS                                                                   "MALL_CREATED_AT"									--商城订单创建时间
            -- ,IF(kdsp_order.pay_amount=0,1,0) AS                                                         "MALL_CANCEL_FLAG"                                  --商城支付取消标记
            ,dw_ps_order.PS_ORDER_NO AS                                                                 "PS_ORDER_NO"										--支付根订单号
            ,dw_ps_order.PS_REFUND_FLOW_NO AS                                                           "PS_REFUND_FLOW_NO"								    --支付退款流水号
            ,dw_ps_order.VCC_REFUND_FLOW_NO AS                                                          "VCC_REFUND_FLOW_NO"								--VCC退款流水号
            -- ,dw_ps_order.PS_REFUND_FLOW_ORDER_NO AS                                                     "PS_REFUND_FLOW_ORDER_NO"
            ,dw_ps_order.PS_OUT_REFUND_ORDER_NO AS                                                      "PS_OUT_REFUND_ORDER_NO"
            ,dw_ps_order.PS_SKU_NO AS                                                                   "PS_SKU_NO"											--支付SKU号
            ,dw_ps_order.PS_CREATED_AT AS                                                               "PS_CREATED_AT"										--支付订单创建时间
            ,dw_ps_order.PS_TRADE_MOTHOD AS                                                             "PS_TRADE_MOTHOD"                                   --1:VCC，2:微信支付 ,3:支付宝支付, 4:VCC+WX，5:VCC+AliPay
            ,(CAST(gsinf.amt_freight AS double)/100) AS                                                 "PS_MALL_SKU_AMT_FREIGHT"                           --支付SKU运费金额
            ,(CAST(gsinf.amt_freight_deduct AS double)/100) AS                                          "PS_MALL_SKU_AMT_DEDUCT_FREIGHT"                    --支付SKU运费抵扣金额
            ,(CAST(gsinf.amt_cash_coupon_deduct AS double)/100) AS                                      "PS_MALL_SKU_AMT_DEDUCT_CASH_COUPON"                --支付SKU现金抵扣金额
            ,(CAST(gsinf.amt_coupon_deduct AS double)/100) AS                                           "PS_MALL_SKU_AMT_DEDUCT_COUPON"                     --支付SKU优惠券抵扣金额
            ,(CAST(gsinf.amt_activity_deduct AS double)/100) AS                                         "PS_MALL_SKU_AMT_DEDUCT_ACTIVITY"                   --支付SKU活动抵扣金额
            ,(CAST(gsinf.amt_deduct_pay_coupon AS double)/100) AS                                       "PS_SKU_AMT_DEDUCT_PAY_COUPON"                      --支付SKU优惠抵扣金额
            ,dw_ps_order.PS_VCC_AMT AS                                                                  "PS_SKU_VCC_AMT"									--支付SKU_VCC退款金额
            ,dw_ps_order.PS_WX_AMT AS                                                                   "PS_SKU_WX_AMT"										--支付SKU微信退款金额
            ,dw_ps_order.PS_ZFB_AMT AS                                                                  "PS_SKU_ZFB_AMT"									--支付SKU支付宝退款金额
            ,dw_ps_order.PS_SKU_REFUND_CASH_DEDUCT_AMOUNT AS                                            "PS_SKU_REFUND_CASH_DEDUCT_AMOUNT"					--支付SKU代金券退款金额
            ,CAST(gsinf.amt_need_pay AS double)/100 AS                                                  "PS_SKU_REFUND_AMT"									--支付SKU应退金额
            ,dw_ps_order.PS_VCC_AMT+dw_ps_order.PS_WX_AMT+dw_ps_order.PS_ZFB_AMT AS                     "PS_TOTAL_AMT"										--实退金额
            ,CAST((kdsp_order.cost_price*kdsp_order.sale_count) AS DECIMAL(13,3)) AS                    "MALL_SKU_TOTAL_PRIME_COSTS"                        --供货成本
            ,kdsp_order.after_refund_amount AS                                                          "MALL_SKU_AFT_AMT"									--售后金额
            ,kdsp_order.after_flag AS                                                                   "MALL_SKU_AFT_FLAG"									--售后标记

        from(
            select
                rfd.user_uuid AS                                                                            "USER_UUID"
                ,rfd.order_no AS                                                                            "PS_ORDER_NO"
                ,COUNT(1) AS                                                                                "PS_AGG_COUNT"
                ,MAX(IF(rfd.trade_type=1,rfd.refund_flow_no,NULL)) AS                                       "VCC_REFUND_FLOW_NO"
                ,MAX(IF(rfd.trade_type<>1,rfd.refund_flow_no,NULL)) AS                                      "PS_REFUND_FLOW_NO"
                -- ,MAX(rfd.refund_flow_order_no) AS                                                           "PS_REFUND_FLOW_ORDER_NO"
                ,rfd.out_refund_order_no AS                                                                 "PS_OUT_REFUND_ORDER_NO"
                ,rfd.SKU_NO AS                                                                              "PS_SKU_NO"
                ,avg(rfd.trade_method) AS                                                                   "PS_TRADE_MOTHOD"                                   --1:VCC，2:微信支付 ,3:支付宝支付, 4:VCC+WX，5:VCC+AliPay
                ,MAX(case rfd.trade_type
                    when 1 then
                    CAST(rfd.refund_amount AS DECIMAL (13, 3)) / 100
                    else
                    0.0
                    end) AS                                                                                 "PS_VCC_AMT"
                ,MAX(case rfd.trade_type
                    when 2 then
                    CAST(rfd.refund_amount AS DECIMAL (13, 3)) / 100
                    else
                    0.0
                    end) AS                                                                                 "PS_WX_AMT"
                ,MAX(case rfd.trade_type
                    when 3 then
                    CAST(rfd.refund_amount AS DECIMAL (13, 3)) / 100
                    else
                    0.0
                    end) AS                                                                                 "PS_ZFB_AMT"
                ,MAX(IF(rfd.refund_cash_deduct_amount IS NULL,0
                    ,CAST(rfd.refund_cash_deduct_amount AS DECIMAL (13, 3)) / 100)) AS                      "PS_SKU_REFUND_CASH_DEDUCT_AMOUNT"
                ,MAX(rfd.created_at) AS                                                                     "PS_CREATED_AT"
            from
                ods_pay_service.log_refund_request rfd
            where
                rfd.status=3
                and rfd.CREATED_AT>={{start_date}}
                and rfd.CREATED_AT<{{end_date}}
                [[and rfd.order_no={{order_no}}]]
                -- and rfd.order_no IN (
                    -- '1448781901853765632', '1400349830152372224', '1454785610022817792', '1449762235525353472', '1447734934503657472',
                    -- ,'1454635102310215680','1454469112154750976',
                    -- '1440113196169129984'
                    -- '1446499166695075840','1447587623903395840','1450808948969103360'
                -- )
            group by
                rfd.user_uuid
                ,rfd.order_no
                ,rfd.out_refund_order_no
                ,rfd.SKU_NO
        ) dw_ps_order
            left join ods_pay_service.order_goods_info gsinf on gsinf.order_no=dw_ps_order.PS_ORDER_NO and gsinf.SKU_NO=dw_ps_order.PS_SKU_NO
            left join (
            select
                oinf.user_id
                ,case
                when oinf.root_order_no IS NULL then
                oinf.order_no
                else
                oinf.root_order_no
                end root_order_no                                                                   --跟单号
                ,oinf.order_no                                                                      --子单号
                ,oinf.order_status                                                                  --订单状态，11-待付款 12-待发货 13-待收货 14-发货中 21-订单完成 31-订单已付款主动取消 32-订单已付款自动取消 33-订单拒收取消 36-订单已付款充值失败取消 41-已付款主动取消退款完成订单关闭 42-已付款自动取消退款完成订单关闭 43-订单未支付主动取消订单关闭 44-订单超时未支付订单关闭 45-订单拒收退款订单关闭 46-订单已付款充值失败已退款订单关闭 51-订单拆单关闭
                ,oinf.pay_status                                                                    --支付状态，1-未支付 2-支付中 3-支付成功 4-支付失败 5-待退款 6-退款中 7-已退款
                ,oinf.order_time                                                                    --下单时间
                ,oinf.order_complete_time                                                           --订单完成时间
                ,oinf.pay_type                                                                      --支付方式 1-微信支付 2-信用支付 3-支付宝支付 4-组合支付(信用和微信) 5-组合支付(信用和支付宝)
                ,oinf.pay_time                                                                      --支付时间
                ,oinf.delivery_at                                                                   --发货时间
                ,oinf.delivery_status                                                               --运单状态 1-未出库 2-已出库 3-已妥投
        		,oinf.channel_id								                                    --销售渠道ID
        		,ka.CHANNEL_NAME AS "CHANNEL_NAME"                                                  --销售渠道
        		,oinf.created_at                                                                    --订单创建时间
        		,oinf.pay_amount AS "ORDER_PAY_AMOUNT"                                                --商品SKU支付金额
            	,gcat1.CATEGROY_NAME AS "categroy_name1"                                            --一级品类
            	,gcat2.CATEGROY_NAME AS "categroy_name2"                                            --二级品类
            	,gcat3.CATEGROY_NAME AS "categroy_name3"                                            --三级品类
                ,osku.id as "order_sku_id"                                                          --t_order_sku主键ID
                ,osku.sku_source                                                                    --商品来源 1-自营 2-京东开普勒 3-京东联盟 4-众联 5-企业购 6-企业购直连
                ,osku.sku_no                                                                        --商品SKU号
                ,osku.sku_id                                                                        --商品SKU ID
                ,osku.sku_name                                                                      --商品SKU名称
                ,sinf.BRAND_NAME                                                                    --商品品牌
                ,osku.shop_id                                                                       --商品店铺ID
                ,osku.shop_name                                                                     --商品店铺名称
                ,osku.price                                                                         --商品销售单价
                ,osku.cost_price                                                                    --商品成本价
                ,osku.amount                                                                        --商品应付金额
                ,osku.pay_amount                                                                    --商品实付金额
                ,osku.count as "sale_count"                                                         --商品单笔销售数量
                ,osku.freight_deduction_fee                                                         --商品运费抵扣金额
                ,osku.coupon_deduction_fee                                                          --商品优惠券抵扣金额
                ,osku.cash_coupon_deduction_fee                                                     --商品现金抵扣金额
                ,osku.fr_activity_deduction_fee                                                     --商品满减抵扣金额
                ,osku.freight_fee                                                                   --商品运费金额
                ,IF(aft.order_no IS NOT NULL, 1, 0) as "after_flag"                                 --售后标记
                ,IF(aft.refund_amount IS NOT NULL,aft.refund_amount,0) as "after_refund_amount"     --售后金额
                ,aft.created_at as "after_create_time"                                              --售后时间
            from
                ods_kdsp.t_order_info oinf
                left join ods_kdsp.t_order_sku osku ON oinf.id = osku.order_info_id
                left join ods_kdsp.t_sku_info sinf ON sinf.sku_no=osku.sku_no
                left join ods_kdsp.t_goods_rear_category gcat1 ON gcat1.categroy_id=sinf.c_id1
                left join ods_kdsp.t_goods_rear_category gcat2 ON gcat2.categroy_id=sinf.c_id2
                left join ods_kdsp.t_goods_rear_category gcat3 ON gcat3.categroy_id=sinf.c_id3
                left join ods_kdsp.t_ka_channel_info ka ON CAST(ka.channel_no as varchar)=oinf.channel_id
                left join (
                    select
                    after.*
                    from
                    ods_kdsp.t_after_service_apply after
                    where
                    after.deal_status=70
                    and after.CREATED_AT>=DATE_ADD('MONTH',-1,{{start_date}})
                    and after.CREATED_AT<{{end_date}}
                ) aft ON aft.order_no = osku.order_no and aft.order_sku_id=osku.id
            where
                oinf.pay_amount<>0
                and oinf.order_status NOT IN(51)                                    --不取拆单的
                -- and oinf.pay_status IN(3,7)                                     --1-未支付 2-支付中 3-支付成功 4-支付失败 5-待退款 6-退款中 7-已退款
                and oinf.created_at>=DATE_ADD('MONTH',-1,{{start_date}})        --取向前一个月的订单信息防止跨月
                and (oinf.pay_status=7 OR (oinf.pay_status=3 and aft.order_no IS NOT NULL))
            ) kdsp_order ON kdsp_order.root_order_no=dw_ps_order.PS_ORDER_NO and kdsp_order.sku_no=dw_ps_order.PS_SKU_NO
    ) sku_detail
    group by
        sku_detail.USER_UUID
        ,sku_detail.PS_ORDER_NO
        ,sku_detail.PS_SKU_NO
        ,sku_detail.SUB_ORDER_NO
) dw_order
group by
    dw_order.USER_UUID
    ,dw_order.PS_ORDER_NO
order by
    dw_order.USER_UUID