package cn.quant.andy.aspect;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * Created by Administrator on 2021/7/25 0025.
 */
@Aspect
@Component
public class ExplainAspect {

    private static final Logger logger = LoggerFactory.getLogger(ExplainAspect.class);

    @Pointcut("@annotation(cn.quant.andy.aspect.ExplainPoint)")
    private void pointCut() {
    }

    @Around("pointCut()")
    private Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        long time = System.currentTimeMillis();
        int code = Objects.hashCode(joinPoint);
        logger.info("!> [{}{}]Start process '{}'", time, code, joinPoint.getSignature());
        try {
            Object object = joinPoint.proceed();
            return object;
        } finally {
            logger.info("<! [{}{}]End process. {}", time, code, System.currentTimeMillis() - time);
        }
    }
}
