package cn.quant.andy.util;

import cn.quant.andy.dict.BillCode;
import cn.quant.andy.dict.BillStatusCode;
import cn.quant.andy.dict.TxnStatusCode;
import cn.quant.andy.jpa.entity.BalanceBillingEntity;
import cn.quant.andy.jpa.entity.BalanceSummaryEntity;
import cn.quant.andy.jpa.entity.EntityConstant;
import cn.quant.andy.jpa.entity.InstitutionTransactionSummaryEntity;

/**
 * Created by Administrator on 2021/7/25 0025.
 */
public class BalanceUtils {
    public static void refresh(BalanceBillingEntity entity, BillStatusCode code) {
        entity.setLastStatusCode(entity.getStatusCode());
        entity.setStatusCode(code.name());
        entity.setBalance(entity.getCreditAmt().subtract(entity.getDebitAmt()));
    }

    public static void billing(BalanceBillingEntity bill, InstitutionTransactionSummaryEntity summary) {
        if (EntityConstant.DEBIT_TXN_FLAG.equals(summary.getTxnFlag())) {
            bill.setDebitAmt(bill.getDebitAmt().add(summary.getPostAmt()));
            bill.setDebitCount(bill.getDebitCount() + 1);
        } else if (EntityConstant.CREDIT_TXN_FLAG.equals(summary.getTxnFlag())) {
            bill.setCreditAmt(bill.getCreditAmt().add(summary.getPostAmt()));
            bill.setCreditCount(bill.getCreditCount() + 1);
        }
        bill.setTotalBills(bill.getTotalBills() + 1);
    }

    public static int nextSummaryNo(BalanceBillingEntity entity) {
        int i = entity.getNextSummaryNo() + 1;
        entity.setNextSummaryNo(i);
        return i;
    }

    public static int addTotalBills(BalanceBillingEntity entity, int num) {
        int i = entity.getTotalBills() + num;
        entity.setTotalBills(i);
        return i;
    }

    public static int nextLfFailedBills(BalanceBillingEntity entity) {
        int i = entity.getLfFailedBills() + 1;
        entity.setLfFailedBills(i);
        return i;
    }

    public static int nextRtFailedBills(BalanceBillingEntity entity) {
        int i = entity.getRtFailedBills() + 1;
        entity.setRtFailedBills(i);
        return i;
    }

    public static void billCode(BalanceSummaryEntity entity, InstitutionTransactionSummaryEntity left, InstitutionTransactionSummaryEntity right) {
        String lf = left.getStatusCode();
        String rt = right.getStatusCode();
        if (TxnStatusCode.SUCC.equals(lf)) {
            if (TxnStatusCode.SUCC.equals(rt)) {
                entity.setBillCode(BillCode.BOTH.name());
            } else {
                entity.setBillCode(BillCode.DSRT.name());
            }
            return;
        } else if (TxnStatusCode.SUCC.equals(rt)) {
            entity.setBillCode(BillCode.DSLF.name());
            return;
        }
        entity.setBillCode(BillCode.DSBS.name());
    }

    public static void refresh(BalanceSummaryEntity entity) {
        entity.setCloseBalance(entity.getCreditAmt().subtract(entity.getDebitAmt()));
    }
}
