package cn.quant.andy;

import cn.quant.spring.util.ServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * <p>Application VM Option:<br/>
 * <code>--spring.config.file=${project.build.directory}/config/application-dev.properties </code><br/>
 * <code>-Dlogging.config=${project.build.directory}/config/logback-spring.xml</code></p>
 * <p>Enable Mybatis Annotation:<br/>
 * <code>@org.mybatis.spring.annotation.MapperScan("cn.quant.andy.mapper")</code></p>
 * <p>Enable Dubbo Annotation: <br/>
 * <code>@org.springframework.context.annotation.ImportResource(locations = {"classpath:application-dubbo.xml"})</code></p>
 * <p>Enable JPA Annotation:<br/>
 * <code>@EntityScan("cn.quant.andy.jpa.entity")</code><br/>
 * <code>@org.springframework.data.jpa.repository.config.EnableJpaRepositories("cn.quant.andy.jpa.repository")</code></p>
 * <p>Enable Auditor Aware Annotation:<br/>
 * <code>@org.springframework.data.jpa.repository.config.EnableJpaAuditing(auditorAwareRef = "auditorAwareHandler")</code></p>
 * Created by hechao on 2020/1/22.<br/>
 */
@ComponentScan
@SpringBootApplication
@EnableAutoConfiguration
@PropertySource(value = {"classpath:config/bootstrap.yml"
        , "classpath:config/application.yml"
        , "file:${spring.config.file}"})
public class ScheduleApplication {

    @Inject
    private ApplicationContext context;

    @PostConstruct
    private void init() throws Exception {
        Environment environment = context.getEnvironment();
        Logger logger = LoggerFactory.getLogger(ScheduleApplication.class);
        logger.info(
                "\n---Schedule--------------------------------------------------------------\n" +
                        "\tServer IP : {}\n" +
                        "\tConfig File : {}\n" +
                        "\tSpring Profiles : {}\n" +
                        "\tRuntime : {}\n" +
                        "--------------------------------------------------------------------------"
                , ServerUtils.getHostAddress()
                , environment.getProperty("spring.config.file")
                , environment.getActiveProfiles()
                , LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
    }

    public static void main(String[] args) throws Exception {
        SpringApplication application = new SpringApplication(ScheduleApplication.class);
        ConfigurableApplicationContext context = application.run(args);
    }
}