package cn.quant.andy.csv;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;

import java.io.FileReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

/**
 * Created by Administrator on 2021/7/19 0019.
 */
public class CSVReader {

    public static void read(int term, String file, int skip, CSVRecordHandler handler) throws Exception {
        Reader in = new FileReader(file);
//        Iterable<CSVRecord> records = CSVFormat.EXCEL.withHeader().parse(in);
        Iterable<CSVRecord> records = CSVFormat.DEFAULT.parse(in);
        for (CSVRecord record : records) {
            if (skip-- > 0) {
                continue;
            }
            String[] arrays = arrays(record);
            handler.read(term, record.getRecordNumber(), arrays);
//            return;
        }
    }

    private static String[] arrays(CSVRecord record) throws UnsupportedEncodingException {
        String[] strings = new String[record.size()];
        for (int i = 0, l = record.size(); i < l; i++) {
            strings[i] = record.get(i);
        }
        return strings;
    }

    public static void main(String[] args) {
//        try {
//            CSVReader.read(1, "D:\\workspace\\quant-andy\\1.0.0\\quant-andy-server\\template\\WX_2021-06-01_2021-06-30.txt"
//                    , 1
//                    , new CSVRecordHandler() {
//                        @Override
//                        public void read(int term, long number, String[] record) {
//
//                        }
//                    });
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
    }
}
