package cn.quant.andy.jpa.entity;

import cn.quant.spring.data.jpa.entity.DescriptionEntity;

import javax.persistence.Column;
import javax.persistence.Id;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;
import java.util.Objects;

public class InstitutionTransactionSummaryEntity extends DescriptionEntity {

    @Id
    @Column(name = "TRANSACTION_ID", nullable = false, updatable = false)
    private Long transactionId;

    @Column(name = "BASE_CODE", nullable = false, updatable = false)
    private String baseCode;

    @Column(name = "TERM_NO", nullable = false, updatable = false)
    private Integer termNo;

    @Column(name = "LEVEL_NO", nullable = false, updatable = false)
    private Integer levelNo;

    @Column(name = "TXN_CODE", nullable = false, updatable = false)
    private String txnCode;

    @Column(name = "TXN_TYPE", nullable = false, updatable = false)
    private String txnType;

    @Column(name = "TXN_NO", nullable = false, updatable = false)
    private String txnNo;

    @Column(name = "SERIAL_NO", nullable = false, updatable = false)
    private String serialNo;

    @Column(name = "TXN_FLAG", nullable = false, updatable = false)
    private String txnFlag;

    @Column(name = "BASE_ORDER_NO", nullable = false, updatable = false)
    private String baseOrderNo;

    @Column(name = "STATUS_CODE", nullable = false, updatable = false)
    private String statusCode;

    @Column(name = "PRODUCT_ORDER_NO", nullable = false, updatable = false)
    private String productOrderNo;

    @Column(name = "COMMODITY_NAME", nullable = false, updatable = false)
    private String commodityName;

    @Column(name = "BANK_CODE", nullable = false, updatable = false)
    private String bankCode;

    @Column(name = "BANK_ACCT_NO", nullable = false, updatable = false)
    private String bankAcctNo;

    @Column(name = "TXN_TIME", nullable = false, updatable = false)
    private Date txnTime;

    @Column(name = "POST_AMT", nullable = false, updatable = false)
    private BigDecimal postAmt;

    @Column(name = "POST_DATE", nullable = false, updatable = false)
    private LocalDate postDate;

    @Column(name = "POST_TIME", nullable = false, updatable = false)
    private LocalTime postTime;

    @Column(name = "IMPORT_TIME", nullable = false, updatable = false)
    private Date importTime;

    @Column(name = "POSTED_FLAG", nullable = false, updatable = true)
    private Boolean postedFlag;

    public Long getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(Long transactionId) {
        this.transactionId = transactionId;
    }

    public String getBaseCode() {
        return baseCode;
    }

    public void setBaseCode(String baseCode) {
        this.baseCode = baseCode;
    }

    public Integer getTermNo() {
        return termNo;
    }

    public void setTermNo(Integer termNo) {
        this.termNo = termNo;
    }

    public Integer getLevelNo() {
        return levelNo;
    }

    public void setLevelNo(Integer levelNo) {
        this.levelNo = levelNo;
    }

    public String getTxnType() {
        return txnType;
    }

    public void setTxnType(String txnType) {
        this.txnType = txnType;
    }

    public String getTxnCode() {
        return txnCode;
    }

    public void setTxnCode(String txnCode) {
        this.txnCode = txnCode;
    }

    public String getTxnNo() {
        return txnNo;
    }

    public void setTxnNo(String txnNo) {
        this.txnNo = txnNo;
    }

    public String getSerialNo() {
        return serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public String getTxnFlag() {
        return txnFlag;
    }

    public void setTxnFlag(String txnFlag) {
        this.txnFlag = txnFlag;
    }

    public String getBaseOrderNo() {
        return baseOrderNo;
    }

    public void setBaseOrderNo(String baseOrderNo) {
        this.baseOrderNo = baseOrderNo;
    }

    public String getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getProductOrderNo() {
        return productOrderNo;
    }

    public void setProductOrderNo(String productOrderNo) {
        this.productOrderNo = productOrderNo;
    }

    public String getCommodityName() {
        return commodityName;
    }

    public void setCommodityName(String commodityName) {
        this.commodityName = commodityName;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public String getBankAcctNo() {
        return bankAcctNo;
    }

    public void setBankAcctNo(String bankAcctNo) {
        this.bankAcctNo = bankAcctNo;
    }

    public Date getTxnTime() {
        return txnTime;
    }

    public void setTxnTime(Date txnTime) {
        this.txnTime = txnTime;
    }

    public BigDecimal getPostAmt() {
        return postAmt;
    }

    public void setPostAmt(BigDecimal postAmt) {
        this.postAmt = postAmt;
    }

    public LocalDate getPostDate() {
        return postDate;
    }

    public void setPostDate(LocalDate postDate) {
        this.postDate = postDate;
    }

    public LocalTime getPostTime() {
        return postTime;
    }

    public void setPostTime(LocalTime postTime) {
        this.postTime = postTime;
    }

    public Date getImportTime() {
        return importTime;
    }

    public void setImportTime(Date importTime) {
        this.importTime = importTime;
    }

    public Boolean getPostedFlag() {
        return postedFlag;
    }

    public void setPostedFlag(Boolean postedFlag) {
        this.postedFlag = postedFlag;
    }

    @Override
    public Object primaryKey() {
        return hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof InstitutionTransactionSummaryEntity)) return false;
        InstitutionTransactionSummaryEntity entity = (InstitutionTransactionSummaryEntity) o;
        return Objects.equals(transactionId, entity.transactionId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(InstitutionTransactionSummaryEntity.class, transactionId);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("InstitutionTransactionSummaryEntity{");
        sb.append("transactionId=").append(transactionId);
        sb.append(", baseCode='").append(baseCode).append('\'');
        sb.append(", termNo=").append(termNo);
        sb.append(", levelNo=").append(levelNo);
        sb.append(", txnCode='").append(txnCode).append('\'');
        sb.append(", txnType='").append(txnType).append('\'');
        sb.append(", txnNo='").append(txnNo).append('\'');
        sb.append(", serialNo='").append(serialNo).append('\'');
        sb.append(", txnFlag='").append(txnFlag).append('\'');
        sb.append(", baseOrderNo='").append(baseOrderNo).append('\'');
        sb.append(", statusCode='").append(statusCode).append('\'');
        sb.append(", productOrderNo='").append(productOrderNo).append('\'');
        sb.append(", commodityName='").append(commodityName).append('\'');
        sb.append(", bankCode='").append(bankCode).append('\'');
        sb.append(", bankAcctNo='").append(bankAcctNo).append('\'');
        sb.append(", txnTime=").append(txnTime);
        sb.append(", postAmt=").append(postAmt);
        sb.append(", postDate=").append(postDate);
        sb.append(", postTime=").append(postTime);
        sb.append(", importTime=").append(importTime);
        sb.append(", postedFlag=").append(postedFlag);
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}