package cn.quant.andy.jpa.entity;

import cn.quant.spring.data.jpa.entity.DescriptionEntity;

import javax.persistence.Column;
import javax.persistence.Id;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;

public class BalanceBillingEntity extends DescriptionEntity {

    @Id
    @Column(name = "TERM_NO", nullable = false, updatable = false)
    private Integer termNo;

    @Id
    @Column(name = "TYPE_CODE", nullable = false, updatable = false)
    private String typeCode;

    @Column(name = "NEXT_SUMMARY_NO", nullable = false, updatable = true)
    private Integer nextSummaryNo;

    @Column(name = "BALANCE", nullable = false, updatable = true)
    private BigDecimal balance;

    @Column(name = "CREDIT_AMT", nullable = false, updatable = true)
    private BigDecimal creditAmt;

    @Column(name = "CREDIT_COUNT", nullable = false, updatable = true)
    private Integer creditCount;

    @Column(name = "DEBIT_AMT", nullable = false, updatable = true)
    private BigDecimal debitAmt;

    @Column(name = "DEBIT_COUNT", nullable = false, updatable = true)
    private Integer debitCount;

    @Column(name = "STATUS_CODE", nullable = false, updatable = true)
    private String statusCode;

    @Column(name = "TARGET_BILLS", nullable = false, updatable = false)
    private Integer targetBills;

    @Column(name = "TOTAL_BILLS", nullable = false, updatable = true)
    private Integer totalBills;

    @Column(name = "LF_FAILED_BILLS", nullable = false, updatable = true)
    private Integer lfFailedBills;

    @Column(name = "RT_FAILED_BILLS", nullable = false, updatable = true)
    private Integer rtFailedBills;

    @Column(name = "LAST_STATUS_CODE", nullable = true, updatable = true)
    private String lastStatusCode;

    @Column(name = "BILL_DATE", nullable = true, updatable = true)
    private LocalDate billDate;

    public Integer getTermNo() {
        return termNo;
    }

    public void setTermNo(Integer termNo) {
        this.termNo = termNo;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public Integer getNextSummaryNo() {
        return nextSummaryNo;
    }

    public void setNextSummaryNo(Integer nextSummaryNo) {
        this.nextSummaryNo = nextSummaryNo;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getCreditAmt() {
        return creditAmt;
    }

    public void setCreditAmt(BigDecimal creditAmt) {
        this.creditAmt = creditAmt;
    }

    public Integer getCreditCount() {
        return creditCount;
    }

    public void setCreditCount(Integer creditCount) {
        this.creditCount = creditCount;
    }

    public BigDecimal getDebitAmt() {
        return debitAmt;
    }

    public void setDebitAmt(BigDecimal debitAmt) {
        this.debitAmt = debitAmt;
    }

    public Integer getDebitCount() {
        return debitCount;
    }

    public void setDebitCount(Integer debitCount) {
        this.debitCount = debitCount;
    }

    public String getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public Integer getTargetBills() {
        return targetBills;
    }

    public void setTargetBills(Integer targetBills) {
        this.targetBills = targetBills;
    }

    public Integer getTotalBills() {
        return totalBills;
    }

    public void setTotalBills(Integer totalBills) {
        this.totalBills = totalBills;
    }

    public Integer getLfFailedBills() {
        return lfFailedBills;
    }

    public void setLfFailedBills(Integer lfFailedBills) {
        this.lfFailedBills = lfFailedBills;
    }

    public Integer getRtFailedBills() {
        return rtFailedBills;
    }

    public void setRtFailedBills(Integer rtFailedBills) {
        this.rtFailedBills = rtFailedBills;
    }

    public String getLastStatusCode() {
        return lastStatusCode;
    }

    public void setLastStatusCode(String lastStatusCode) {
        this.lastStatusCode = lastStatusCode;
    }

    public LocalDate getBillDate() {
        return billDate;
    }

    public void setBillDate(LocalDate billDate) {
        this.billDate = billDate;
    }

    @Override
    public Object primaryKey() {
        return hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof BalanceBillingEntity)) return false;
        BalanceBillingEntity that = (BalanceBillingEntity) o;
        return Objects.equals(termNo, that.termNo) &&
                Objects.equals(typeCode, that.typeCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(BalanceBillingEntity.class, termNo, typeCode);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("BalanceBillingEntity{");
        sb.append("termNo=").append(termNo);
        sb.append(", typeCode='").append(typeCode).append('\'');
        sb.append(", nextSummaryNo=").append(nextSummaryNo);
        sb.append(", balance=").append(balance);
        sb.append(", creditAmt=").append(creditAmt);
        sb.append(", creditCount=").append(creditCount);
        sb.append(", debitAmt=").append(debitAmt);
        sb.append(", debitCount=").append(debitCount);
        sb.append(", statusCode='").append(statusCode).append('\'');
        sb.append(", targetBills=").append(targetBills);
        sb.append(", totalBills=").append(totalBills);
        sb.append(", lfFailedBills=").append(lfFailedBills);
        sb.append(", rtFailedBills=").append(rtFailedBills);
        sb.append(", lastStatusCode='").append(lastStatusCode).append('\'');
        sb.append(", billDate=").append(billDate);
        sb.append(',').append(super.toString());
        sb.append('}');
        return sb.toString();
    }
}